package com.ejianc.business.purchase.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 分包服务采购计划
 * 
 * @author generator
 * 
 */
public class SubPlanVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long projectId; // 项目ID
    private String projectName; // 项目名称
    private Long employeeId; // 编制人
    private String employeeName; // 编制人名称
    private String memo; // 备注
    private Integer billState; // 单据状态（审批必须字段）
    private String planName; // 计划名称
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private String orgCode; // 项目部编码
    private Long parentOrgId; // 父级组织
    private String parentOrgName; // 父级组织名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planDate; // 需用日期
    private String deptName; // 需用部门
    private Integer urgentState; // 紧急采购（0-否，1-是）
    private Integer sporadicState; // 是否零星采购（0-否，1-是）
    private Integer signState; // 是否签订合同（0-否，1-是）
    private String purchaseType; // 采购类别
    private String purchaseWay; // 采购方式
    private String subScope; // 分包范围
    private String valuationModel; // 计价模式
    private BigDecimal subjectMny; // 标的金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date purchaseDate; // 预计采购时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date enterDate; // 计划进场时间
    private String payScale; // 付款比例
    private String payWay; // 支付方式
    private String certification; // 分包资质要求
    private Integer duration; // 工期/供货期(月)
    private String sectionDivision; // 标段划分
    private String unitInfo; // 寻源单位信息
    private String materialNum; // 物资数量
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getPlanName() {
        return planName;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Date getPlanDate() {
        return planDate;
    }

    public void setPlanDate(Date planDate) {
        this.planDate = planDate;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public Integer getUrgentState() {
        return urgentState;
    }

    public void setUrgentState(Integer urgentState) {
        this.urgentState = urgentState;
    }
    public Integer getSporadicState() {
        return sporadicState;
    }

    public void setSporadicState(Integer sporadicState) {
        this.sporadicState = sporadicState;
    }
    public Integer getSignState() {
        return signState;
    }

    public void setSignState(Integer signState) {
        this.signState = signState;
    }
    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }
    public String getPurchaseWay() {
        return purchaseWay;
    }

    public void setPurchaseWay(String purchaseWay) {
        this.purchaseWay = purchaseWay;
    }
    public String getSubScope() {
        return subScope;
    }

    public void setSubScope(String subScope) {
        this.subScope = subScope;
    }
    public String getValuationModel() {
        return valuationModel;
    }

    public void setValuationModel(String valuationModel) {
        this.valuationModel = valuationModel;
    }
    public BigDecimal getSubjectMny() {
        return subjectMny;
    }

    public void setSubjectMny(BigDecimal subjectMny) {
        this.subjectMny = subjectMny;
    }
    public Date getPurchaseDate() {
        return purchaseDate;
    }

    public void setPurchaseDate(Date purchaseDate) {
        this.purchaseDate = purchaseDate;
    }
    public Date getEnterDate() {
        return enterDate;
    }

    public void setEnterDate(Date enterDate) {
        this.enterDate = enterDate;
    }
    public String getPayScale() {
        return payScale;
    }

    public void setPayScale(String payScale) {
        this.payScale = payScale;
    }
    public String getPayWay() {
        return payWay;
    }

    public void setPayWay(String payWay) {
        this.payWay = payWay;
    }
    public String getCertification() {
        return certification;
    }

    public void setCertification(String certification) {
        this.certification = certification;
    }
    public Integer getDuration() {
        return duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }
    public String getSectionDivision() {
        return sectionDivision;
    }

    public void setSectionDivision(String sectionDivision) {
        this.sectionDivision = sectionDivision;
    }
    public String getUnitInfo() {
        return unitInfo;
    }

    public void setUnitInfo(String unitInfo) {
        this.unitInfo = unitInfo;
    }
    public String getMaterialNum() {
        return materialNum;
    }

    public void setMaterialNum(String materialNum) {
        this.materialNum = materialNum;
    }
    
}
