package com.ejianc.business.sync.handler;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pub.utils.HttpTookit;
import com.ejianc.business.sync.consts.HTConstants;
import com.ejianc.business.sync.vo.PlanDto;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * @Author: caojie
 * @CreateTime:2025-03-17 10:38
 * @Version: 1.0
 */
@Component
public class HTSyncHandler {
    private  Logger logger = LoggerFactory.getLogger(HTSyncHandler.class);

    public String syncPlan(PlanDto planDto) {
        logger.info("采购计划推送华泰--------START---------");
        String url = HTConstants.PLAN_REQ_HOST + HTConstants.HT_PLAN_SYNC_URL;
        Map<String, Object> params = new HashMap<>();
        params.put("messageBody", new ArrayList<>(Arrays.asList(planDto)));
        params.put("unitAbbreviation", HTConstants.HT_UNIT_CODE);
        Map<String, String> headers = new HashMap<>();
        String result = null;
        try {
            logger.info("采购计划推送华泰url-：{}，参数：{}", url, JSONObject.toJSONString(params));
            result = HttpTookit.postByJson(url, JSONObject.toJSONString(params), headers);
            logger.info("采购计划推送华泰结果：{}", result);
            JSONObject resultJson = JSONObject.parseObject(result);
            if("true".equals(resultJson.getString("success"))) {
                logger.info("采购计划推送华泰成功********SUCCESS**********");
            } else {
                logger.info("采购计划推送华泰失败********FAILURE**********");
            }
        } catch (Exception e) {
            logger.error("采购计划推送华泰异常，", e);
            return "失败";
        }
        logger.info("采购计划推送华泰--------END---------");
        return result;
    }

    public String getPlan(String outPlanNo){
        logger.info("采购计划查询华泰--------START---------");
        String url = HTConstants.PLAN_REQ_HOST + HTConstants.HT_PLAN_GET_URL;
        Map<String, Object> params = new HashMap<>();
        params.put("sysCode", HTConstants.HT_UNIT_CODE);
        params.put("pageNum", 1);
        params.put("pageSize", 10);
        params.put("traceId", "");
        params.put("id", 0);
        params.put("jsonData", "");
        params.put("planNo", "");
        params.put("createDate", "");
        params.put("status", "");
        params.put("createOrgCode", "");
        params.put("orgCode", "");
        if(StringUtils.isNotEmpty(outPlanNo)){
            params.put("outPlanNo", outPlanNo);
        }
        Map<String, String> headers = new HashMap<>();
        String result = null;
        try {
            logger.info("采购计划查询华泰url-：{}，参数：{}", url, JSONObject.toJSONString(params));
            result = HttpTookit.postByJson(url, JSONObject.toJSONString(params), headers);
            logger.info("采购计划查询华泰结果：{}", result);
            JSONObject resultJson = JSONObject.parseObject(result);
            if("true".equals(resultJson.getString("success"))) {
                logger.info("采购计划查询华泰成功********SUCCESS**********");
            } else {
                logger.info("采购计划查询华泰失败********FAILURE**********");
            }
        } catch (Exception e) {
            logger.error("采购计划查询华泰异常，", e);
            return "失败";
        }
        logger.info("采购计划查询华泰--------END---------");
        return result;
    }

}
