package com.ejianc.business.purchasingmanagement.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.purchasingmanagement.bean.*;
import com.ejianc.business.purchasingmanagement.service.*;
import com.ejianc.business.purchasingmanagement.vo.*;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/api/purchasingmanagement/purchaseListApi/")
public class PurchaseListApi {
    @Autowired
    private IPurchaseContractService service;
    @Autowired
    private IMaterialpaymentService materialpaymentService;//

    @Autowired
    private ITransporterpaymentService transporterpaymentService;//运输商付款单

    @Autowired
    private IPurchasetransportationService purchasetransportationService;//采购运输单

    @Autowired
    private IShippersinvoiceService shippersinvoiceService;//运输商发票


    @Autowired
    private ISupplierinvoiceService supplierinvoiceService;//供应商发票
    /**
     * @Description  采购合同查询列表
     */
    @RequestMapping(value = "/contractList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PurchaseContractVO>> contractList(@RequestBody RequestVO requestVO) {
        QueryParam param = new QueryParam();
        param.setPageIndex(requestVO.getPageIndex());
        param.setPageSize(requestVO.getPageSize());
        param.getParams().put("supplierinfo_id", new Parameter(QueryParam.EQ,requestVO.getId()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ,0));
        param.getOrderMap().put("create_time",QueryParam.DESC);
        IPage<PurchaseContractEntity> page = service.queryPage(param,false);
        IPage<PurchaseContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchaseContractVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description  供应商付款单查询列表
     */
    @RequestMapping(value = "/receiptList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialpaymentVO>> receiptList(@RequestBody RequestVO requestVO) {
        QueryParam param = new QueryParam();
        param.setPageIndex(requestVO.getPageIndex());
        param.setPageSize(requestVO.getPageSize());
        param.getParams().put("supplierinfo_id", new Parameter(QueryParam.EQ,requestVO.getId()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ,0));
        param.getOrderMap().put("create_time",QueryParam.DESC);
        IPage<MaterialpaymentEntity> page = materialpaymentService.queryPage(param,false);
        IPage<MaterialpaymentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialpaymentVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description  运输商付款单查询列表
     */
    @RequestMapping(value = "/transportersReceiptList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TransporterpaymentVO>> transportersReceiptList(@RequestBody RequestVO requestVO) {
        QueryParam param = new QueryParam();
        param.setPageIndex(requestVO.getPageIndex());
        param.setPageSize(requestVO.getPageSize());
        param.getParams().put("shippers_id", new Parameter(QueryParam.EQ,requestVO.getId()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ,0));
        param.getOrderMap().put("create_time",QueryParam.DESC);
        IPage<TransporterpaymentEntity> page = transporterpaymentService.queryPage(param,false);
        IPage<TransporterpaymentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), TransporterpaymentVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description  采购运输单查询列表
     */
    @RequestMapping(value = "/shippingList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PurchasetransportationVO>> shippingList(@RequestBody RequestVO requestVO) {
        QueryParam param = new QueryParam();
        param.setPageIndex(requestVO.getPageIndex());
        param.setPageSize(requestVO.getPageSize());
        param.getParams().put("shippers_id", new Parameter(QueryParam.EQ,requestVO.getId()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ,0));
        param.getOrderMap().put("create_time",QueryParam.DESC);
        IPage<PurchasetransportationEntity> page = purchasetransportationService.queryPage(param,false);
        IPage<PurchasetransportationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchasetransportationVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description  运输商发票列表
     */
    @RequestMapping(value = "/shippersinvoiceList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ShippersinvoiceVO>> shippersinvoiceList(@RequestBody RequestVO requestVO) {
        QueryParam param = new QueryParam();
        param.setPageIndex(requestVO.getPageIndex());
        param.setPageSize(requestVO.getPageSize());
        param.getParams().put("shippers_id", new Parameter(QueryParam.EQ,requestVO.getId()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ,0));
        param.getOrderMap().put("create_time",QueryParam.DESC);
        IPage<ShippersinvoiceEntity> page = shippersinvoiceService.queryPage(param,false);
        IPage<ShippersinvoiceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ShippersinvoiceVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description  供应商发票列表
     */
    @RequestMapping(value = "/supplierinvoiceList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SupplierinvoiceVO>> supplierinvoiceList(@RequestBody RequestVO requestVO) {
        QueryParam param = new QueryParam();
        param.setPageIndex(requestVO.getPageIndex());
        param.setPageSize(requestVO.getPageSize());
        param.getParams().put("supplierinfo_id", new Parameter(QueryParam.EQ,requestVO.getId()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ,0));
        param.getOrderMap().put("create_time",QueryParam.DESC);
        IPage<SupplierinvoiceEntity> page = supplierinvoiceService.queryPage(param,false);
        IPage<SupplierinvoiceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SupplierinvoiceVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
}
