package com.ejianc.business.purchasingmanagement.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 采购合同明细
 * 
 * @author generator
 * 
 */
public class PurchasecontractdetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long purchasecontractId; // 采购合同主键

    private Long materialId; // 原材类主键
    private String materialName; // 原材类名称
    private BigDecimal price; // 单价
    private BigDecimal quantity; // 数量
    private Long manufacturerId; // 生产厂商主键
    private String manufacturerName; // 生产厂商名称
    private Integer freight; // 有无运费：1有运费 0无
    private Long distance; // 运距
    private Integer shippingMethod; // 运费计算方式
    private String remark; // 备注
    private BigDecimal materialTax; // 材料税率
    private BigDecimal freightRate; // 运费税率
    private BigDecimal sjyfPrice; // 实际运费单价
    private BigDecimal kpyfPrice; // 开票运费单价
    private BigDecimal comprehensiveTaxRate; // 综合税率
    private BigDecimal combinedTax; // 结合税额
    private String dyyss; // 打印运输商
    private Long shippersId; // 运输商主键
    private String shippersName; // 运输商名称


    @ReferSerialTransfer(referCode="MaterialRef")
    public Long getMaterialId() {
        return materialId;
    }
    @ReferDeserialTransfer
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public Long getPurchasecontractId() {
        return purchasecontractId;
    }

    public void setPurchasecontractId(Long purchasecontractId) {
        this.purchasecontractId = purchasecontractId;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    @ReferSerialTransfer(referCode="ManufacturerRef")
    public Long getManufacturerId() {
        return manufacturerId;
    }
    @ReferDeserialTransfer
    public void setManufacturerId(Long manufacturerId) {
        this.manufacturerId = manufacturerId;
    }
    public String getManufacturerName() {
        return manufacturerName;
    }

    public void setManufacturerName(String manufacturerName) {
        this.manufacturerName = manufacturerName;
    }
    public Integer getFreight() {
        return freight;
    }

    public void setFreight(Integer freight) {
        this.freight = freight;
    }
    public Long getDistance() {
        return distance;
    }

    public void setDistance(Long distance) {
        this.distance = distance;
    }

    public Integer getShippingMethod() {
        return shippingMethod;
    }

    public void setShippingMethod(Integer shippingMethod) {
        this.shippingMethod = shippingMethod;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public BigDecimal getSjyfPrice() {
        return sjyfPrice;
    }

    public void setSjyfPrice(BigDecimal sjyfPrice) {
        this.sjyfPrice = sjyfPrice;
    }
    public BigDecimal getKpyfPrice() {
        return kpyfPrice;
    }

    public void setKpyfPrice(BigDecimal kpyfPrice) {
        this.kpyfPrice = kpyfPrice;
    }

    public String getDyyss() {
        return dyyss;
    }

    public void setDyyss(String dyyss) {
        this.dyyss = dyyss;
    }
    @ReferSerialTransfer(referCode="ShippersRef")
    public Long getShippersId() {
        return shippersId;
    }
    @ReferDeserialTransfer
    public void setShippersId(Long shippersId) {
        this.shippersId = shippersId;
    }
    public String getShippersName() {
        return shippersName;
    }

    public void setShippersName(String shippersName) {
        this.shippersName = shippersName;
    }

    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getMaterialTax() {
        return materialTax;
    }

    public void setMaterialTax(BigDecimal materialTax) {
        this.materialTax = materialTax;
    }

    public BigDecimal getFreightRate() {
        return freightRate;
    }

    public void setFreightRate(BigDecimal freightRate) {
        this.freightRate = freightRate;
    }

    public BigDecimal getComprehensiveTaxRate() {
        return comprehensiveTaxRate;
    }

    public void setComprehensiveTaxRate(BigDecimal comprehensiveTaxRate) {
        this.comprehensiveTaxRate = comprehensiveTaxRate;
    }

    public BigDecimal getCombinedTax() {
        return combinedTax;
    }

    public void setCombinedTax(BigDecimal combinedTax) {
        this.combinedTax = combinedTax;
    }
}
