package com.ejianc.business.purchasingmanagement.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 采购运费验收
 * 
 * @author generator
 * 
 */
public class TransportationacceptanceVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long shippersId; // 运输商主键
    private String shippersName; // 运输商名称
    private BigDecimal quantity; // 数量
    private BigDecimal price; // 单价
    private BigDecimal money; // 金额
    private BigDecimal taxRate; // 税率
    private BigDecimal tax; // 税额
    private BigDecimal totalAmount; // 总计
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private String billCode; // 单据编号
    private Integer status; //是否确认  0,未确认  1,已确认
    private Date  acceptanceDate;//验收日期
    private Integer shippingType; //运费类型   0，自动 1,手动
    private BigDecimal amountPaid; // 已支付金额
    private BigDecimal amountNotPaid; // 未支付金额
    private BigDecimal invoiceReceived; // 已收发票金额
    private BigDecimal invoiceNotReceived; // 未收发票金额
    private List<TransportationdetailVO> transportationdetailList = new ArrayList<>(); // 采购运费验收明细表

    public BigDecimal getAmountPaid() {
        return amountPaid;
    }

    public void setAmountPaid(BigDecimal amountPaid) {
        this.amountPaid = amountPaid;
    }

    public BigDecimal getAmountNotPaid() {
        return amountNotPaid;
    }

    public void setAmountNotPaid(BigDecimal amountNotPaid) {
        this.amountNotPaid = amountNotPaid;
    }

    public BigDecimal getInvoiceReceived() {
        return invoiceReceived;
    }

    public void setInvoiceReceived(BigDecimal invoiceReceived) {
        this.invoiceReceived = invoiceReceived;
    }

    public BigDecimal getInvoiceNotReceived() {
        return invoiceNotReceived;
    }

    public void setInvoiceNotReceived(BigDecimal invoiceNotReceived) {
        this.invoiceNotReceived = invoiceNotReceived;
    }

    public Integer getShippingType() {
        return shippingType;
    }

    public void setShippingType(Integer shippingType) {
        this.shippingType = shippingType;
    }

    public Date getAcceptanceDate() {
        return acceptanceDate;
    }

    public void setAcceptanceDate(Date acceptanceDate) {
        this.acceptanceDate = acceptanceDate;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public List<TransportationdetailVO> getTransportationdetailList() {
        return transportationdetailList;
    }

    public void setTransportationdetailList(List<TransportationdetailVO> transportationdetailList) {
        this.transportationdetailList = transportationdetailList;
    }

    @ReferSerialTransfer(referCode="ShippersRef")
    public Long getShippersId() {
        return shippersId;
    }

    @ReferDeserialTransfer
    public void setShippersId(Long shippersId) {
        this.shippersId = shippersId;
    }
    public String getShippersName() {
        return shippersName;
    }

    public void setShippersName(String shippersName) {
        this.shippersName = shippersName;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    
}
