/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.purchasingmanagement.controller.api;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.purchasingmanagement.bean.PurchasetransportationEntity;
import com.ejianc.business.purchasingmanagement.service.IMaterialpaymentService;
import com.ejianc.business.purchasingmanagement.service.IPurchaseContractService;
import com.ejianc.business.purchasingmanagement.service.IPurchasetransportationService;
import com.ejianc.business.purchasingmanagement.service.IShippersinvoiceService;
import com.ejianc.business.purchasingmanagement.service.ISupplierinvoiceService;
import com.ejianc.business.purchasingmanagement.service.ITransporterpaymentService;
import com.ejianc.business.purchasingmanagement.vo.MaterialpaymentVO;
import com.ejianc.business.purchasingmanagement.vo.PurchaseContractVO;
import com.ejianc.business.purchasingmanagement.vo.PurchasetransportationVO;
import com.ejianc.business.purchasingmanagement.vo.RequestVO;
import com.ejianc.business.purchasingmanagement.vo.ShippersinvoiceVO;
import com.ejianc.business.purchasingmanagement.vo.SupplierinvoiceVO;
import com.ejianc.business.purchasingmanagement.vo.TransporterpaymentVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/purchasingmanagement/purchaseListApi/"})
public class PurchaseListApi {
    @Autowired
    private IPurchaseContractService service;
    @Autowired
    private IMaterialpaymentService materialpaymentService;
    @Autowired
    private ITransporterpaymentService transporterpaymentService;
    @Autowired
    private IPurchasetransportationService purchasetransportationService;
    @Autowired
    private IShippersinvoiceService shippersinvoiceService;
    @Autowired
    private ISupplierinvoiceService supplierinvoiceService;

    @RequestMapping(value={"/contractList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PurchaseContractVO>> contractList(@RequestBody RequestVO requestVO) {
        QueryParam param = new QueryParam();
        param.setPageIndex(requestVO.getPageIndex());
        param.setPageSize(requestVO.getPageSize());
        param.getParams().put("supplierinfo_id", new Parameter("eq", (Object)requestVO.getId()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getOrderMap().put("create_time", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PurchaseContractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/receiptList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaterialpaymentVO>> receiptList(@RequestBody RequestVO requestVO) {
        QueryParam param = new QueryParam();
        param.setPageIndex(requestVO.getPageIndex());
        param.setPageSize(requestVO.getPageSize());
        param.getParams().put("supplierinfo_id", new Parameter("eq", (Object)requestVO.getId()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getOrderMap().put("create_time", "desc");
        IPage page = this.materialpaymentService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialpaymentVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/transportersReceiptList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TransporterpaymentVO>> transportersReceiptList(@RequestBody RequestVO requestVO) {
        QueryParam param = new QueryParam();
        param.setPageIndex(requestVO.getPageIndex());
        param.setPageSize(requestVO.getPageSize());
        param.getParams().put("shippers_id", new Parameter("eq", (Object)requestVO.getId()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getOrderMap().put("create_time", "desc");
        IPage page = this.transporterpaymentService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TransporterpaymentVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/shippingList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PurchasetransportationVO>> shippingList(@RequestBody RequestVO requestVO) {
        QueryParam param = new QueryParam();
        param.setPageIndex(requestVO.getPageIndex());
        param.setPageSize(requestVO.getPageSize());
        param.getParams().put("shippers_id", new Parameter("eq", (Object)requestVO.getId()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getOrderMap().put("create_time", "desc");
        IPage page = this.purchasetransportationService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PurchasetransportationVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/shippersinvoiceList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ShippersinvoiceVO>> shippersinvoiceList(@RequestBody RequestVO requestVO) {
        QueryParam param = new QueryParam();
        param.setPageIndex(requestVO.getPageIndex());
        param.setPageSize(requestVO.getPageSize());
        param.getParams().put("shippers_id", new Parameter("eq", (Object)requestVO.getId()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getOrderMap().put("create_time", "desc");
        IPage page = this.shippersinvoiceService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ShippersinvoiceVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/supplierinvoiceList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SupplierinvoiceVO>> supplierinvoiceList(@RequestBody RequestVO requestVO) {
        QueryParam param = new QueryParam();
        param.setPageIndex(requestVO.getPageIndex());
        param.setPageSize(requestVO.getPageSize());
        param.getParams().put("supplierinfo_id", new Parameter("eq", (Object)requestVO.getId()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getOrderMap().put("create_time", "desc");
        IPage page = this.supplierinvoiceService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SupplierinvoiceVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/shipping"}, method={RequestMethod.POST})
    @ResponseBody
    CommonResponse<PurchasetransportationVO> shipping(@RequestBody PurchasetransportationVO purchasetransportationVO) {
        PurchasetransportationEntity entity = (PurchasetransportationEntity)((Object)this.purchasetransportationService.selectById(purchasetransportationVO.getId()));
        PurchasetransportationVO vo = (PurchasetransportationVO)((Object)BeanMapper.map((Object)((Object)entity), PurchasetransportationVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/saveShipping"}, method={RequestMethod.POST})
    @ResponseBody
    CommonResponse<PurchasetransportationVO> saveShipping(@RequestBody PurchasetransportationVO purchasetransportationVO) {
        return this.purchasetransportationService.saveOrupdate(purchasetransportationVO);
    }

    @RequestMapping(value={"/supplierShippingList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PurchasetransportationVO>> supplierShippingList(@RequestBody RequestVO requestVO) {
        QueryParam param = new QueryParam();
        param.setPageIndex(requestVO.getPageIndex());
        param.setPageSize(requestVO.getPageSize());
        param.getParams().put("supplierinfo_id", new Parameter("eq", (Object)requestVO.getId()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getOrderMap().put("create_time", "desc");
        IPage page = this.purchasetransportationService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PurchasetransportationVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

