/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.purchasingmanagement.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.purchasingmanagement.bean.MaterialplanEntity;
import com.ejianc.business.purchasingmanagement.bean.PurchasecontractdetailEntity;
import com.ejianc.business.purchasingmanagement.bean.PurchasetransportationEntity;
import com.ejianc.business.purchasingmanagement.mapper.MaterialplanMapper;
import com.ejianc.business.purchasingmanagement.service.IMaterialplanService;
import com.ejianc.business.purchasingmanagement.service.IPurchasecontractdetailService;
import com.ejianc.business.purchasingmanagement.service.IPurchasetransportationService;
import com.ejianc.business.purchasingmanagement.vo.MaterialplanVO;
import com.ejianc.business.purchasingmanagement.vo.PurchasetransportationVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="materialplanService")
public class MaterialplanServiceImpl
extends BaseServiceImpl<MaterialplanMapper, MaterialplanEntity>
implements IMaterialplanService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IMaterialplanService service;
    @Autowired
    private IPurchasetransportationService purchasetransportationService;
    @Autowired
    private IPurchasecontractdetailService purchasecontractdetailService;

    @Override
    public CommonResponse<MaterialplanVO> saveChange(MaterialplanVO saveChangeVO) {
        MaterialplanEntity entity = (MaterialplanEntity)((Object)BeanMapper.map((Object)((Object)saveChangeVO), MaterialplanEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveChangeVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        PurchasecontractdetailEntity purchasecontractdetailEntity = (PurchasecontractdetailEntity)((Object)this.purchasecontractdetailService.selectById(entity.getPurchasecontractdetailId()));
        entity.setPrice(purchasecontractdetailEntity.getPrice());
        entity.setMaterialTax(purchasecontractdetailEntity.getMaterialTax());
        entity.setFreightRate(purchasecontractdetailEntity.getFreightRate());
        this.service.saveOrUpdate((Object)entity, false);
        MaterialplanVO vo = (MaterialplanVO)((Object)BeanMapper.map((Object)((Object)entity), MaterialplanVO.class));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"materialplan_id", (Object)vo.getId());
        queryWrapper.eq((Object)"dr", (Object)"0");
        PurchasetransportationEntity page = (PurchasetransportationEntity)((Object)this.purchasetransportationService.getOne((Wrapper)queryWrapper));
        if (page == null) {
            PurchasetransportationVO purchasetransportationVO = new PurchasetransportationVO();
            purchasetransportationVO.setMaterialplanId(vo.getId());
            purchasetransportationVO.setSupplierinfoId(vo.getSupplierinfoId());
            purchasetransportationVO.setSupplierinfoName(vo.getSupplierinfoName());
            purchasetransportationVO.setMaterialId(vo.getMaterialId());
            purchasetransportationVO.setMaterialName(vo.getMaterialName());
            purchasetransportationVO.setRequiredQuantity(vo.getQuantity());
            purchasetransportationVO.setReceivingaddressId(vo.getMddId());
            purchasetransportationVO.setReceivingAddress(vo.getMddName());
            purchasetransportationVO.setOrgId(vo.getOrgId());
            purchasetransportationVO.setOrgName(vo.getOrgName());
            purchasetransportationVO.setShippersId(purchasecontractdetailEntity.getShippersId());
            purchasetransportationVO.setShippersName(purchasecontractdetailEntity.getShippersName());
            purchasetransportationVO.setUnitPrice(purchasecontractdetailEntity.getSjyfPrice());
            purchasetransportationVO.setDistance(purchasecontractdetailEntity.getDistance());
            purchasetransportationVO.setStartingTime(vo.getStarDate());
            purchasetransportationVO.setEndTime(vo.getEndDate());
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)purchasetransportationVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                PurchasetransportationEntity entity1 = (PurchasetransportationEntity)((Object)BeanMapper.map((Object)((Object)purchasetransportationVO), PurchasetransportationEntity.class));
                entity1.setBillCode((String)billCode.getData());
                this.purchasetransportationService.saveOrUpdate((Object)entity1, false);
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }
}

