package com.ejianc.business.purchasingmanagement.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 采购材料验收
 * 
 * @author generator
 * 
 */
 @TableName("ejc_purchasingmanagement_materialacceptance")
public class MaterialacceptanceEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @TableField(value="materialplan_id")
    private Long materialplanId; // 定料计划主键
    @TableField(value="materialplan_name")
    private String materialplanName; // 定料计划名称
    @TableField(value="supplierinfo_id")
    private Long supplierinfoId; // 供应商基本档案主键
    @TableField(value="supplierinfo_name")
    private String supplierinfoName; // 供应商基本档案名称
    @TableField(value="acceptance_quantity")
    private BigDecimal acceptanceQuantity; // 验收数量
    @TableField(value="price")
    private BigDecimal price; // 单价
    @TableField(value="amount")
    private BigDecimal amount; // 金额
    @TableField(value="taxRate")
    private BigDecimal taxrate; // 税率
    @TableField(value="tax")
    private BigDecimal tax;//税额
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="acceptance_date")
    private  Date acceptanceDate;  //验收时间
    @TableField(value="issued_quantity")
    private BigDecimal issuedQuantity; // 已发数量
    @TableField(value="quantity_received")
    private BigDecimal quantityReceived; // 已收数量
    @TableField(value="material_id")
    private Long materialId; // 原材类主键
    @TableField(value="material_name")
    private String materialName; // 原材类名称
    @TableField(value="freight_rate")
    private BigDecimal freightRate; // 运费税率
    @TableField(value="freight_tax")
    private BigDecimal freightTax; // 运费税额
    @TableField(value="total_amount")
    private BigDecimal totalAmount; // 合计金额
    @TableField(value="total_cargo")
    private BigDecimal totalCargo; // 货物合计金额
    @TableField(value="total_freight")
    private BigDecimal totalFreight; // 运费合计金额
    @TableField(value="confirm_status")
    private Integer confirmStatus; //是否确认 1，确认  0，未确认
    @TableField(value="amount_paid")
    private BigDecimal amountPaid; // 已支付金额
    @TableField(value="amount_not_paid")
    private BigDecimal amountNotPaid; // 未支付金额
    @TableField(value="invoice_received")
    private BigDecimal invoiceReceived; // 已收发票金额
    @TableField(value="invoice_not_received")
    private BigDecimal invoiceNotReceived; // 未收发票金额



    @TableField(exist=false)
    @SubEntity(serviceName="materialacceptancedetailService" ,pidName = "materialacceptanceId")//此处有pid="xxx"，默认值pid="pid"
    private List<MaterialacceptancedetailEntity> materialacceptancedetailList = new ArrayList<>(); // 采购材料验收明细表

    public BigDecimal getAmountPaid() {
        return amountPaid;
    }

    public void setAmountPaid(BigDecimal amountPaid) {
        this.amountPaid = amountPaid;
    }

    public BigDecimal getAmountNotPaid() {
        return amountNotPaid;
    }

    public void setAmountNotPaid(BigDecimal amountNotPaid) {
        this.amountNotPaid = amountNotPaid;
    }

    public BigDecimal getInvoiceReceived() {
        return invoiceReceived;
    }

    public void setInvoiceReceived(BigDecimal invoiceReceived) {
        this.invoiceReceived = invoiceReceived;
    }

    public BigDecimal getInvoiceNotReceived() {
        return invoiceNotReceived;
    }

    public void setInvoiceNotReceived(BigDecimal invoiceNotReceived) {
        this.invoiceNotReceived = invoiceNotReceived;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public void setAcceptanceQuantity(BigDecimal acceptanceQuantity) {
        this.acceptanceQuantity = acceptanceQuantity;
    }

    public void setTaxrate(BigDecimal taxrate) {
        this.taxrate = taxrate;
    }

    public BigDecimal getIssuedQuantity() {
        return issuedQuantity;
    }

    public void setIssuedQuantity(BigDecimal issuedQuantity) {
        this.issuedQuantity = issuedQuantity;
    }

    public BigDecimal getQuantityReceived() {
        return quantityReceived;
    }

    public void setQuantityReceived(BigDecimal quantityReceived) {
        this.quantityReceived = quantityReceived;
    }

    public BigDecimal getFreightRate() {
        return freightRate;
    }

    public void setFreightRate(BigDecimal freightRate) {
        this.freightRate = freightRate;
    }

    public BigDecimal getFreightTax() {
        return freightTax;
    }

    public void setFreightTax(BigDecimal freightTax) {
        this.freightTax = freightTax;
    }

    public Integer getConfirmStatus() {
        return confirmStatus;
    }

    public void setConfirmStatus(Integer confirmStatus) {
        this.confirmStatus = confirmStatus;
    }


    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }


    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BigDecimal getTotalCargo() {
        return totalCargo;
    }

    public void setTotalCargo(BigDecimal totalCargo) {
        this.totalCargo = totalCargo;
    }

    public BigDecimal getTotalFreight() {
        return totalFreight;
    }

    public void setTotalFreight(BigDecimal totalFreight) {
        this.totalFreight = totalFreight;
    }

    public Date getAcceptanceDate() {
        return acceptanceDate;
    }

    public void setAcceptanceDate(Date acceptanceDate) {
        this.acceptanceDate = acceptanceDate;
    }

    public List<MaterialacceptancedetailEntity> getMaterialacceptancedetailList() {
        return materialacceptancedetailList;
    }

    public void setMaterialacceptancedetailList(List<MaterialacceptancedetailEntity> materialacceptancedetailList) {
        this.materialacceptancedetailList = materialacceptancedetailList;
    }

    public BigDecimal getAcceptanceQuantity() {
        return acceptanceQuantity;
    }

    public BigDecimal getTaxrate() {
        return taxrate;
    }

    public Long getMaterialplanId() {
        return materialplanId;
    }

    public void setMaterialplanId(Long materialplanId) {
        this.materialplanId = materialplanId;
    }
    public String getMaterialplanName() {
        return materialplanName;
    }

    public void setMaterialplanName(String materialplanName) {
        this.materialplanName = materialplanName;
    }
    public Long getSupplierinfoId() {
        return supplierinfoId;
    }

    public void setSupplierinfoId(Long supplierinfoId) {
        this.supplierinfoId = supplierinfoId;
    }
    public String getSupplierinfoName() {
        return supplierinfoName;
    }

    public void setSupplierinfoName(String supplierinfoName) {
        this.supplierinfoName = supplierinfoName;
    }


    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    
}
