package com.ejianc.business.purchasingmanagement.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 供应商付款单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_purchasingmanagement_materialpayment")
public class MaterialpaymentEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="supplierinfo_id")
    private Long supplierinfoId; // 供应商基本档案主键
    @TableField(value="supplierinfo_name")
    private String supplierinfoName; // 供应商基本档案名称
    @TableField(value="refund")
    private Integer refund; // 是否退款
    @TableField(value="supplierinfo_bank_id")
    private Long supplierinfoBankId; // 供应商银行账户ID
    @TableField(value="supplierinfo_bank_name")
    private String supplierinfoBankName; // 供应商银行账户
    @TableField(value="payment_date")
    private Date paymentDate; // 日期
    @TableField(value="payment_type")
    private Long paymentType; // 付款类型
    @TableField(value="payment_type_name")
    private String paymentTypeName; // 付款类型
    @TableField(value="payment_amount")
    private BigDecimal paymentAmount; // 付款额
    @TableField(value="summary")
    private String summary; // 摘要
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="receipt_number")
    private  String receiptNumber;//收据号
    @TableField(value="bank_code")
    private String bankCode;//银行账号
    @TableField(value="not_distribution_money")
    private  BigDecimal notDistributionMoney ;//未分配金额

    @TableField(exist=false)
    @SubEntity(serviceName="materialpaymentdetailService" , pidName ="materialpaymentId")
    private List<MaterialpaymentdetailEntity> materialpaymentdetailList = new ArrayList<>(); // 供应商验收明细

    public BigDecimal getNotDistributionMoney() {
        return notDistributionMoney;
    }

    public void setNotDistributionMoney(BigDecimal notDistributionMoney) {
        this.notDistributionMoney = notDistributionMoney;
    }

    public List<MaterialpaymentdetailEntity> getMaterialpaymentdetailList() {
        return materialpaymentdetailList;
    }

    public void setMaterialpaymentdetailList(List<MaterialpaymentdetailEntity> materialpaymentdetailList) {
        this.materialpaymentdetailList = materialpaymentdetailList;
    }

    public String getBankCode() {
        return bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public String getReceiptNumber() {
        return receiptNumber;
    }

    public void setReceiptNumber(String receiptNumber) {
        this.receiptNumber = receiptNumber;
    }

    public Long getPaymentType() {
        return paymentType;
    }

    public void setPaymentType(Long paymentType) {
        this.paymentType = paymentType;
    }

    public String getPaymentTypeName() {
        return paymentTypeName;
    }

    public void setPaymentTypeName(String paymentTypeName) {
        this.paymentTypeName = paymentTypeName;
    }

    public Long getSupplierinfoId() {
        return supplierinfoId;
    }

    public void setSupplierinfoId(Long supplierinfoId) {
        this.supplierinfoId = supplierinfoId;
    }
    public String getSupplierinfoName() {
        return supplierinfoName;
    }

    public void setSupplierinfoName(String supplierinfoName) {
        this.supplierinfoName = supplierinfoName;
    }
    public Integer getRefund() {
        return refund;
    }

    public void setRefund(Integer refund) {
        this.refund = refund;
    }
    public Long getSupplierinfoBankId() {
        return supplierinfoBankId;
    }

    public void setSupplierinfoBankId(Long supplierinfoBankId) {
        this.supplierinfoBankId = supplierinfoBankId;
    }
    public String getSupplierinfoBankName() {
        return supplierinfoBankName;
    }

    public void setSupplierinfoBankName(String supplierinfoBankName) {
        this.supplierinfoBankName = supplierinfoBankName;
    }
    public Date getPaymentDate() {
        return paymentDate;
    }

    public void setPaymentDate(Date paymentDate) {
        this.paymentDate = paymentDate;
    }

    public BigDecimal getPaymentAmount() {
        return paymentAmount;
    }

    public void setPaymentAmount(BigDecimal paymentAmount) {
        this.paymentAmount = paymentAmount;
    }
    public String getSummary() {
        return summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    
}
