package com.ejianc.business.purchasingmanagement.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.purchasingmanagement.bean.MaterialplanEntity;
import com.ejianc.business.purchasingmanagement.bean.TransporterpaymentEntity;
import com.ejianc.business.purchasingmanagement.service.IMaterialacceptancedetailService;
import com.ejianc.business.purchasingmanagement.service.IMaterialplanService;
import com.ejianc.business.purchasingmanagement.service.ITransportationacceptanceService;
import com.ejianc.business.purchasingmanagement.vo.MaterialplanVO;
import com.ejianc.business.purchasingmanagement.vo.SupplierinvoicedetialVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.purchasingmanagement.bean.PurchasereceiptEntity;
import com.ejianc.business.purchasingmanagement.service.IPurchasereceiptService;
import com.ejianc.business.purchasingmanagement.vo.PurchasereceiptVO;

/**
 * 采购收货信息
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("purchasereceipt")
public class PurchasereceiptController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IPurchasereceiptService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IMaterialplanService materialplanService;
    @Autowired
    private IMaterialacceptancedetailService materialacceptancedetailService;
    @Autowired
    private ITransportationacceptanceService transportationacceptanceService;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PurchasereceiptVO> saveOrUpdate(@RequestBody PurchasereceiptVO saveOrUpdateVO) {
    	return service.saveChange(saveOrUpdateVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PurchasereceiptVO> queryDetail(Long id) {
    	PurchasereceiptEntity entity = service.selectById(id);
    	PurchasereceiptVO vo = BeanMapper.map(entity, PurchasereceiptVO.class);

        QueryWrapper<MaterialplanEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("id",id);
        queryWrapper.eq("dr",0);
        List<MaterialplanEntity>   materialplanEntities= materialplanService.list(queryWrapper);
        List<MaterialplanVO> materialplanVOList = new ArrayList<>();
        for (MaterialplanEntity temp : materialplanEntities) {
            MaterialplanVO materialplanVO = BeanMapper.map(temp, MaterialplanVO.class);
            materialplanVOList.add(materialplanVO);
        }

        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchasereceiptVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PurchasereceiptVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PurchasereceiptVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }



    /**
     * @Description delete 批量审核
     * @Param [ids]
     */
    @RequestMapping(value = "/audit", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<PurchasereceiptVO>>  audit(@RequestBody List<PurchasereceiptVO> vos) {
        service.audit(vos.stream().map(PurchasereceiptVO::getId).collect(Collectors.toList()));
        QueryParam param = new QueryParam();
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(   ",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        QueryWrapper<PurchasereceiptEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("audit",0);
     //   queryWrapper.eq("org_Id",param.getParams().get("org_Id").getValue());
        List<PurchasereceiptEntity> list = service.list(queryWrapper);
        List<PurchasereceiptVO> purchasereceiptList = BeanMapper.mapList(list,PurchasereceiptVO.class);

        return  CommonResponse.success("查询列表数据成功！",purchasereceiptList);

    }



    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PurchasereceiptVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<PurchasereceiptEntity> page = service.queryPage(param,false);
        IPage<PurchasereceiptVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchasereceiptVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PurchasereceiptEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Purchasereceipt-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refPurchasereceiptData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PurchasereceiptVO>> refPurchasereceiptData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PurchasereceiptEntity> page = service.queryPage(param,false);
        IPage<PurchasereceiptVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchasereceiptVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     *
     */
    @RequestMapping(value = "/purchasereceiptList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<PurchasereceiptVO>> purchasereceiptList(@RequestBody QueryParam param) {
        QueryWrapper<PurchasereceiptEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("audit",0);
        if(param.getParams().get("org_Id").getValue() != null){
            //param.getParams().remove("customer_name");
            queryWrapper.eq("org_Id",param.getParams().get("org_Id").getValue());
        }
        List<PurchasereceiptEntity> list = service.list(queryWrapper);
        List<PurchasereceiptVO> purchasereceiptList =  new ArrayList<>();
        for ( PurchasereceiptEntity temp : list ) {
            PurchasereceiptVO vo = BeanMapper.map(temp, PurchasereceiptVO.class);
            purchasereceiptList.add(vo);
        }
        return CommonResponse.success("查询列表数据成功！",purchasereceiptList);
    }






}
