package com.ejianc.business.purchasingmanagement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.purchasingmanagement.bean.PurchasetransportationEntity;
import com.ejianc.business.purchasingmanagement.service.IPurchasetransportationService;
import com.ejianc.business.purchasingmanagement.vo.PurchasedetilVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.purchasingmanagement.mapper.PurchasedetilMapper;
import com.ejianc.business.purchasingmanagement.bean.PurchasedetilEntity;
import com.ejianc.business.purchasingmanagement.service.IPurchasedetilService;

import java.math.BigDecimal;
import java.util.List;

/**
 * 采购运输信息明细
 * 
 * @author generator
 * 
 */
@Service("purchasedetilService")
public class PurchasedetilServiceImpl extends BaseServiceImpl<PurchasedetilMapper, PurchasedetilEntity> implements IPurchasedetilService{
    @Autowired
    private IPurchasedetilService service;
    @Autowired
    private IPurchasetransportationService purchasetransportationService;
    @Override
    public boolean saveOrChange(PurchasedetilVO PurchasedetilVO) {
        PurchasedetilEntity entity = BeanMapper.map(PurchasedetilVO, PurchasedetilEntity.class);
        service.saveOrUpdate(entity, false);
        QueryWrapper<PurchasedetilEntity> queryWrapper=new QueryWrapper();
        queryWrapper.eq("purchasetransportation_id",entity.getPurchasetransportationId());
        queryWrapper.eq("dr",0);

       List<PurchasedetilEntity> purchasedetilEntities  = service.list();
        BigDecimal sum = new BigDecimal(0.00);
        for (PurchasedetilEntity temp : purchasedetilEntities) {
            sum = sum.add(temp.getDeliveryQuantity());

        }
        PurchasetransportationEntity purchasetransportationEntity  =  purchasetransportationService.selectById(entity.getPurchasetransportationId());
        purchasetransportationEntity.setDeliveryQuantity(sum);
        purchasetransportationService.updateById(purchasetransportationEntity);
        return true;
    }
}
