package com.ejianc.business.purchasingmanagement.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.purchasingmanagement.bean.MaterialacceptancedetailEntity;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 采购材料验收
 * 
 * @author generator
 * 
 */
public class MaterialacceptanceVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long materialplanId; // 定料计划主键
    private String materialplanName; // 定料计划名称
    private Long supplierinfoId; // 供应商基本档案主键
    private String supplierinfoName; // 供应商基本档案名称
    private BigDecimal acceptanceQuantity; // 验收数量
    private BigDecimal price; // 单价
    private BigDecimal amount; // 金额
    private BigDecimal taxrate; // 税率
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private String billCode; // 单据编号
    private  Date acceptanceDate;  //验收时间
    private BigDecimal issuedQuantity; // 已发数量
    private BigDecimal quantityReceived; // 已收数量
    private Long materialId; // 原材类主键
    private String materialName; // 原材类名称
    private BigDecimal freightRate; // 运费税率
    private BigDecimal freightTax; // 运费税额
    private BigDecimal totalAmount; // 合计金额
    private BigDecimal totalCargo; // 货物合计金额
    private BigDecimal totalFreight; // 运费合计金额
    private Integer confirmStatus; //是否确认 1，确认  0，未确认
    private BigDecimal tax;//税额
    private BigDecimal amountPaid; // 已支付金额
    private BigDecimal amountNotPaid; // 未支付金额
    private BigDecimal invoiceReceived; // 已收发票金额
    private BigDecimal invoiceNotReceived; // 未收发票金额
        private String materialacceptanceBillCode; //采购材料验收单据编号


    private List<MaterialacceptancedetailVO> materialacceptancedetailList = new ArrayList<>(); // 采购材料验收明细表

    public String getMaterialacceptanceBillCode() {
        return materialacceptanceBillCode;
    }

    public void setMaterialacceptanceBillCode(String materialacceptanceBillCode) {
        this.materialacceptanceBillCode = materialacceptanceBillCode;
    }

    public BigDecimal getAmountPaid() {
        return amountPaid;
    }

    public void setAmountPaid(BigDecimal amountPaid) {
        this.amountPaid = amountPaid;
    }

    public BigDecimal getAmountNotPaid() {
        return amountNotPaid;
    }

    public void setAmountNotPaid(BigDecimal amountNotPaid) {
        this.amountNotPaid = amountNotPaid;
    }

    public BigDecimal getInvoiceReceived() {
        return invoiceReceived;
    }

    public void setInvoiceReceived(BigDecimal invoiceReceived) {
        this.invoiceReceived = invoiceReceived;
    }

    public BigDecimal getInvoiceNotReceived() {
        return invoiceNotReceived;
    }

    public void setInvoiceNotReceived(BigDecimal invoiceNotReceived) {
        this.invoiceNotReceived = invoiceNotReceived;
    }

    public Long getMaterialplanId() {
        return materialplanId;
    }

    public void setMaterialplanId(Long materialplanId) {
        this.materialplanId = materialplanId;
    }

    public String getMaterialplanName() {
        return materialplanName;
    }

    public void setMaterialplanName(String materialplanName) {
        this.materialplanName = materialplanName;
    }
     @ReferSerialTransfer(referCode="SupplierinfoRef")
    public Long getSupplierinfoId() {
        return supplierinfoId;
    }
    @ReferDeserialTransfer
    public void setSupplierinfoId(Long supplierinfoId) {
        this.supplierinfoId = supplierinfoId;
    }

    public String getSupplierinfoName() {
        return supplierinfoName;
    }

    public void setSupplierinfoName(String supplierinfoName) {
        this.supplierinfoName = supplierinfoName;
    }

    public BigDecimal getAcceptanceQuantity() {
        return acceptanceQuantity;
    }

    public void setAcceptanceQuantity(BigDecimal acceptanceQuantity) {
        this.acceptanceQuantity = acceptanceQuantity;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public BigDecimal getTaxrate() {
        return taxrate;
    }

    public void setTaxrate(BigDecimal taxrate) {
        this.taxrate = taxrate;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Date getAcceptanceDate() {
        return acceptanceDate;
    }

    public void setAcceptanceDate(Date acceptanceDate) {
        this.acceptanceDate = acceptanceDate;
    }

    public BigDecimal getIssuedQuantity() {
        return issuedQuantity;
    }

    public void setIssuedQuantity(BigDecimal issuedQuantity) {
        this.issuedQuantity = issuedQuantity;
    }

    public BigDecimal getQuantityReceived() {
        return quantityReceived;
    }

    public void setQuantityReceived(BigDecimal quantityReceived) {
        this.quantityReceived = quantityReceived;
    }
    @ReferSerialTransfer(referCode="MaterialRef")
    public Long getMaterialId() {
        return materialId;
    }
    @ReferDeserialTransfer
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public BigDecimal getFreightRate() {
        return freightRate;
    }

    public void setFreightRate(BigDecimal freightRate) {
        this.freightRate = freightRate;
    }

    public BigDecimal getFreightTax() {
        return freightTax;
    }

    public void setFreightTax(BigDecimal freightTax) {
        this.freightTax = freightTax;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BigDecimal getTotalCargo() {
        return totalCargo;
    }

    public void setTotalCargo(BigDecimal totalCargo) {
        this.totalCargo = totalCargo;
    }

    public BigDecimal getTotalFreight() {
        return totalFreight;
    }

    public void setTotalFreight(BigDecimal totalFreight) {
        this.totalFreight = totalFreight;
    }

    public Integer getConfirmStatus() {
        return confirmStatus;
    }

    public void setConfirmStatus(Integer confirmStatus) {
        this.confirmStatus = confirmStatus;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public List<MaterialacceptancedetailVO> getMaterialacceptancedetailList() {
        return materialacceptancedetailList;
    }

    public void setMaterialacceptancedetailList(List<MaterialacceptancedetailVO> materialacceptancedetailList) {
        this.materialacceptancedetailList = materialacceptancedetailList;
    }
}
