package com.ejianc.business.purchasingmanagement.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 供应商付款单
 * 
 * @author generator
 * 
 */
public class MaterialpaymentVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long supplierinfoId; // 供应商基本档案主键
    private String supplierinfoName; // 供应商基本档案名称
    private Integer refund; // 是否退款
    private Long supplierinfoBankId; // 供应商银行账户ID
    private String supplierinfoBankName; // 供应商银行账户
    private String bankCode;//银行账号
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date paymentDate; // 日期
    private Long paymentType; // 付款类型
    private String paymentTypeName; // 付款类型
    private BigDecimal paymentAmount; // 付款额
    private String summary; // 摘要
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private String billCode; // 单据编号
    private  String receiptNumber;//收据号
    private  BigDecimal notDistributionMoney ;//未分配金额


    private List<MaterialpaymentdetailVO> materialpaymentdetailList = new ArrayList<>(); // 供应商验收明细

    public BigDecimal getNotDistributionMoney() {
        return notDistributionMoney;
    }

    public void setNotDistributionMoney(BigDecimal notDistributionMoney) {
        this.notDistributionMoney = notDistributionMoney;
    }

    public String getBankCode() {
        return bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public String getReceiptNumber() {
        return receiptNumber;
    }

    public void setReceiptNumber(String receiptNumber) {
        this.receiptNumber = receiptNumber;
    }

    public List<MaterialpaymentdetailVO> getMaterialpaymentdetailList() {
        return materialpaymentdetailList;
    }

    public void setMaterialpaymentdetailList(List<MaterialpaymentdetailVO> materialpaymentdetailList) {
        this.materialpaymentdetailList = materialpaymentdetailList;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getPaymentType() {
        return paymentType;
    }
    @ReferDeserialTransfer
    public void setPaymentType(Long paymentType) {
        this.paymentType = paymentType;
    }

    public String getPaymentTypeName() {
        return paymentTypeName;
    }

    public void setPaymentTypeName(String paymentTypeName) {
        this.paymentTypeName = paymentTypeName;
    }

    @ReferSerialTransfer(referCode="SupplierinfoRef")
    public Long getSupplierinfoId() {
        return supplierinfoId;
    }

    @ReferDeserialTransfer
    public void setSupplierinfoId(Long supplierinfoId) {
        this.supplierinfoId = supplierinfoId;
    }
    public String getSupplierinfoName() {
        return supplierinfoName;
    }

    public void setSupplierinfoName(String supplierinfoName) {
        this.supplierinfoName = supplierinfoName;
    }
    public Integer getRefund() {
        return refund;
    }

    public void setRefund(Integer refund) {
        this.refund = refund;
    }
    @ReferSerialTransfer(referCode="SupplierbankRef")
    public Long getSupplierinfoBankId() {
        return supplierinfoBankId;
    }
    @ReferDeserialTransfer
    public void setSupplierinfoBankId(Long supplierinfoBankId) {
        this.supplierinfoBankId = supplierinfoBankId;
    }
    public String getSupplierinfoBankName() {
        return supplierinfoBankName;
    }

    public void setSupplierinfoBankName(String supplierinfoBankName) {
        this.supplierinfoBankName = supplierinfoBankName;
    }
    public Date getPaymentDate() {
        return paymentDate;
    }

    public void setPaymentDate(Date paymentDate) {
        this.paymentDate = paymentDate;
    }
    public BigDecimal getPaymentAmount() {
        return paymentAmount;
    }

    public void setPaymentAmount(BigDecimal paymentAmount) {
        this.paymentAmount = paymentAmount;
    }
    public String getSummary() {
        return summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    
}
