package com.ejianc.business.purchasingmanagement.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 定料计划
 * 
 * @author generator
 * 
 */
public class MaterialplanVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long orgId; // id主键
    private String orgName; // 组织名称
    private Long taskId; // 生产任务单主键
    private String taskName; // 生产任务单名称
    private Long supplierinfoId; // 供应商基本档案主键
    private String supplierinfoName; // 供应商基本档案名称
    private Long materialId; // 原材类主键
    private String materialName; // 原材类名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date starDate; // 开始日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 结束日期
    private BigDecimal quantity; // 数量
    private Long mddId; // 目的地主键(收货地址)
    private String mddName; // 目的地
    private BigDecimal issuedQuantity; // 已发数量
    private BigDecimal quantityReceived; // 已收数量
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private String billCode; // 单据编号
    private Long purchasecontractId; // 采购合同主键
    private Long purchasecontractdetailId; // 采购合同明细主键
    private BigDecimal price; // 单价
    private BigDecimal materialTax; // 材料税率
    private BigDecimal freightRate; // 运费税率

    private String materialplanBillCode;// 定料计划单据编号


    private List<PurchasereceiptVO>   purchasereceiptVOList = new ArrayList<>();  //收货记录列表
    private List<PurchasetransportationVO>   purchasetransportationVOList = new ArrayList<>();  //运输单列表

    private List<MaterialacceptanceVO>  materialacceptanceVOList = new ArrayList<>();//采购材料验收单

    public String getMaterialplanBillCode() {
        return materialplanBillCode;
    }

    public void setMaterialplanBillCode(String materialplanBillCode) {
        this.materialplanBillCode = materialplanBillCode;
    }

    public List<MaterialacceptanceVO> getMaterialacceptanceVOList() {
        return materialacceptanceVOList;
    }

    public void setMaterialacceptanceVOList(List<MaterialacceptanceVO> materialacceptanceVOList) {
        this.materialacceptanceVOList = materialacceptanceVOList;
    }

    public List<PurchasereceiptVO> getPurchasereceiptVOList() {
        return purchasereceiptVOList;
    }

    public void setPurchasereceiptVOList(List<PurchasereceiptVO> purchasereceiptVOList) {
        this.purchasereceiptVOList = purchasereceiptVOList;
    }

    public List<PurchasetransportationVO> getPurchasetransportationVOList() {
        return purchasetransportationVOList;
    }

    public void setPurchasetransportationVOList(List<PurchasetransportationVO> purchasetransportationVOList) {
        this.purchasetransportationVOList = purchasetransportationVOList;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getIssuedQuantity() {
        return issuedQuantity;
    }

    public void setIssuedQuantity(BigDecimal issuedQuantity) {
        this.issuedQuantity = issuedQuantity;
    }

    public BigDecimal getQuantityReceived() {
        return quantityReceived;
    }

    public void setQuantityReceived(BigDecimal quantityReceived) {
        this.quantityReceived = quantityReceived;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getMaterialTax() {
        return materialTax;
    }

    public void setMaterialTax(BigDecimal materialTax) {
        this.materialTax = materialTax;
    }

    public BigDecimal getFreightRate() {
        return freightRate;
    }

    public void setFreightRate(BigDecimal freightRate) {
        this.freightRate = freightRate;
    }

    @ReferSerialTransfer(referCode="PurchaseContractRef")
    public Long getPurchasecontractId() {
        return purchasecontractId;
    }
    @ReferDeserialTransfer
    public void setPurchasecontractId(Long purchasecontractId) {
        this.purchasecontractId = purchasecontractId;
    }
    @ReferSerialTransfer(referCode="PurchasecontractdetailRef")
    public Long getPurchasecontractdetailId() {
        return purchasecontractdetailId;
    }
    @ReferDeserialTransfer
    public void setPurchasecontractdetailId(Long purchasecontractdetailId) {
        this.purchasecontractdetailId = purchasecontractdetailId;
    }

    @ReferSerialTransfer(referCode="MaterialRef")
    public Long getMaterialId() {
        return materialId;
    }
    @ReferDeserialTransfer
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMddName() {
        return mddName;
    }

    public void setMddName(String mddName) {
        this.mddName = mddName;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getTaskId() {
        return taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public String getTaskName() {
        return taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public Long getSupplierinfoId() {
        return supplierinfoId;
    }

    public void setSupplierinfoId(Long supplierinfoId) {
        this.supplierinfoId = supplierinfoId;
    }
    public String getSupplierinfoName() {
        return supplierinfoName;
    }

    public void setSupplierinfoName(String supplierinfoName) {
        this.supplierinfoName = supplierinfoName;
    }
    public Date getStarDate() {
        return starDate;
    }

    public void setStarDate(Date starDate) {
        this.starDate = starDate;
    }
    public Date getEndDate() {
        return endDate;
    }


    @ReferSerialTransfer(referCode="ReceivingaddressRef")
    public Long getMddId() {
        return mddId;
    }
    @ReferDeserialTransfer
    public void setMddId(Long mddId) {
        this.mddId = mddId;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    
}
