package com.ejianc.business.purchasingmanagement.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.purchasingmanagement.vo.PurchasecontractdetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 采购合同
 * 
 * @author generator
 * 
 */
public class PurchaseContractVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String name ;  // 合同名称
    private Long supplierinfoId; // 供应商基本档案主键
    private String supplierinfoName; // 供应商基本档案名称

    private Long orgId; // 组织主键
    private String orgName; // 组织名称
    private Long contactId; // 联系人主键
    private String contactName; //联系人姓名
    private String contactPhone; // 联系人电话
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 开始日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 结束日期
    private Integer countingMethod; // 计数方式：1:收货数计 0:发货数计
    private Integer contract; // 合同方式：1:采购合同 0:销售合同
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private String remark; // 备注
    private String billCode; // 单据编号
    private Integer contractTypes; // 合同类型：0,沥青 1,砂石 2,外加剂

    private List<PurchasecontractdetailVO> purchasecontractdetailList = new ArrayList<>(); // 采购合同明细
    private List<MaterialplanVO> materialplanList = new ArrayList<>(); // 定料计划列表

    public Integer getContractTypes() {
        return contractTypes;
    }

    public void setContractTypes(Integer contractTypes) {
        this.contractTypes = contractTypes;
    }

    public List<MaterialplanVO> getMaterialplanList() {
        return materialplanList;
    }

    public void setMaterialplanList(List<MaterialplanVO> materialplanList) {
        this.materialplanList = materialplanList;
    }

    public String getContactName() {
        return contactName;
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ReferSerialTransfer(referCode="SupplierinfoRef")
    public Long getSupplierinfoId() {
        return supplierinfoId;
    }
    @ReferDeserialTransfer
    public void setSupplierinfoId(Long supplierinfoId) {
        this.supplierinfoId = supplierinfoId;
    }
    public String getSupplierinfoName() {
        return supplierinfoName;
    }

    public void setSupplierinfoName(String supplierinfoName) {
        this.supplierinfoName = supplierinfoName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="SupplierlinkerRef")
    public Long getContactId() {
        return contactId;
    }
    @ReferDeserialTransfer
    public void setContactId(Long contactId) {
        this.contactId = contactId;
    }
    public String getContactPhone() {
        return contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public Integer getCountingMethod() {
        return countingMethod;
    }

    public void setCountingMethod(Integer countingMethod) {
        this.countingMethod = countingMethod;
    }
    public Integer getContract() {
        return contract;
    }

    public void setContract(Integer contract) {
        this.contract = contract;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    
     public List<PurchasecontractdetailVO> getPurchasecontractdetailList() {
        return purchasecontractdetailList;
     }

     public void setPurchasecontractdetailList(List<PurchasecontractdetailVO> purchasecontractdetailList) {
        this.purchasecontractdetailList = purchasecontractdetailList;
     }
}
