package com.ejianc.business.purchasingmanagement.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 采购收货信息
 * 
 * @author generator
 * 
 */
public class PurchasereceiptVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long cgysId; // 采购运输明细主键

    private Long supplierinfoId; // 供应商基本档案主键
    private String supplierinfoName; // 供应商基本档案名称
    private Long shippersVehicleId; // 运输车辆主键
    private String shippersVehicleName; // 运输车辆名称
    private String numberPlate; // 车号
    private BigDecimal tare; // 皮重
    private BigDecimal grossWeight; // 毛重
    private BigDecimal netWeight;  // 净重
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date receiptTime; // 收货时间
    private Long materialId; // 原材类主键
    private String materialName; // 原材类名称
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private String billCode; // 单据编号
    private Long materialplanId; // 定料计划主键
    private Integer audit; //验收审核状态  0未审核  1已审核
    private Integer receipt; //收货状态  0未收货完成  1已收货完成
    private String purchasereceiptBillCode; //采购收货信息单据编号

    private MaterialacceptanceVO  materialacceptanceVO;    //材料验收单
    private TransportationacceptanceVO  transportationacceptanceVO;    //运费验收单

    public MaterialacceptanceVO getMaterialacceptanceVO() {
        return materialacceptanceVO;
    }

    public String getPurchasereceiptBillCode() {
        return purchasereceiptBillCode;
    }

    public void setPurchasereceiptBillCode(String purchasereceiptBillCode) {
        this.purchasereceiptBillCode = purchasereceiptBillCode;
    }

    public void setMaterialacceptanceVO(MaterialacceptanceVO materialacceptanceVO) {
        this.materialacceptanceVO = materialacceptanceVO;
    }

    public TransportationacceptanceVO getTransportationacceptanceVO() {
        return transportationacceptanceVO;
    }

    public void setTransportationacceptanceVO(TransportationacceptanceVO transportationacceptanceVO) {
        this.transportationacceptanceVO = transportationacceptanceVO;
    }

    public Integer getAudit() {
        return audit;
    }

    public void setAudit(Integer audit) {
        this.audit = audit;
    }

    public Integer getReceipt() {
        return receipt;
    }

    public void setReceipt(Integer receipt) {
        this.receipt = receipt;
    }

    public Long getMaterialplanId() {
        return materialplanId;
    }

    public void setMaterialplanId(Long materialplanId) {
        this.materialplanId = materialplanId;
    }

    @ReferSerialTransfer(referCode="PurchasedetilRef")
    public Long getCgysId() {
        return cgysId;
    }
    @ReferDeserialTransfer
    public void setCgysId(Long cgysId) {
        this.cgysId = cgysId;
    }
    @ReferSerialTransfer(referCode="SupplierinfoRef")
    public Long getSupplierinfoId() {
        return supplierinfoId;
    }
    @ReferDeserialTransfer
    public void setSupplierinfoId(Long supplierinfoId) {
        this.supplierinfoId = supplierinfoId;
    }
    public String getSupplierinfoName() {
        return supplierinfoName;
    }

    public void setSupplierinfoName(String supplierinfoName) {
        this.supplierinfoName = supplierinfoName;
    }
    public Long getShippersVehicleId() {
        return shippersVehicleId;
    }

    public void setShippersVehicleId(Long shippersVehicleId) {
        this.shippersVehicleId = shippersVehicleId;
    }
    public String getShippersVehicleName() {
        return shippersVehicleName;
    }

    public void setShippersVehicleName(String shippersVehicleName) {
        this.shippersVehicleName = shippersVehicleName;
    }
    public String getNumberPlate() {
        return numberPlate;
    }

    public void setNumberPlate(String numberPlate) {
        this.numberPlate = numberPlate;
    }

    public BigDecimal getTare() {
        return tare;
    }

    public void setTare(BigDecimal tare) {
        this.tare = tare;
    }

    public BigDecimal getGrossWeight() {
        return grossWeight;
    }

    public void setGrossWeight(BigDecimal grossWeight) {
        this.grossWeight = grossWeight;
    }

    public BigDecimal getNetWeight() {
        return netWeight;
    }

    public void setNetWeight(BigDecimal netWeight) {
        this.netWeight = netWeight;
    }

    public Date getReceiptTime() {
        return receiptTime;
    }

    public void setReceiptTime(Date receiptTime) {
        this.receiptTime = receiptTime;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    
}
