package com.ejianc.business.purchasingmanagement.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.purchasingmanagement.vo.SupplierinvoicedetialVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 供应商发票管理
 * 
 * @author generator
 * 
 */
public class SupplierinvoiceVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long supplierinfoId; // 供应商基本档案主键
    private String supplierinfoName; // 供应商基本档案名称
    private BigDecimal invoiceMoney; // 发票金额
    private BigDecimal balanceMoney; // 发票余额金额
    private Long receivablesType; // 收款类型id
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date checkoutTime; // 结账年月日
    private Integer invoicesStatus; // 发票状态
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private String abstracts; // 摘要
    
    private List<SupplierinvoicedetialVO> supplierinvoicedetialList = new ArrayList<>(); // 供应商发票管理明细

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="SupplierinfoRef")
    public Long getSupplierinfoId() {
        return supplierinfoId;
    }
    @ReferDeserialTransfer
    public void setSupplierinfoId(Long supplierinfoId) {
        this.supplierinfoId = supplierinfoId;
    }
    public String getSupplierinfoName() {
        return supplierinfoName;
    }

    public void setSupplierinfoName(String supplierinfoName) {
        this.supplierinfoName = supplierinfoName;
    }
    public BigDecimal getInvoiceMoney() {
        return invoiceMoney;
    }

    public void setInvoiceMoney(BigDecimal invoiceMoney) {
        this.invoiceMoney = invoiceMoney;
    }
    public BigDecimal getBalanceMoney() {
        return balanceMoney;
    }

    public void setBalanceMoney(BigDecimal balanceMoney) {
        this.balanceMoney = balanceMoney;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getReceivablesType() {
        return receivablesType;
    }
    @ReferDeserialTransfer
    public void setReceivablesType(Long receivablesType) {
        this.receivablesType = receivablesType;
    }
    public Date getCheckoutTime() {
        return checkoutTime;
    }

    public void setCheckoutTime(Date checkoutTime) {
        this.checkoutTime = checkoutTime;
    }
    public Integer getInvoicesStatus() {
        return invoicesStatus;
    }

    public void setInvoicesStatus(Integer invoicesStatus) {
        this.invoicesStatus = invoicesStatus;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getAbstracts() {
        return abstracts;
    }

    public void setAbstracts(String abstracts) {
        this.abstracts = abstracts;
    }
    
     public List<SupplierinvoicedetialVO> getSupplierinvoicedetialList() {
        return supplierinvoicedetialList;
     }

     public void setSupplierinvoicedetialList(List<SupplierinvoicedetialVO> supplierinvoicedetialList) {
        this.supplierinvoicedetialList = supplierinvoicedetialList;
     }
}
