/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.purchasingmanagement.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.purchasingmanagement.bean.MaterialplanEntity;
import com.ejianc.business.purchasingmanagement.service.IMaterialacceptanceService;
import com.ejianc.business.purchasingmanagement.service.IMaterialplanService;
import com.ejianc.business.purchasingmanagement.service.IPurchasereceiptService;
import com.ejianc.business.purchasingmanagement.service.IPurchasetransportationService;
import com.ejianc.business.purchasingmanagement.vo.MaterialacceptanceVO;
import com.ejianc.business.purchasingmanagement.vo.MaterialplanVO;
import com.ejianc.business.purchasingmanagement.vo.PurchasereceiptVO;
import com.ejianc.business.purchasingmanagement.vo.PurchasetransportationVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"materialplan"})
public class MaterialplanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IMaterialplanService service;
    @Autowired
    private IPurchasereceiptService purchasereceiptService;
    @Autowired
    private IPurchasetransportationService purchasetransportationService;
    @Autowired
    private IMaterialacceptanceService materialacceptanceService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MaterialplanVO> saveOrUpdate(@RequestBody MaterialplanVO saveOrUpdateVO) {
        return this.service.saveChange(saveOrUpdateVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialplanVO> queryDetail(Long id) {
        MaterialplanEntity entity = (MaterialplanEntity)((Object)this.service.selectById(id));
        MaterialplanVO vo = (MaterialplanVO)((Object)BeanMapper.map((Object)((Object)entity), MaterialplanVO.class));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"materialplan_id", (Object)id);
        queryWrapper.eq((Object)"dr", (Object)0);
        List purchasereceiptEntities = this.purchasereceiptService.list((Wrapper)queryWrapper);
        List purchasereceiptVOList = BeanMapper.mapList((Iterable)purchasereceiptEntities, PurchasereceiptVO.class);
        for (int i = 0; i < purchasereceiptVOList.size(); ++i) {
            ((PurchasereceiptVO)((Object)purchasereceiptVOList.get(i))).setPurchasereceiptBillCode(((PurchasereceiptVO)((Object)purchasereceiptVOList.get(i))).getBillCode());
        }
        QueryWrapper purchasereceiptEntityQueryWrapper = new QueryWrapper();
        purchasereceiptEntityQueryWrapper.eq((Object)"materialplan_id", (Object)id);
        purchasereceiptEntityQueryWrapper.eq((Object)"dr", (Object)0);
        List purchasetransportationEntities = this.purchasetransportationService.list((Wrapper)purchasereceiptEntityQueryWrapper);
        List purchasetransportationVOList = BeanMapper.mapList((Iterable)purchasetransportationEntities, PurchasetransportationVO.class);
        for (int i = 0; i < purchasetransportationVOList.size(); ++i) {
            ((PurchasetransportationVO)((Object)purchasetransportationVOList.get(i))).setPurchasetransportationBillCode(((PurchasetransportationVO)((Object)purchasetransportationVOList.get(i))).getBillCode());
        }
        QueryWrapper materialacceptanceEntityQueryWrapper = new QueryWrapper();
        materialacceptanceEntityQueryWrapper.eq((Object)"materialplan_id", (Object)id);
        materialacceptanceEntityQueryWrapper.eq((Object)"dr", (Object)0);
        List materialacceptanceEntities = this.materialacceptanceService.list((Wrapper)materialacceptanceEntityQueryWrapper);
        List materialacceptanceVOList = BeanMapper.mapList((Iterable)materialacceptanceEntities, MaterialacceptanceVO.class);
        for (int i = 0; i < materialacceptanceVOList.size(); ++i) {
            ((MaterialacceptanceVO)((Object)materialacceptanceVOList.get(i))).setMaterialacceptanceBillCode(((MaterialacceptanceVO)((Object)materialacceptanceVOList.get(i))).getBillCode());
        }
        vo.setPurchasereceiptVOList(purchasereceiptVOList);
        vo.setPurchasetransportationVOList(purchasetransportationVOList);
        vo.setMaterialacceptanceVOList(materialacceptanceVOList);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialplanVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MaterialplanVO materialplanVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaterialplanVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialplanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Materialplan-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMaterialplanData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialplanVO>> refMaterialplanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialplanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

