/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.purchasingmanagement.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.purchasingmanagement.bean.MaterialacceptanceEntity;
import com.ejianc.business.purchasingmanagement.service.IMaterialacceptanceService;
import com.ejianc.business.purchasingmanagement.vo.MaterialacceptanceVO;
import com.ejianc.business.purchasingmanagement.vo.MaterialpaymentdetailVO;
import com.ejianc.business.purchasingmanagement.vo.SupplierinvoicedetialVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"materialacceptance"})
public class MaterialacceptanceController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IMaterialacceptanceService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MaterialacceptanceVO> saveOrUpdate(@RequestBody MaterialacceptanceVO saveOrUpdateVO) {
        MaterialacceptanceEntity entity = (MaterialacceptanceEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), MaterialacceptanceEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        MaterialacceptanceVO vo = (MaterialacceptanceVO)((Object)BeanMapper.map((Object)((Object)entity), MaterialacceptanceVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialacceptanceVO> queryDetail(Long id) {
        MaterialacceptanceEntity entity = (MaterialacceptanceEntity)((Object)this.service.selectById(id));
        MaterialacceptanceVO vo = (MaterialacceptanceVO)((Object)BeanMapper.map((Object)((Object)entity), MaterialacceptanceVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialacceptanceVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MaterialacceptanceVO materialacceptanceVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaterialacceptanceVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("supplierinfoName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialacceptanceVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Materialacceptance-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMaterialacceptanceData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialacceptanceVO>> refMaterialacceptanceData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialacceptanceVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/materialacceptancelist"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<MaterialpaymentdetailVO>> receivableslist(@RequestBody QueryParam param) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (((Parameter)param.getParams().get("supplierinfo_id")).getValue() != null) {
            queryWrapper.eq((Object)"supplierinfo_id", ((Parameter)param.getParams().get("supplierinfo_id")).getValue());
        }
        if (((Parameter)param.getParams().get("org_Id")).getValue() != null) {
            queryWrapper.eq((Object)"org_Id", ((Parameter)param.getParams().get("org_Id")).getValue());
        }
        queryWrapper.eq((Object)"confirm_status", (Object)1);
        queryWrapper.ne((Object)"amount_not_paid", (Object)new BigDecimal(0.0));
        List list = this.service.list((Wrapper)queryWrapper);
        ArrayList<MaterialpaymentdetailVO> materialpaymentdetailList = new ArrayList<MaterialpaymentdetailVO>();
        for (MaterialacceptanceEntity temp : list) {
            MaterialpaymentdetailVO vo = new MaterialpaymentdetailVO();
            vo.setId(temp.getId());
            vo.setMaterialacceptanceId(temp.getId());
            vo.setMaterialId(temp.getMaterialId());
            vo.setMaterialName(temp.getMaterialName());
            vo.setAcceptanceDate(temp.getAcceptanceDate());
            vo.setQuantity(temp.getAcceptanceQuantity());
            vo.setAmount(temp.getTotalAmount());
            vo.setReceivableMoney(temp.getTotalAmount());
            if (temp.getAmountNotPaid() != null) {
                vo.setUncollectedMoney(temp.getAmountNotPaid());
            } else {
                vo.setUncollectedMoney(temp.getTotalAmount());
            }
            vo.setReceivedMoney(new BigDecimal(0.0));
            if (temp.getAmountPaid() != null) {
                vo.setOtherReceivedMoney(temp.getAmountPaid());
            } else {
                vo.setOtherReceivedMoney(new BigDecimal(0.0));
            }
            vo.setBillCode(temp.getBillCode());
            vo.setRowState("add");
            materialpaymentdetailList.add(vo);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", materialpaymentdetailList);
    }

    @RequestMapping(value={"/supplierinvoicedetialist"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<SupplierinvoicedetialVO>> supplierinvoicedetialist(@RequestBody QueryParam param) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (((Parameter)param.getParams().get("supplierinfo_id")).getValue() != null) {
            queryWrapper.eq((Object)"supplierinfo_id", ((Parameter)param.getParams().get("supplierinfo_id")).getValue());
        }
        if (((Parameter)param.getParams().get("org_Id")).getValue() != null) {
            queryWrapper.eq((Object)"org_Id", ((Parameter)param.getParams().get("org_Id")).getValue());
        }
        queryWrapper.eq((Object)"confirm_status", (Object)1);
        queryWrapper.ne((Object)"invoice_not_received", (Object)new BigDecimal(0.0));
        List list = this.service.list((Wrapper)queryWrapper);
        ArrayList<SupplierinvoicedetialVO> supplierinvoicedetialVOS = new ArrayList<SupplierinvoicedetialVO>();
        for (MaterialacceptanceEntity temp : list) {
            SupplierinvoicedetialVO vo = new SupplierinvoicedetialVO();
            vo.setId(temp.getId());
            vo.setMaterialacceptanceId(temp.getId());
            if (temp.getInvoiceNotReceived() != null) {
                vo.setUncollectedMoney(temp.getInvoiceNotReceived());
            } else {
                vo.setUncollectedMoney(temp.getTotalAmount());
            }
            vo.setReceivedMoney(new BigDecimal(0.0));
            if (temp.getInvoiceReceived() != null) {
                vo.setOtherReceivedMoney(temp.getInvoiceReceived());
            } else {
                vo.setOtherReceivedMoney(new BigDecimal(0.0));
            }
            vo.setBillCode(temp.getBillCode());
            vo.setReceivablesDate(temp.getAcceptanceDate());
            vo.setInvoiceMoney(temp.getTotalAmount());
            vo.setRowState("add");
            supplierinvoicedetialVOS.add(vo);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", supplierinvoicedetialVOS);
    }
}

