package com.ejianc.business.purchasingmanagement.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.purchasingmanagement.bean.TransporterpaymentdetailEntity;
/**
 * 运输商付款单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_purchasingmanagement_transporterpayment")
public class TransporterpaymentEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="shippers_id")
    private Long shippersId; // 运输商基本档案主键
    @TableField(value="shippers_name")
    private String shippersName; // 运输商基本档案名称
    @TableField(value="refund")
    private Integer refund; // 是否退款
    @TableField(value="shippers_bank_id")
    private Long shippersBankId; // 运输商银行账户ID
    @TableField(value="shippers_bank_name")
    private String shippersBankName; // 运输商银行账户
    @TableField(value="payment_date")
    private Date paymentDate; // 日期
    @TableField(value="payment_type")
    private Long paymentType; // 付款类型
    @TableField(value="payment_amount")
    private BigDecimal paymentAmount; // 付款额
    @TableField(value="summary")
    private String summary; // 摘要
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="receipt_number")
    private  String receiptNumber;//收据号
    @TableField(value="bank_code")
    private String bankCode;//银行账号
    @TableField(value="not_distribution_money")
    private  BigDecimal notDistributionMoney ;//未分配金额
    @TableField(value="payment_type_name")
    private String paymentTypeName; // 付款类型
    @TableField(value="prepayment_amount")
    private BigDecimal prepaymentAmount; // 预付款金额
    @TableField(value="distribution_money_sum")
    private BigDecimal distributionMoneySum; // 分配金额合计
    @TableField(value="prepayment")
    private Integer prepayment; // 0 正常付款 1预付款
    @TableField(value="money_capital")
    private String moneyCapital; //金额大写


    @TableField(exist=false)
    @SubEntity(serviceName="transporterpaymentdetailService",pidName = "transporterpaymentId")//此处有pid="xxx"，默认值pid="pid"
    private List<TransporterpaymentdetailEntity> transporterpaymentdetailList = new ArrayList<>(); // 运输商付款单明细表`

    public BigDecimal getPrepaymentAmount() {
        return prepaymentAmount;
    }

    public void setPrepaymentAmount(BigDecimal prepaymentAmount) {
        this.prepaymentAmount = prepaymentAmount;
    }

    public BigDecimal getDistributionMoneySum() {
        return distributionMoneySum;
    }

    public void setDistributionMoneySum(BigDecimal distributionMoneySum) {
        this.distributionMoneySum = distributionMoneySum;
    }

    public Integer getPrepayment() {
        return prepayment;
    }

    public void setPrepayment(Integer prepayment) {
        this.prepayment = prepayment;
    }

    public BigDecimal getNotDistributionMoney() {
        return notDistributionMoney;
    }

    public void setNotDistributionMoney(BigDecimal notDistributionMoney) {
        this.notDistributionMoney = notDistributionMoney;
    }

    public Long getPaymentType() {
        return paymentType;
    }

    public void setPaymentType(Long paymentType) {
        this.paymentType = paymentType;
    }

    public String getPaymentTypeName() {
        return paymentTypeName;
    }

    public void setPaymentTypeName(String paymentTypeName) {
        this.paymentTypeName = paymentTypeName;
    }

    public String getReceiptNumber() {
        return receiptNumber;
    }

    public void setReceiptNumber(String receiptNumber) {
        this.receiptNumber = receiptNumber;
    }

    public String getBankCode() {
        return bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public Long getShippersId() {
        return shippersId;
    }

    public void setShippersId(Long shippersId) {
        this.shippersId = shippersId;
    }
    public String getShippersName() {
        return shippersName;
    }

    public void setShippersName(String shippersName) {
        this.shippersName = shippersName;
    }
    public Integer getRefund() {
        return refund;
    }

    public void setRefund(Integer refund) {
        this.refund = refund;
    }

    public Long getShippersBankId() {
        return shippersBankId;
    }

    public void setShippersBankId(Long shippersBankId) {
        this.shippersBankId = shippersBankId;
    }
    public String getShippersBankName() {
        return shippersBankName;
    }

    public void setShippersBankName(String shippersBankName) {
        this.shippersBankName = shippersBankName;
    }
    public Date getPaymentDate() {
        return paymentDate;
    }

    public void setPaymentDate(Date paymentDate) {
        this.paymentDate = paymentDate;
    }

    public BigDecimal getPaymentAmount() {
        return paymentAmount;
    }

    public void setPaymentAmount(BigDecimal paymentAmount) {
        this.paymentAmount = paymentAmount;
    }
    public String getSummary() {
        return summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    
    public List<TransporterpaymentdetailEntity> getTransporterpaymentdetailList() {
        return transporterpaymentdetailList;
    }

    public void setTransporterpaymentdetailList(List<TransporterpaymentdetailEntity> transporterpaymentdetailList) {
        this.transporterpaymentdetailList = transporterpaymentdetailList;
    }

    public String getMoneyCapital() {
        return moneyCapital;
    }

    public void setMoneyCapital(String moneyCapital) {
        this.moneyCapital = moneyCapital;
    }
}
