package com.ejianc.business.purchasingmanagement.service.impl;

import com.ejianc.business.purchasingmanagement.bean.*;
import com.ejianc.business.purchasingmanagement.service.ITransportationacceptanceService;
import com.ejianc.business.purchasingmanagement.service.ITransporterpaymentService;
import com.ejianc.business.purchasingmanagement.service.ITransporterpaymentdetailService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

@Service("transporterpayment") 
public class TransporterpaymentBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private ITransporterpaymentService service;

	@Autowired
	private ITransporterpaymentdetailService transporterpaymentdetailService;
	@Autowired
	private ITransportationacceptanceService transportationacceptanceService;
	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("---------进来啦--------");
		TransporterpaymentEntity entity  =  service.selectById(billId);
		if(entity.getTransporterpaymentdetailList()!=null){
			logger.info("---------不为空--------");
			for(TransporterpaymentdetailEntity temp : entity.getTransporterpaymentdetailList()){
				TransportationacceptanceEntity transportationacceptanceEntity =transportationacceptanceService.selectById(temp.getTransportationacceptanceId());
				transportationacceptanceEntity.setAmountPaid(temp.getDistributionMoney().add(transportationacceptanceEntity.getAmountPaid()));//已付金额 = 已付金额 + 分配金额
				transportationacceptanceEntity.setAmountNotPaid(transportationacceptanceEntity.getTotalAmount().subtract(transportationacceptanceEntity.getAmountPaid()));//未收金额 = 应收-已付
				transportationacceptanceService.updateById(transportationacceptanceEntity);
				temp.setUncollectedMoney(transportationacceptanceEntity.getTotalAmount().subtract(transportationacceptanceEntity.getAmountPaid()));
				temp.setReceivedMoney(temp.getDistributionMoney());//本单已付金额
				logger.info("---------已修改--------");
				transporterpaymentdetailService.updateById(temp);
			}
		}
		entity.setBillState(state);
		service.updateById(entity);
		logger.info("---------结束--------");


		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
