package com.ejianc.business.purchasingmanagement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.purchasingmanagement.bean.*;
import com.ejianc.business.purchasingmanagement.service.*;
import com.ejianc.business.purchasingmanagement.vo.PurchasereceiptVO;
import com.ejianc.business.purchasingmanagement.vo.WeighingInfoVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.purchasingmanagement.mapper.WeighingInfoMapper;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 称重信息
 * 
 * @author generator
 * 
 */
@Service("weighingInfoService")
public class WeighingInfoServiceImpl extends BaseServiceImpl<WeighingInfoMapper, WeighingInfoEntity> implements IWeighingInfoService{
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IWeighingInfoService service;
    @Autowired
    private IPurchasedetilService purchasedetilService;
    @Autowired
    private IMaterialplanService materialplanService;
    @Autowired
    private IPurchasetransportationService purchasetransportationService;
    @Autowired
    private IPurchasereceiptService purchasereceiptService;

    @Autowired
    private SessionManager sessionManager;
    @Override
    public CommonResponse<WeighingInfoVO> saveChange(WeighingInfoVO saveOrUpdateVO) {
        Date date = new Date();
        WeighingInfoEntity entity = BeanMapper.map(saveOrUpdateVO, WeighingInfoEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                //   entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        WeighingInfoVO vo = BeanMapper.map(entity, WeighingInfoVO.class);

        if(0==vo.getWeighingMethod()){
            //一次称重
            QueryWrapper<PurchasedetilEntity> queryWrapper=new QueryWrapper();
            queryWrapper.eq("number_plate",vo.getNumberPlate());
            queryWrapper.eq("status",0);
            PurchasedetilEntity  purchasedetilEntity =    purchasedetilService.getOne(queryWrapper);
            PurchasereceiptEntity purchasereceiptEntity  = new PurchasereceiptEntity();
            purchasereceiptEntity.setOrgId(purchasedetilEntity.getOrgId());
            purchasereceiptEntity.setOrgName(purchasedetilEntity.getOrgName());
            purchasereceiptEntity.setMaterialplanId(purchasedetilEntity.getMaterialplanId());
            purchasereceiptEntity.setSupplierinfoId(purchasedetilEntity.getSupplierinfoId());
            purchasereceiptEntity.setSupplierinfoName(purchasedetilEntity.getSupplierinfoName());
            purchasereceiptEntity.setShippersVehicleId(purchasedetilEntity.getShippersVehicleId());
            purchasereceiptEntity.setShippersVehicleName(purchasedetilEntity.getShippersVehicleName());
            purchasereceiptEntity.setNumberPlate(saveOrUpdateVO.getNumberPlate());
            purchasereceiptEntity.setMaterialId(purchasedetilEntity.getMaterialId());
            purchasereceiptEntity.setMaterialName(purchasedetilEntity.getMaterialName());
            purchasereceiptEntity.setReceiptTime(date);
            purchasereceiptEntity.setCgysId(purchasedetilEntity.getId());
            purchasereceiptEntity.setTare(purchasedetilEntity.getTareWeight());
            purchasereceiptEntity.setGrossWeight(vo.getWeight());
            purchasereceiptEntity.setReceipt(1);
            purchasereceiptEntity.setAudit(0);
            if(purchasedetilEntity.getTareWeight()!=null){
                purchasereceiptEntity.setNetWeight(vo.getWeight().subtract(purchasedetilEntity.getTareWeight()));//
            }else{
                return CommonResponse.success("称重单据数据保存成功，未维护皮重重量无法一次性收货！",vo);
            }
            PurchasereceiptVO purchasereceiptVO  = new PurchasereceiptVO();
            if(purchasereceiptEntity.getId() == null || purchasereceiptEntity.getId() == 0){
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),purchasereceiptVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    purchasereceiptEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            purchasereceiptService.saveOrUpdate(purchasereceiptEntity, false);
            purchasereceiptVO = BeanMapper.map(purchasereceiptEntity, PurchasereceiptVO.class);
            //回填定料计划中的已收数量
            QueryWrapper<MaterialplanEntity> materialplanEntityQueryWrapper=new QueryWrapper();
            materialplanEntityQueryWrapper.eq("id",purchasereceiptVO.getMaterialplanId());
            materialplanEntityQueryWrapper.eq("dr",0);

            MaterialplanEntity materialplanEntity = materialplanService.getOne(materialplanEntityQueryWrapper);
            materialplanEntity.setQuantityReceived(purchasereceiptVO.getNetWeight());
            materialplanService.update(materialplanEntity,materialplanEntityQueryWrapper);
            //修改运输单子表的状态
            QueryWrapper<PurchasedetilEntity> queryWrapper1 =new QueryWrapper();
            queryWrapper1.eq("id",purchasereceiptVO.getCgysId());
            queryWrapper1.eq("dr",0);
            //purchasedetilEntity = purchasedetilService.getOne(queryWrapper1); //查询采购运输单主表
            purchasedetilEntity.setStatus(1);
            purchasedetilService.update(purchasedetilEntity,queryWrapper1);
            //回填采购运输单收货数量
            entity.setId(vo.getId());
            entity.setPurchasereceiptId(purchasereceiptEntity.getId());
            QueryWrapper<PurchasedetilEntity> queryWrapper3 =new QueryWrapper();
            PurchasetransportationEntity purchasetransportationEntity = purchasetransportationService.getById(purchasedetilEntity.getPurchasetransportationId());
            queryWrapper3.eq("purchasetransportation_id",purchasedetilEntity.getPurchasetransportationId());
            queryWrapper3.eq("dr",0);
            List<PurchasedetilEntity> purchasedetilEntities =  purchasedetilService.list(queryWrapper3);
            BigDecimal sum = new BigDecimal(0.00);
            for (PurchasedetilEntity temp :    purchasedetilEntities) {
                if(temp.getReceiptQuantity()!=null){
                    sum = sum.add(temp.getReceiptQuantity());
                }
            }
            purchasetransportationEntity.setReceiptQuantity(sum);
            purchasetransportationService.updateById(purchasetransportationEntity);
            materialplanEntity.setQuantityReceived(sum);
            materialplanService.updateById(materialplanEntity);
            service.updateById(entity);

        }else if(1==vo.getWeighingMethod()){
            //毛重
            QueryWrapper<PurchasedetilEntity> queryWrapper=new QueryWrapper();
            queryWrapper.eq("number_plate",vo.getNumberPlate());
            queryWrapper.eq("status",0);
            queryWrapper.eq("materialplan_id",vo.getMaterialplanId());
            PurchasedetilEntity  purchasedetilEntity =    purchasedetilService.getOne(queryWrapper);
            PurchasereceiptEntity purchasereceiptEntity  = new PurchasereceiptEntity();
            purchasereceiptEntity.setOrgId(purchasedetilEntity.getOrgId());
            purchasereceiptEntity.setOrgName(purchasedetilEntity.getOrgName());
            purchasereceiptEntity.setMaterialplanId(purchasedetilEntity.getMaterialplanId());
            purchasereceiptEntity.setSupplierinfoId(purchasedetilEntity.getSupplierinfoId());
            purchasereceiptEntity.setSupplierinfoName(purchasedetilEntity.getSupplierinfoName());
            purchasereceiptEntity.setShippersVehicleId(purchasedetilEntity.getShippersVehicleId());
            purchasereceiptEntity.setShippersVehicleName(purchasedetilEntity.getShippersVehicleName());
            purchasereceiptEntity.setNumberPlate(saveOrUpdateVO.getNumberPlate());
            purchasereceiptEntity.setMaterialId(purchasedetilEntity.getMaterialId());
            purchasereceiptEntity.setMaterialName(purchasedetilEntity.getMaterialName());
            purchasereceiptEntity.setReceiptTime(date);
            purchasereceiptEntity.setCgysId(purchasedetilEntity.getId());
            purchasereceiptEntity.setReceipt(0);
            purchasereceiptEntity.setAudit(0);
            purchasereceiptEntity.setReturnStatus(0);
            purchasereceiptEntity.setUnloadedStatus(0);
           // purchasereceiptEntity.setTare(purchasedetilEntity.getTareWeight());//皮重
            purchasereceiptEntity.setGrossWeight(vo.getWeight());//毛重
            PurchasereceiptVO purchasereceiptVO  = new PurchasereceiptVO();
            if(purchasereceiptEntity.getId() == null || purchasereceiptEntity.getId() == 0){
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),purchasereceiptVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    purchasereceiptEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            purchasereceiptService.saveOrUpdate(purchasereceiptEntity, false);
            purchasereceiptVO = BeanMapper.map(purchasereceiptEntity, PurchasereceiptVO.class);

            //回填定料计划中的已收数量
//            QueryWrapper<MaterialplanEntity> materialplanEntityQueryWrapper=new QueryWrapper();
//            materialplanEntityQueryWrapper.eq("id",purchasereceiptVO.getMaterialplanId());
//            materialplanEntityQueryWrapper.eq("dr",0);
//            MaterialplanEntity materialplanEntity = materialplanService.getOne(materialplanEntityQueryWrapper);
//            materialplanEntity.setQuantityReceived(purchasereceiptVO.getNetWeight());
//            materialplanService.update(materialplanEntity,materialplanEntityQueryWrapper);
//            //修改运输单子表的状态
//            QueryWrapper<PurchasedetilEntity> queryWrapper1 =new QueryWrapper();
//            queryWrapper1.eq("id",purchasereceiptVO.getCgysId());
//            queryWrapper1.eq("dr",0);
//            //purchasedetilEntity = purchasedetilService.getOne(queryWrapper1); //查询采购运输单主表
//            purchasedetilEntity.setStatus(1);
//            purchasedetilService.update(purchasedetilEntity,queryWrapper1);
//            //回填采购运输单收货数量
//            QueryWrapper<PurchasetransportationEntity> queryWrapper2 =new QueryWrapper();
//            queryWrapper2.eq("id",purchasedetilEntity.getPurchasetransportationId());
//            PurchasetransportationEntity purchasetransportationEntity = purchasetransportationService.getOne(queryWrapper2);
//            purchasetransportationEntity.setReceiptQuantity(purchasetransportationEntity.getRequiredQuantity().add(purchasereceiptVO.getNetWeight()));
//            purchasetransportationEntity.setReceiptTime(purchasereceiptVO.getReceiptTime());
//            purchasetransportationService.update(purchasetransportationEntity,queryWrapper2);

              entity.setId(vo.getId());
              entity.setPurchasereceiptId(purchasereceiptVO.getId());
              service.updateById(entity);

        }else if(2==vo.getWeighingMethod()){
            //皮重
            QueryWrapper<PurchasedetilEntity> queryWrapper=new QueryWrapper();
            queryWrapper.eq("number_plate",vo.getNumberPlate());
            queryWrapper.eq("status",0);
            queryWrapper.eq("materialplan_id",vo.getMaterialplanId());
            PurchasedetilEntity  purchasedetilEntity =    purchasedetilService.getOne(queryWrapper);
            PurchasereceiptEntity purchasereceiptEntity = new PurchasereceiptEntity();
            QueryWrapper<PurchasereceiptEntity> purchasereceiptEntityQueryWrapper  =new QueryWrapper();
            purchasereceiptEntityQueryWrapper.eq("number_plate",vo.getNumberPlate());
            purchasereceiptEntityQueryWrapper.eq("receipt",0);
            purchasereceiptEntityQueryWrapper.eq("materialplan_id",vo.getMaterialplanId());
            purchasereceiptEntity =   purchasereceiptService.getOne(purchasereceiptEntityQueryWrapper);
            purchasereceiptEntity.setNetWeight(vo.getNetWeight());//净重
            purchasereceiptEntity.setTare(vo.getWeight());//皮重
            purchasereceiptEntity.setReceipt(1);
            purchasereceiptEntity.setPrintGrossWeight(vo.getPrintGrossWeight());//打印毛重
            purchasereceiptService.updateById(purchasereceiptEntity);

            QueryWrapper<MaterialplanEntity> materialplanEntityQueryWrapper=new QueryWrapper();
            materialplanEntityQueryWrapper.eq("id",purchasereceiptEntity.getMaterialplanId());
            materialplanEntityQueryWrapper.eq("dr",0);
            MaterialplanEntity materialplanEntity = materialplanService.getOne(materialplanEntityQueryWrapper);
            materialplanEntity.setQuantityReceived(purchasereceiptEntity.getNetWeight());
            materialplanService.update(materialplanEntity,materialplanEntityQueryWrapper);
            //修改运输单子表的状态
            QueryWrapper<PurchasedetilEntity> queryWrapper1 =new QueryWrapper();
            queryWrapper1.eq("id",purchasereceiptEntity.getCgysId());
            queryWrapper1.eq("dr",0);
            //purchasedetilEntity = purchasedetilService.getOne(queryWrapper1); //查询采购运输单主表
            purchasedetilEntity.setStatus(1);
            purchasedetilEntity.setReceiptQuantity(purchasereceiptEntity.getNetWeight());//收货数量
            purchasedetilEntity.setReceiptTime(date);//收货时间
            purchasedetilService.update(purchasedetilEntity,queryWrapper1);
            //回填采购运输单收货数量

            entity.setId(vo.getId());
            entity.setPurchasereceiptId(purchasereceiptEntity.getId());
            QueryWrapper<PurchasedetilEntity> queryWrapper3 =new QueryWrapper();
            PurchasetransportationEntity purchasetransportationEntity = purchasetransportationService.getById(purchasedetilEntity.getPurchasetransportationId());
            queryWrapper3.eq("purchasetransportation_id",purchasedetilEntity.getPurchasetransportationId());
            queryWrapper3.eq("dr",0);
            List<PurchasedetilEntity> purchasedetilEntities =  purchasedetilService.list(queryWrapper3);
            BigDecimal sum = new BigDecimal(0.00);
            for (PurchasedetilEntity temp :    purchasedetilEntities) {
                if(temp.getReceiptQuantity()!=null){
                    sum = sum.add(temp.getReceiptQuantity());
                }
            }
            purchasetransportationEntity.setReceiptQuantity(sum);
            purchasetransportationService.updateById(purchasetransportationEntity);
            materialplanEntity.setQuantityReceived(sum);
            materialplanService.updateById(materialplanEntity);
            service.updateById(entity);
        }
        return CommonResponse.success("保存或修改单据成功！",vo);
    }
}
