package com.ejianc.business.purchasingmanagement.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 供应商账号信息
 * 
 * @author generator
 * 
 */
public class SupplierinformationVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long supplierinfoId; // 供应商基本档案主键
    private String supplierinfoName; // 供应商基本档案名称
    private Long orgId; // 可发货组织主键
    private String orgName; // 可发货组织名称
    private String username; // 用户名
    private String password; // 密码
    private String openid; // 微信ID
    private String contactName; // 联系人姓名
    private String contactPhone; // 联系人电各方面
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private String billCode; // 单据编号

    public String getContactName() {
        return contactName;
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }


    @ReferSerialTransfer(referCode="SupplierinfoRef")
    public Long getSupplierinfoId() {
        return supplierinfoId;
    }
    @ReferDeserialTransfer
    public void setSupplierinfoId(Long supplierinfoId) {
        this.supplierinfoId = supplierinfoId;
    }
    public String getSupplierinfoName() {
        return supplierinfoName;
    }
    public void setSupplierinfoName(String supplierinfoName) {
        this.supplierinfoName = supplierinfoName;
    }
    public Long getOrgId() {
        return orgId;
    }
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }
    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
    public String getOpenid() {
        return openid;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }

    public String getContactPhone() {
        return contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    
}
