package com.ejianc.business.purchasingmanagement.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.purchasingmanagement.bean.PurchasedetilEntity;
import com.ejianc.business.purchasingmanagement.bean.PurchasereceiptEntity;
import com.ejianc.business.purchasingmanagement.service.IPurchasedetilService;
import com.ejianc.business.purchasingmanagement.service.IWeighingInfoService;

import com.ejianc.business.purchasingmanagement.vo.PurchasedetilVO;
import com.ejianc.business.purchasingmanagement.vo.PurchasereceiptVO;
import com.ejianc.business.purchasingmanagement.vo.WeighingInfoVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


import com.ejianc.framework.core.response.CommonResponse;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/api/purchasingmanagement/receiptApi/")
public class WeighinginfoApi {
    @Autowired
    private IWeighingInfoService weighinginfoService;
    @Autowired
    private IPurchasedetilService purchasedetilService;
    /**
     * @Description  新增或者修改
     */
    @RequestMapping(value = "/saveWeighinginfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse saveWeighinginfo(@RequestBody WeighingInfoVO WeighinginfoApiVO) {
        weighinginfoService.saveChange(WeighinginfoApiVO);
    	return CommonResponse.success("修改项目成功！");
    }


    /**
     * @Description  新增或者修改
     */
    @RequestMapping(value = "/vehicleInformation", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<PurchasedetilVO>> vehicleInformation(@RequestParam String numberPlate ,String orgId ) {

        QueryWrapper<PurchasedetilEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("org_id",orgId);
        queryWrapper.eq("number_plate",numberPlate);
          //  queryWrapper.eq("delivery_time",purchasedetilVO.getDeliveryTime());

        queryWrapper.eq("status",0);
        List<PurchasedetilEntity>   purchasedetilEntities= purchasedetilService.list(queryWrapper);
        List<PurchasedetilVO> purchasedetilVOS= new ArrayList<>();

        for (PurchasedetilEntity temp :purchasedetilEntities) {

            PurchasedetilVO vo = BeanMapper.map(temp, PurchasedetilVO.class);
            purchasedetilVOS.add(vo);
        }

        return CommonResponse.success("查询成功！",purchasedetilVOS);
    }



}
