package com.ejianc.business.purchasingmanagement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.purchasingmanagement.bean.*;
import com.ejianc.business.purchasingmanagement.service.*;
import com.ejianc.business.purchasingmanagement.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.purchasingmanagement.mapper.PurchasereceiptMapper;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 采购收货信息
 * 
 * @author generator
 * 
 */
@Service("purchasereceiptService")
public class PurchasereceiptServiceImpl extends BaseServiceImpl<PurchasereceiptMapper, PurchasereceiptEntity> implements IPurchasereceiptService{
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改
    @Autowired
    private IMaterialplanService materialplanService;
    @Autowired
    private IPurchasereceiptService service;
    @Autowired
    private IPurchasedetilService purchasedetilService;
    @Autowired
    private IPurchasetransportationService purchasetransportationService;
    @Autowired
    private IMaterialacceptanceService materialacceptanceService;
    @Autowired
    private IMaterialacceptancedetailService materialacceptancedetailService;
    @Autowired
    private IPurchasecontractdetailService purchasecontractdetailService;
    @Autowired
    private ITransportationacceptanceService transportationacceptanceService;
    @Autowired
    private ITransportationdetailService transportationdetailService;
    @Autowired
    private IPurchaseContractService purchaseContractService;
    @Override
    public CommonResponse<PurchasereceiptVO> saveChange(PurchasereceiptVO saveChangeVO) {
        saveChangeVO.setReceipt(1);
        saveChangeVO.setAudit(0);
        saveChangeVO.setUnloadedStatus(1);
        Date date = new Date();
        PurchasereceiptEntity entity = BeanMapper.map(saveChangeVO, PurchasereceiptEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveChangeVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        PurchasereceiptVO vo = BeanMapper.map(entity, PurchasereceiptVO.class);
        QueryWrapper<PurchasedetilEntity> queryWrapper1 =new QueryWrapper();
        QueryWrapper<PurchasedetilEntity> queryWrapper3 =new QueryWrapper();
        queryWrapper1.eq("id",entity.getCgysId());
        queryWrapper1.eq("dr",0);
        //采购明细表更新数据
        PurchasedetilEntity purchasedetilEntity = purchasedetilService.getOne(queryWrapper1); //查询采购运输单主表
        purchasedetilEntity.setStatus(1);
        purchasedetilEntity.setReceiptQuantity(entity.getNetWeight());//收货数量
        purchasedetilEntity.setReceiptTime(date);//收货时间
        purchasedetilService.updateById(purchasedetilEntity);
        PurchasetransportationEntity purchasetransportationEntity = purchasetransportationService.getById(purchasedetilEntity.getPurchasetransportationId());
        queryWrapper3.eq("purchasetransportation_id",purchasedetilEntity.getPurchasetransportationId());
        List<PurchasedetilEntity> purchasedetilEntities =  purchasedetilService.list(queryWrapper3);
        BigDecimal sum = new BigDecimal(0.00);
        for (PurchasedetilEntity temp :    purchasedetilEntities) {
            if(temp.getReceiptQuantity()!=null){
                sum = sum.add(temp.getReceiptQuantity());
            }
        }
        purchasetransportationEntity.setReceiptQuantity(sum);
        purchasetransportationEntity.setReceiptTime(entity.getReceiptTime());
        purchasetransportationService.updateById(purchasetransportationEntity);
        QueryWrapper<MaterialplanEntity> materialplanEntityQueryWrapper=new QueryWrapper();
        materialplanEntityQueryWrapper.eq("id",entity.getMaterialplanId());
        materialplanEntityQueryWrapper.eq("dr",0);
        MaterialplanEntity  materialplanEntity = materialplanService.getOne(materialplanEntityQueryWrapper);
        materialplanEntity.setQuantityReceived(sum);
        materialplanService.updateById(materialplanEntity);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public CommonResponse<String>deleteByID(List<PurchasereceiptVO> vos) {

        for(int i =0 ; i<vos.size()  ;  i++ ){
            PurchasereceiptEntity purchasereceiptEntity =     service.getById(vos.get(i).getId());
            service.removeById(vos.get(i).getId(),true);
            PurchasedetilEntity entity =     purchasedetilService.getById(purchasereceiptEntity.getCgysId());
            entity.setStatus(0);
            purchasedetilService.updateById(entity);
        }


        return CommonResponse.success("删除成功！");
    }

    @Autowired
    private ITransportationSummaryService transportationSummaryService;

    @Autowired
    private IMaterialacceptanceSummaryService materialacceptanceSummaryService;

    @Override
    public CommonResponse<PurchasereceiptVO> audit(List<PurchasereceiptVO> vos) throws ParseException {
        Date date = new Date();

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
		String str =  sdf.format(cal.getTime());
        str = str +"-20";


        cal.add(cal.MONTH, 1);
        String  preMonth = sdf.format(cal.getTime());
        preMonth = preMonth +"-20";
        for (int i = 0; i<vos.size();i++){
            PurchasereceiptEntity  entity = service.selectById(vos.get(i).getId());
            entity.setAudit(1);
            entity.setNetWeight(vos.get(i).getNetWeight());
            QueryWrapper<MaterialplanEntity> queryWrapper=new QueryWrapper();
            queryWrapper.eq("id",entity.getMaterialplanId());
            queryWrapper.eq("dr",0);
            MaterialplanEntity materialplanEntity = materialplanService.getOne(queryWrapper);
            //是否有运费验证
            PurchasecontractdetailEntity purchasecontractdetailEntity = purchasecontractdetailService.selectById(materialplanEntity.getPurchasecontractdetailId());
            PurchaseContractEntity purchaseContractEntity =    purchaseContractService.selectById(purchasecontractdetailEntity.getPurchasecontractId());

        if(purchasecontractdetailEntity!=null  && purchasecontractdetailEntity.getFreight()==1){
            QueryWrapper<TransportationacceptanceEntity> transportationacceptanceQueryWrapper =new QueryWrapper();
            transportationacceptanceQueryWrapper.eq("shippers_id",purchasecontractdetailEntity.getShippersId());
            transportationacceptanceQueryWrapper.eq("dr",0);
            transportationacceptanceQueryWrapper.eq("status",0);
            transportationacceptanceQueryWrapper.eq("org_id",entity.getOrgId());
            transportationacceptanceQueryWrapper.eq("org_name",entity.getOrgName());
            transportationacceptanceQueryWrapper.eq("purchasecontract_id",purchasecontractdetailEntity.getPurchasecontractId());
            //需要修改
            if(this.afterDate(str)){
                transportationacceptanceQueryWrapper.eq("acceptance_date",preMonth);
            }else{
                transportationacceptanceQueryWrapper.eq("acceptance_date",str);
            }


            TransportationacceptanceEntity transportationacceptanceEntity = transportationacceptanceService.getOne(transportationacceptanceQueryWrapper);
            if(transportationacceptanceEntity!=null){
                TransportationdetailVO transportationdetailVO  = new TransportationdetailVO();
                transportationdetailVO.setMaterialId(entity.getMaterialId());
                transportationdetailVO.setMaterialName(entity.getMaterialName());
                transportationdetailVO.setTransportationacceptanceId(transportationacceptanceEntity.getId());
                transportationdetailVO.setPurchasereceiptId(vos.get(i).getId());
                transportationdetailVO.setPrice(purchasecontractdetailEntity.getSjyfPrice());//运费单价
                transportationdetailVO.setQuantity(entity.getNetWeight());//数量
                transportationdetailVO.setAmount(entity.getNetWeight().multiply(purchasecontractdetailEntity.getSjyfPrice()).subtract(purchasecontractdetailEntity.getFreightRate().multiply(entity.getNetWeight().multiply(purchasecontractdetailEntity.getSjyfPrice()))));//金额
                transportationdetailVO.setFreightRate(purchasecontractdetailEntity.getFreightRate());//运费税率
                transportationdetailVO.setNumberPlate(entity.getNumberPlate());//车牌号
                //transportationdetailVO.setReceivedDate(date);//收货日期
                transportationdetailVO.setTotal(entity.getNetWeight().multiply(purchasecontractdetailEntity.getSjyfPrice()));//总
                // 计算
                transportationdetailVO.setFreightTax(purchasecontractdetailEntity.getFreightRate().multiply(entity.getNetWeight().multiply(purchasecontractdetailEntity.getSjyfPrice())));//运费税额
                TransportationdetailEntity transportationdetailEntity = BeanMapper.map(transportationdetailVO, TransportationdetailEntity.class);
                transportationdetailService.saveOrUpdate(transportationdetailEntity, false);

                //验收汇总明细表 开始
                TransportationSummaryEntity transportationSummaryEntity = new TransportationSummaryEntity();
                QueryWrapper<TransportationSummaryEntity> transportationSummaryEntityQueryWrapper =new QueryWrapper();
                transportationSummaryEntityQueryWrapper.eq("material_id",entity.getMaterialId());//原材料
                transportationSummaryEntityQueryWrapper.eq("price",transportationdetailVO.getPrice());//运费单价
                transportationSummaryEntityQueryWrapper.eq("transportationacceptance_id",transportationacceptanceEntity.getId());//主表主键
                transportationSummaryEntity =   transportationSummaryService.getOne(transportationSummaryEntityQueryWrapper);
                TransportationSummaryEntity transportationSummaryEntity2 = new TransportationSummaryEntity();
                if(transportationSummaryEntity!=null){
                    transportationSummaryEntity.setAmount(transportationSummaryEntity.getAmount().add(transportationdetailVO.getAmount()));//不含税金额
                    transportationSummaryEntity.setQuantity(transportationSummaryEntity.getQuantity().add(entity.getNetWeight()));//数量
                    transportationSummaryEntity.setFreightTax(transportationSummaryEntity.getFreightTax().add(transportationdetailVO.getFreightTax()));//税额
                    transportationSummaryEntity.setTotal(transportationSummaryEntity.getTotal().add(transportationdetailVO.getTotal()));//总计
                    transportationSummaryService.updateById(transportationSummaryEntity);
                }else {

                    transportationSummaryEntity2.setTransportationacceptanceId(transportationacceptanceEntity.getId());
                    transportationSummaryEntity2.setMaterialId(entity.getMaterialId());//原材料ID
                    transportationSummaryEntity2.setMaterialName(entity.getMaterialName());//原材料名称
                    transportationSummaryEntity2.setPrice(transportationdetailVO.getPrice());//单价
                    transportationSummaryEntity2.setQuantity(transportationdetailVO.getQuantity());//数量
                    transportationSummaryEntity2.setAmount(transportationdetailVO.getAmount());//不含税金额
                    transportationSummaryEntity2.setFreightTax(transportationdetailVO.getFreightTax());//税额
                    transportationSummaryEntity2.setTotal(transportationdetailVO.getTotal());//总计
                    transportationSummaryEntity2.setFreightRate(purchasecontractdetailEntity.getFreightRate());//运费税率
                    transportationSummaryService.saveOrUpdate(transportationSummaryEntity2,false);
                }
                //验收汇总明细表 结束


                //重新计算主表数据 start
                transportationacceptanceEntity = transportationacceptanceService.selectById(transportationacceptanceEntity.getId());

                BigDecimal  quantity  = new BigDecimal(0);
                BigDecimal  freightTax  = new BigDecimal(0);
                BigDecimal  amount  = new BigDecimal(0);
                BigDecimal  total  = new BigDecimal(0);
                for (TransportationdetailEntity  temp  :  transportationacceptanceEntity.getTransportationdetailList()) {
                    quantity =  quantity.add(temp.getQuantity());
                    freightTax  =  freightTax.add(temp.getFreightTax());
                    amount  =   amount.add(temp.getAmount());
                    total  =  total.add(temp.getTotal());
                }
                transportationacceptanceEntity.setQuantity(quantity);
                transportationacceptanceEntity.setTax(freightTax);
                transportationacceptanceEntity.setMoney(amount);
                transportationacceptanceEntity.setTotalAmount(total);
                transportationacceptanceService.updateById(transportationacceptanceEntity);
                //重新计算主表数据 end
            }else{
                //新增采购运输验收主表  star
                TransportationacceptanceVO transportationacceptanceVO = new TransportationacceptanceVO();
                transportationacceptanceVO.setShippersId(purchasecontractdetailEntity.getShippersId());
                transportationacceptanceVO.setShippersName(purchasecontractdetailEntity.getShippersName());
                transportationacceptanceVO.setStatus(0);
                transportationacceptanceVO.setOrgId(entity.getOrgId());
                transportationacceptanceVO.setOrgName(entity.getOrgName());
                transportationacceptanceVO.setShippingType(0);
                //需要修改验收时间
                if(this.afterDate(str)){
                    // saveOrUpdateVO.setAcceptanceDate(date);
                    transportationacceptanceVO.setAcceptanceDate(sdf1.parse(preMonth));
                    // materialacceptanceEntityQueryWrapper.eq("acceptance_date",preMonth);
                }else{
                    transportationacceptanceVO.setAcceptanceDate(sdf1.parse(str));
                    // materialacceptanceEntityQueryWrapper.eq("acceptance_date",str);
                }
               // transportationacceptanceVO.setAcceptanceDate(date);
                transportationacceptanceVO.setPurchasecontractBillCode(purchaseContractEntity.getBillCode());
               // transportationacceptanceVO.setMaterialplanId(materialplanEntity.getId());
                transportationacceptanceVO.setPurchasecontractId(purchasecontractdetailEntity.getPurchasecontractId());
                transportationacceptanceEntity  = BeanMapper.map(transportationacceptanceVO, TransportationacceptanceEntity.class);
                if(transportationacceptanceEntity.getId() == null || transportationacceptanceEntity.getId() == 0){
                    BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),transportationacceptanceVO);
                    CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                    if(billCode.isSuccess()) {
                        // entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                        transportationacceptanceEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                    }else{
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                }
                transportationacceptanceService.saveOrUpdate(transportationacceptanceEntity, false);
                transportationacceptanceVO = BeanMapper.map(transportationacceptanceEntity, TransportationacceptanceVO.class);
                //新增采购运输验收主表  end

                //新增采购运输验收子表信息  start
                TransportationdetailVO transportationdetailVO  = new TransportationdetailVO();
                transportationdetailVO.setTransportationacceptanceId(transportationacceptanceVO.getId());
                transportationdetailVO.setPurchasereceiptId(vos.get(i).getId());
                transportationdetailVO.setPrice(purchasecontractdetailEntity.getSjyfPrice());//运费单价
                transportationdetailVO.setQuantity(entity.getNetWeight());//数量
                transportationdetailVO.setMaterialId(entity.getMaterialId());
                transportationdetailVO.setMaterialName(entity.getMaterialName());
                transportationdetailVO.setAmount(entity.getNetWeight().multiply(purchasecontractdetailEntity.getSjyfPrice()).subtract(purchasecontractdetailEntity.getFreightRate().multiply(entity.getNetWeight().multiply(purchasecontractdetailEntity.getSjyfPrice()))));//金额
                transportationdetailVO.setFreightRate(purchasecontractdetailEntity.getFreightRate());//运费税率
                transportationdetailVO.setFreightTax(purchasecontractdetailEntity.getFreightRate().multiply(entity.getNetWeight().multiply(purchasecontractdetailEntity.getSjyfPrice())));//运费税额
                transportationdetailVO.setNumberPlate(entity.getNumberPlate());//车牌号
                transportationdetailVO.setTotal(entity.getNetWeight().multiply(purchasecontractdetailEntity.getSjyfPrice()));//总计
                //transportationdetailVO.setReceivedDate(date);//收货日期
                TransportationdetailEntity transportationdetailEntity = BeanMapper.map(transportationdetailVO, TransportationdetailEntity.class);
                transportationdetailService.saveOrUpdate(transportationdetailEntity, false);
                //新增采购运输验收子表信息  end

                //验收汇总明细表 开始
                TransportationSummaryEntity transportationSummaryEntity = new TransportationSummaryEntity();
                transportationSummaryEntity.setTransportationacceptanceId(transportationacceptanceVO.getId());
                transportationSummaryEntity.setMaterialId(entity.getMaterialId());//原材料ID
                transportationSummaryEntity.setMaterialName(entity.getMaterialName());//原材料名称
                transportationSummaryEntity.setPrice(transportationdetailVO.getPrice());//单价
                transportationSummaryEntity.setQuantity(transportationdetailVO.getQuantity());//数量
                transportationSummaryEntity.setAmount(transportationdetailVO.getAmount());//不含税金额
                transportationSummaryEntity.setFreightTax(transportationdetailVO.getFreightTax());//税额
                transportationSummaryEntity.setTotal(transportationdetailVO.getTotal());//总计
                transportationSummaryEntity.setFreightRate(purchasecontractdetailEntity.getFreightRate());//运费税率
                transportationSummaryService.saveOrUpdate(transportationSummaryEntity,false);
                //验收汇总明细表 结束


                //更新采购运输验收主表信息  start
                transportationacceptanceEntity.setId(transportationacceptanceVO.getId());
                transportationacceptanceEntity.setQuantity(entity.getNetWeight());//数量
                transportationacceptanceEntity.setTax(purchasecontractdetailEntity.getFreightRate().multiply(entity.getNetWeight().multiply(purchasecontractdetailEntity.getSjyfPrice())));//税额
                transportationacceptanceEntity.setMoney(entity.getNetWeight().multiply(purchasecontractdetailEntity.getSjyfPrice()).subtract(purchasecontractdetailEntity.getFreightRate().multiply(entity.getNetWeight().multiply(purchasecontractdetailEntity.getSjyfPrice()))));//金额
                transportationacceptanceEntity.setTotalAmount(entity.getNetWeight().multiply(purchasecontractdetailEntity.getSjyfPrice()));//总金额
                transportationacceptanceEntity.setPrice(purchasecontractdetailEntity.getSjyfPrice());//单价
                transportationacceptanceEntity.setTaxRate(purchasecontractdetailEntity.getFreightRate());//税率
                //更新采购运输验收主表信息  start
                transportationacceptanceService.updateById(transportationacceptanceEntity);
            }


        }

        //开始测试
        QueryWrapper<MaterialacceptanceEntity> materialacceptanceEntityQueryWrapper=new QueryWrapper();
      //  materialacceptanceEntityQueryWrapper.eq("materialplan_id",entity.getMaterialplanId());//定料计划
        materialacceptanceEntityQueryWrapper.eq("supplierinfo_id",materialplanEntity.getSupplierinfoId());//供应商
//        materialacceptanceEntityQueryWrapper.eq("material_id",entity.getMaterialId());//原材料
        materialacceptanceEntityQueryWrapper.eq("confirm_status",0);
        materialacceptanceEntityQueryWrapper.eq("dr",0);
        materialacceptanceEntityQueryWrapper.eq("purchasecontract_id",purchasecontractdetailEntity.getPurchasecontractId());
        if(this.afterDate(str)){
            materialacceptanceEntityQueryWrapper.eq("acceptance_date",preMonth);
        }else{
            materialacceptanceEntityQueryWrapper.eq("acceptance_date",str);
        }

        MaterialacceptanceEntity  materialacceptanceEntity  = materialacceptanceService.getOne(materialacceptanceEntityQueryWrapper);

        if(materialacceptanceEntity!=null){
            //新增采购材料明细表  start
            MaterialacceptancedetailVO saveOrUpdateVO = new MaterialacceptancedetailVO();
            saveOrUpdateVO.setMaterialacceptanceId(materialacceptanceEntity.getId());//验收单主键
            saveOrUpdateVO.setMaterialId(entity.getMaterialId());//原材料主键
            saveOrUpdateVO.setMaterialName(entity.getMaterialName());//原材料名称
            saveOrUpdateVO.setMaterialplanId(entity.getMaterialplanId());//定料主键
            saveOrUpdateVO.setPrice(materialplanEntity.getPrice());//单价
            saveOrUpdateVO.setMaterialTaxRate(materialplanEntity.getMaterialTax());//材料税率
            saveOrUpdateVO.setQuantity(entity.getNetWeight());//数量
            saveOrUpdateVO.setNumberPlate(entity.getNumberPlate());//车牌号
            saveOrUpdateVO.setPurchasereceiptId(vos.get(i).getId());
            BigDecimal quantityReceived = entity.getNetWeight();
            BigDecimal  amount =quantityReceived.multiply(materialplanEntity.getPrice()) ;
            //saveOrUpdateVO.setReceiptDate(date);//日期
            saveOrUpdateVO.setMoney(amount.subtract(materialplanEntity.getMaterialTax().multiply(materialplanEntity.getPrice().multiply(entity.getNetWeight()))));//金额
            saveOrUpdateVO.setMaterialTax(materialplanEntity.getMaterialTax().multiply(materialplanEntity.getPrice().multiply(entity.getNetWeight())));//材料税额
            saveOrUpdateVO.setTotal(amount);//合计
            //采购收货单信息进入材料验收单
            MaterialacceptancedetailEntity materialacceptancedetailEntity = BeanMapper.map(saveOrUpdateVO, MaterialacceptancedetailEntity.class);
            materialacceptancedetailService.saveOrUpdate(materialacceptancedetailEntity, false);
            //新增采购材料明细表  end

            //验收汇总明细表 开始
            MaterialacceptanceSummaryEntity materialacceptanceSummaryEntity = new MaterialacceptanceSummaryEntity();
            QueryWrapper<MaterialacceptanceSummaryEntity> materialacceptanceSummaryEntityQueryWrapper =new QueryWrapper();
            materialacceptanceSummaryEntityQueryWrapper.eq("material_id",entity.getMaterialId());//原材料
            materialacceptanceSummaryEntityQueryWrapper.eq("price",saveOrUpdateVO.getPrice());//运费单价
            materialacceptanceSummaryEntityQueryWrapper.eq("materialacceptance_id",materialacceptanceEntity.getId());//主键
            materialacceptanceSummaryEntity =   materialacceptanceSummaryService.getOne(materialacceptanceSummaryEntityQueryWrapper);
            MaterialacceptanceSummaryEntity materialacceptanceSummaryEntity2 = new MaterialacceptanceSummaryEntity();
            if(materialacceptanceSummaryEntity!=null){
                materialacceptanceSummaryEntity.setMoney(materialacceptanceSummaryEntity.getMoney().add(saveOrUpdateVO.getMoney()));//不含税金额
                materialacceptanceSummaryEntity.setQuantity(materialacceptanceSummaryEntity.getQuantity().add(entity.getNetWeight()));//数量
                materialacceptanceSummaryEntity.setMaterialTax(materialacceptanceSummaryEntity.getMaterialTax().add(saveOrUpdateVO.getMaterialTax()));//税额
                materialacceptanceSummaryEntity.setTotal(materialacceptanceSummaryEntity.getTotal().add(saveOrUpdateVO.getTotal()));//总计
                materialacceptanceSummaryService.updateById(materialacceptanceSummaryEntity);
            }else {
                materialacceptanceSummaryEntity2.setMaterialacceptanceId(materialacceptanceEntity.getId());
                materialacceptanceSummaryEntity2.setMaterialId(entity.getMaterialId());//原材料ID
                materialacceptanceSummaryEntity2.setMaterialName(entity.getMaterialName());//原材料名称
                materialacceptanceSummaryEntity2.setPrice(saveOrUpdateVO.getPrice());//单价
                materialacceptanceSummaryEntity2.setQuantity(saveOrUpdateVO.getQuantity());//数量
                materialacceptanceSummaryEntity2.setMoney(saveOrUpdateVO.getMoney());//不含税金额
                materialacceptanceSummaryEntity2.setMaterialTax(saveOrUpdateVO.getMaterialTax());//税额
                materialacceptanceSummaryEntity2.setTotal(saveOrUpdateVO.getTotal());//总计
                materialacceptanceSummaryEntity2.setMaterialTaxRate(materialplanEntity.getMaterialTax());//材料税率
                materialacceptanceSummaryService.saveOrUpdate(materialacceptanceSummaryEntity2,false);
            }
            //验收汇总明细表 结束

            //进入表后重新计算主表的数据
            materialacceptanceEntity = materialacceptanceService.selectById(materialacceptanceEntity.getId());
            //采购材料验收主表回填数据 start
            BigDecimal  quantity = new BigDecimal(0);
            BigDecimal  amountAll = new BigDecimal(0);
            BigDecimal  materialTax = new BigDecimal(0);
            BigDecimal  total = new BigDecimal(0);
            for (MaterialacceptancedetailEntity temp  : materialacceptanceEntity.getMaterialacceptancedetailList() ) {
                quantity =  quantity.add(temp.getQuantity());
                amountAll =  amountAll.add(temp.getMoney());
                materialTax = materialTax.add(temp.getMaterialTax());
                total = total.add(temp.getTotal());
            }
            materialacceptanceEntity.setAcceptanceQuantity(quantity);
            materialacceptanceEntity.setAmount(amountAll);
            materialacceptanceEntity.setTotalAmount(total);
            materialacceptanceEntity.setTax(materialTax);
            materialacceptanceService.updateById(materialacceptanceEntity);
            //采购材料验收主表回填数据 end

        }else{

            //新增采购材料验收主表 start
            MaterialacceptanceVO saveOrUpdateVO = new MaterialacceptanceVO();
            saveOrUpdateVO.setMaterialplanId(materialplanEntity.getId());//定料计划
            saveOrUpdateVO.setSupplierinfoId(materialplanEntity.getSupplierinfoId());//供应商id
            saveOrUpdateVO.setSupplierinfoName(materialplanEntity.getSupplierinfoName());//供应商
            saveOrUpdateVO.setOrgId(materialplanEntity.getOrgId());//组织ID
            saveOrUpdateVO.setOrgName(materialplanEntity.getOrgName());//组织名称
            saveOrUpdateVO.setPurchasecontractBillCode(purchaseContractEntity.getBillCode());
            saveOrUpdateVO.setConfirmStatus(0);//是否确认
            saveOrUpdateVO.setPurchasecontractId(purchasecontractdetailEntity.getPurchasecontractId());

            //需要修改验收时间
            if(this.afterDate(str)){
               // saveOrUpdateVO.setAcceptanceDate(date);
                saveOrUpdateVO.setAcceptanceDate(sdf1.parse(preMonth));
               // materialacceptanceEntityQueryWrapper.eq("acceptance_date",preMonth);
            }else{
                saveOrUpdateVO.setAcceptanceDate(sdf1.parse(str));
               // materialacceptanceEntityQueryWrapper.eq("acceptance_date",str);
            }
            materialacceptanceEntity = BeanMapper.map(saveOrUpdateVO, MaterialacceptanceEntity.class);
            if(materialacceptanceEntity.getId() == null || materialacceptanceEntity.getId() == 0){
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                    materialacceptanceEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            materialacceptanceService.saveOrUpdate(materialacceptanceEntity, false);
            MaterialacceptanceVO materialacceptanceVO = BeanMapper.map(materialacceptanceEntity, MaterialacceptanceVO.class);
            //新增采购材料验收主表 end

            //新增采购材料明细表  start
            QueryWrapper<MaterialplanEntity> materialplanEntityQueryWrapper=new QueryWrapper();
            materialplanEntityQueryWrapper.eq("id",entity.getMaterialplanId());
            materialplanEntityQueryWrapper.eq("dr",0);
            MaterialacceptancedetailVO  materialacceptancedetailVO = new MaterialacceptancedetailVO();
            materialacceptancedetailVO.setMaterialacceptanceId(materialacceptanceVO.getId());//验收单主键
            materialacceptancedetailVO.setMaterialId(entity.getMaterialId());//原材料主键
            materialacceptancedetailVO.setMaterialName(entity.getMaterialName());//原材料名称
            materialacceptancedetailVO.setMaterialplanId(entity.getMaterialplanId());//原材料主键
            materialacceptancedetailVO.setPrice(materialplanEntity.getPrice());//单价
            materialacceptancedetailVO.setMaterialTaxRate(materialplanEntity.getMaterialTax());//材料税率
            materialacceptancedetailVO.setQuantity(entity.getNetWeight());//数量
            materialacceptancedetailVO.setNumberPlate(entity.getNumberPlate());//车牌号
            //materialacceptancedetailVO.setReceiptDate(date);//日期
            materialacceptancedetailVO.setPurchasereceiptId(vos.get(i).getId());
            materialacceptancedetailVO.setMaterialTax(materialplanEntity.getMaterialTax().multiply(materialplanEntity.getPrice().multiply(entity.getNetWeight())));//材料税额
            //计算金额
            BigDecimal quantityReceived = entity.getNetWeight();
            BigDecimal  amount =quantityReceived.multiply(materialplanEntity.getPrice()) ;
            materialacceptancedetailVO.setMoney(amount.subtract(materialplanEntity.getMaterialTax().multiply(materialplanEntity.getPrice().multiply(entity.getNetWeight()))));//金额
            materialacceptancedetailVO.setTotal(amount);//合计
            //采购收货单信息进入材料验收单
            MaterialacceptancedetailEntity materialacceptancedetailEntity = BeanMapper.map(materialacceptancedetailVO, MaterialacceptancedetailEntity.class);
            materialacceptancedetailService.saveOrUpdate(materialacceptancedetailEntity, false);
            //新增采购材料明细表  end

            //验收汇总明细表 开始
            MaterialacceptanceSummaryEntity materialacceptanceSummaryEntity = new MaterialacceptanceSummaryEntity();
            materialacceptanceSummaryEntity.setMaterialacceptanceId(materialacceptanceVO.getId());
            materialacceptanceSummaryEntity.setMaterialId(entity.getMaterialId());//原材料ID
            materialacceptanceSummaryEntity.setMaterialName(entity.getMaterialName());//原材料名称
            materialacceptanceSummaryEntity.setPrice(materialacceptancedetailVO.getPrice());//单价
            materialacceptanceSummaryEntity.setQuantity(materialacceptancedetailVO.getQuantity());//数量
            materialacceptanceSummaryEntity.setMoney(materialacceptancedetailVO.getMoney());//不含税金额
            materialacceptanceSummaryEntity.setMaterialTax(materialacceptancedetailVO.getMaterialTax());//税额
            materialacceptanceSummaryEntity.setTotal(materialacceptancedetailVO.getTotal());//总计
            materialacceptanceSummaryEntity.setMaterialTaxRate(materialplanEntity.getMaterialTax());//材料税率
            materialacceptanceSummaryService.saveOrUpdate(materialacceptanceSummaryEntity,false);
            //验收汇总明细表 结束


            //采购材料验收主表回填数据 start
            materialacceptanceEntity.setTotalAmount(amount);//合计金额
            materialacceptanceEntity.setAmount(amount.subtract(materialplanEntity.getMaterialTax().multiply(materialplanEntity.getPrice().multiply(entity.getNetWeight()))));//金额
            materialacceptanceEntity.setAcceptanceQuantity(entity.getNetWeight());//验收数量
            materialacceptanceEntity.setTax(materialplanEntity.getMaterialTax().multiply(materialplanEntity.getPrice().multiply(entity.getNetWeight())));//税额
            materialacceptanceService.updateById(materialacceptanceEntity);
            //采购材料验收主表回填数据 end
        }
        entity.setBillState(3);
        service.updateById(entity);
        //回填定料计划中的已收数量
        QueryWrapper<MaterialplanEntity> materialplanEntityQueryWrapper=new QueryWrapper();
        materialplanEntityQueryWrapper.eq("id",entity.getMaterialplanId());
        materialplanEntityQueryWrapper.eq("dr",0);
        materialplanEntity = materialplanService.getOne(materialplanEntityQueryWrapper);
        //修改运输单子表的状态
        QueryWrapper<PurchasedetilEntity> queryWrapper1 =new QueryWrapper();
        queryWrapper1.eq("id",entity.getCgysId());
        queryWrapper1.eq("dr",0);
        PurchasedetilEntity purchasedetilEntity = purchasedetilService.getOne(queryWrapper1); //查询采购运输单主表
        purchasedetilEntity.setStatus(1);
        purchasedetilEntity.setReceiptQuantity(entity.getNetWeight());//收货数量
        purchasedetilService.updateById(purchasedetilEntity);
        //回填采购运输单收货数量
        QueryWrapper<PurchasedetilEntity> queryWrapper3 =new QueryWrapper();
        PurchasetransportationEntity purchasetransportationEntity = purchasetransportationService.getById(purchasedetilEntity.getPurchasetransportationId());
        queryWrapper3.eq("purchasetransportation_id",purchasedetilEntity.getPurchasetransportationId());
        queryWrapper3.eq("dr",0);
        List<PurchasedetilEntity> purchasedetilEntities =  purchasedetilService.list(queryWrapper3);
        BigDecimal sum = new BigDecimal(0.00);
        for (PurchasedetilEntity temp :    purchasedetilEntities) {
            if(temp.getReceiptQuantity()!=null){
                sum = sum.add(temp.getReceiptQuantity());
            }
        }
        purchasetransportationEntity.setReceiptQuantity(sum);

        purchasetransportationEntity.setReceiptTime(entity.getReceiptTime());
        purchasetransportationService.updateById(purchasetransportationEntity);
        materialplanEntity.setQuantityReceived(sum);
        materialplanService.updateById(materialplanEntity);
        }

        return CommonResponse.success("保存或修改单据成功！");
    }

    /**
     * 判断当前日期是否大于某个日期
     * @param date yyyy-MM-dd
     * @return
     */
    public static boolean afterDate(String date) throws ParseException {
       SimpleDateFormat sdf= new SimpleDateFormat("yyyy-MM-dd");
       Date startDate = new Date();
       Date endDate =sdf.parse(date);

        Calendar start=Calendar.getInstance();

        Calendar end=Calendar.getInstance();

        start.setTime(startDate);

        end.setTime(endDate);
        boolean result = false;
        
      //  return start.after(end);
        if(start.before(end)){
            System.err.println("开始时间小于结束时间");
            result = false;
        }else if(start.after(end)){
            System.err.println("开始时间大于结束时间");
            result = true;
        }else if(start.equals(end)){
            System.err.println("开始时间等于结束时间");
            result = true;
        } 
      return   result;

    }

}
