package com.ejianc.business.purchasingmanagement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.purchasingmanagement.bean.MaterialplanEntity;
import com.ejianc.business.purchasingmanagement.bean.PurchasecontractdetailEntity;
import com.ejianc.business.purchasingmanagement.service.IMaterialplanService;
import com.ejianc.business.purchasingmanagement.service.IPurchasecontractdetailService;
import com.ejianc.business.purchasingmanagement.vo.PurchasetransportationVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.purchasingmanagement.mapper.PurchasetransportationMapper;
import com.ejianc.business.purchasingmanagement.bean.PurchasetransportationEntity;
import com.ejianc.business.purchasingmanagement.service.IPurchasetransportationService;

/**
 * 采购运输信息
 * 
 * @author generator
 * 
 */
@Service("purchasetransportationService")
public class PurchasetransportationServiceImpl extends BaseServiceImpl<PurchasetransportationMapper, PurchasetransportationEntity> implements IPurchasetransportationService{

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IPurchasetransportationService service;
    @Autowired
    private IPurchasecontractdetailService purchasecontractdetailService;
    @Autowired
    private IMaterialplanService materialplanService;

    @Override
    public CommonResponse<PurchasetransportationVO> saveOrupdate(PurchasetransportationVO saveOrUpdateVO) {

        PurchasetransportationEntity entity = BeanMapper.map(saveOrUpdateVO, PurchasetransportationEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        QueryWrapper<MaterialplanEntity> queryWrapper=new QueryWrapper();
        queryWrapper.eq("id",entity.getMaterialplanId());
        MaterialplanEntity materialplanEntity = materialplanService.getOne(queryWrapper);
        PurchasecontractdetailEntity purchasecontractdetailEntity =    purchasecontractdetailService.selectById(materialplanEntity.getPurchasecontractdetailId());

        for (int i = 0 ; i<entity.getPurchasedetilList().size();i++){
            entity.getPurchasedetilList().get(i).setMaterialplanId(entity.getMaterialplanId());//定料计划ID
            entity.getPurchasedetilList().get(i).setSupplierinfoId(entity.getSupplierinfoId());//供应商ID
            entity.getPurchasedetilList().get(i).setSupplierinfoName(entity.getSupplierinfoName());//供应商
            entity.getPurchasedetilList().get(i).setMaterialId(entity.getMaterialId());// 原材料ID
            entity.getPurchasedetilList().get(i).setMaterialName(entity.getMaterialName());//原材料名称
            entity.getPurchasedetilList().get(i).setStatus(0);//未收货
            entity.getPurchasedetilList().get(i).setOrgId(entity.getOrgId());//组织ID
            entity.getPurchasedetilList().get(i).setOrgName(entity.getOrgName());//组织名称
            entity.getPurchasedetilList().get(i).setShippersId(entity.getShippersId());//运输商ID
            entity.getPurchasedetilList().get(i).setShippersName(entity.getShippersName());//运输商名称
            entity.getPurchasedetilList().get(i).setDeductionRate(purchasecontractdetailEntity.getDeductionRate());//扣率
            entity.getPurchasedetilList().get(i).setDecimalPoint(purchasecontractdetailEntity.getDecimalPoint());//小数点
        }
        service.saveOrUpdate(entity, true);
        PurchasetransportationVO vo = BeanMapper.map(entity, PurchasetransportationVO.class);

        materialplanEntity.setIssuedQuantity(vo.getDeliveryQuantity());
        materialplanService.update(materialplanEntity,queryWrapper);

        return CommonResponse.success("保存或修改单据成功！",vo);
    }
}
