/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.purchasingmanagement.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.purchasingmanagement.bean.MaterialpaymentEntity;
import com.ejianc.business.purchasingmanagement.bean.MaterialpaymentdetailEntity;
import com.ejianc.business.purchasingmanagement.service.IMaterialpaymentService;
import com.ejianc.business.purchasingmanagement.vo.MaterialpaymentVO;
import com.ejianc.business.purchasingmanagement.vo.SupplierinvoicedetialVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"materialpayment"})
public class MaterialpaymentController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IMaterialpaymentService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MaterialpaymentVO> saveOrUpdate(@RequestBody MaterialpaymentVO saveOrUpdateVO) {
        MaterialpaymentEntity entity = (MaterialpaymentEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), MaterialpaymentEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            for (MaterialpaymentdetailEntity temp : entity.getMaterialpaymentdetailList()) {
                temp.setId(null);
            }
            if (saveOrUpdateVO.getPrepayment() == 0 && (saveOrUpdateVO.getMaterialpaymentdetailList().size() == 0 || saveOrUpdateVO.getMaterialpaymentdetailList() == null)) {
                throw new BusinessException("\u8bf7\u9009\u4e2d\u9a8c\u6536\u5355\u6570\u636e\uff01");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        MaterialpaymentVO vo = (MaterialpaymentVO)((Object)BeanMapper.map((Object)((Object)entity), MaterialpaymentVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialpaymentVO> queryDetail(Long id) {
        MaterialpaymentEntity entity = (MaterialpaymentEntity)((Object)this.service.selectById(id));
        MaterialpaymentVO vo = (MaterialpaymentVO)((Object)BeanMapper.map((Object)((Object)entity), MaterialpaymentVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialpaymentVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MaterialpaymentVO materialpaymentVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaterialpaymentVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialpaymentVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Materialpayment-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMaterialpaymentData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialpaymentVO>> refMaterialpaymentData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialpaymentVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/supplierinvoicedetialist"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<SupplierinvoicedetialVO>> receivableslist(@RequestBody QueryParam param) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (((Parameter)param.getParams().get("supplierinfo_id")).getValue() != null) {
            queryWrapper.eq((Object)"supplierinfo_id", ((Parameter)param.getParams().get("supplierinfo_id")).getValue());
        }
        if (((Parameter)param.getParams().get("org_Id")).getValue() != null) {
            queryWrapper.eq((Object)"org_Id", ((Parameter)param.getParams().get("org_Id")).getValue());
        }
        List list = this.service.list((Wrapper)queryWrapper);
        ArrayList<SupplierinvoicedetialVO> supplierinvoicedetialVOS = new ArrayList<SupplierinvoicedetialVO>();
        for (MaterialpaymentEntity temp : list) {
            SupplierinvoicedetialVO vo = new SupplierinvoicedetialVO();
            vo.setMaterialacceptanceId(temp.getId());
            vo.setUncollectedMoney(temp.getPaymentAmount());
            vo.setReceivedMoney(new BigDecimal(0.0));
            vo.setOtherReceivedMoney(new BigDecimal(0.0));
            vo.setBillCode(temp.getBillCode());
            vo.setReceivablesDate(temp.getPaymentDate());
            vo.setInvoiceMoney(temp.getPaymentAmount());
            supplierinvoicedetialVOS.add(vo);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", supplierinvoicedetialVOS);
    }

    @RequestMapping(value={"/getMoney"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> getMoney(@RequestParam String supplierinfoId) {
        BigDecimal surplus = new BigDecimal(0.0);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"sum(payment_amount) as total"});
        queryWrapper.eq((Object)"supplierinfo_id", (Object)supplierinfoId);
        queryWrapper.eq((Object)"prepayment", (Object)1);
        queryWrapper.eq((Object)"bill_state", (Object)3);
        Map map = this.service.getMap((Wrapper)queryWrapper);
        Double total = map == null ? Double.valueOf(0.0) : Double.valueOf(String.valueOf(map.get("total")));
        QueryWrapper queryWrapper1 = new QueryWrapper();
        queryWrapper1.select(new String[]{"sum(distribution_money_sum) as moeney,sum(payment_amount) as paymentAmount"});
        queryWrapper1.eq((Object)"supplierinfo_id", (Object)supplierinfoId);
        queryWrapper1.eq((Object)"bill_state", (Object)3);
        queryWrapper1.eq((Object)"prepayment", (Object)0);
        Map map1 = this.service.getMap((Wrapper)queryWrapper1);
        Double moeney = map1 == null ? Double.valueOf(0.0) : Double.valueOf(String.valueOf(map1.get("moeney")));
        Double paymentAmount = map1 == null ? Double.valueOf(0.0) : Double.valueOf(String.valueOf(map1.get("paymentAmount")));
        Double result = total + paymentAmount - moeney;
        surplus = result == 0.0 || result < 0.0 ? BigDecimal.valueOf(0L) : BigDecimal.valueOf(result);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)surplus);
    }
}

