package com.ejianc.business.purchasingmanagement.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 采购运输验收
 * 
 * @author generator
 * 
 */
 @TableName("ejc_purchasingmanagement_transportationacceptance")
public class TransportationacceptanceEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    

    @TableField(value="shippers_id")
    private Long shippersId; // 运输商主键
    @TableField(value="shippers_name")
    private String shippersName; // 运输商名称
    @TableField(value="quantity")
    private BigDecimal quantity; // 验收数量
    @TableField(value="price")
    private BigDecimal price; // 单价
    @TableField(value="money")
    private BigDecimal money; //不含税金额
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率
    @TableField(value="tax")
    private BigDecimal tax; // 税额
    @TableField(value="total_amount")
    private BigDecimal totalAmount; //含税金额
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="status")
    private Integer status; //是否确认 0,未确认  1,已确认
    @TableField(value="shipping_type")
    private Integer shippingType; //运费类型   0，自动 1,手动
    @TableField(value="acceptance_date")
    private Date  acceptanceDate;//验收日期
    @TableField(value="amount_paid")
    private BigDecimal amountPaid; // 已支付金额
    @TableField(value="amount_not_paid")
    private BigDecimal amountNotPaid; // 未支付金额
    @TableField(value="invoice_received")
    private BigDecimal invoiceReceived; // 已收发票金额
    @TableField(value="invoice_not_received")
    private BigDecimal invoiceNotReceived; // 未收发票金额
    @TableField(value="materialplan_id")
    private Long materialplanId; // 定料计划主键
    @TableField(value="purchasecontract_id")
    private Long purchasecontractId; // 采购合同主键
    @TableField(value="purchasecontract_bill_code")
    private String purchasecontractBillCode; //采购合同编码
    @TableField(value="purchasecontractdetail_id")
    private Long purchasecontractdetailId; // 合同子表id
    @TableField(value="purchasecontract_material_name")
    private String purchasecontractMaterialName; //合同子表原材料名称

    @TableField(exist=false)
    @SubEntity(serviceName="transportationdetailService"  , pidName = "transportationacceptanceId")//此处有pid="xxx"，默认值pid="pid"
    private List<TransportationdetailEntity> transportationdetailList = new ArrayList<>(); // 采购运费验收明细表

    @TableField(exist=false)
    @SubEntity(serviceName="transportationSummaryService" , pidName = "transportationacceptanceId")//此处有pid="xxx"，默认值pid="pid"
    private List<TransportationSummaryEntity> transportationSummaryList = new ArrayList<>(); // 运费验收明细汇总

    public List<TransportationSummaryEntity> getTransportationSummaryList() {
        return transportationSummaryList;
    }

    public void setTransportationSummaryList(List<TransportationSummaryEntity> transportationSummaryList) {
        this.transportationSummaryList = transportationSummaryList;
    }

    public String getPurchasecontractBillCode() {
        return purchasecontractBillCode;
    }

    public void setPurchasecontractBillCode(String purchasecontractBillCode) {
        this.purchasecontractBillCode = purchasecontractBillCode;
    }

    public Long getPurchasecontractId() {
        return purchasecontractId;
    }

    public void setPurchasecontractId(Long purchasecontractId) {
        this.purchasecontractId = purchasecontractId;
    }

    public Long getMaterialplanId() {
        return materialplanId;
    }

    public void setMaterialplanId(Long materialplanId) {
        this.materialplanId = materialplanId;
    }

    public BigDecimal getAmountPaid() {
        return amountPaid;
    }

    public void setAmountPaid(BigDecimal amountPaid) {
        this.amountPaid = amountPaid;
    }

    public BigDecimal getAmountNotPaid() {
        return amountNotPaid;
    }

    public void setAmountNotPaid(BigDecimal amountNotPaid) {
        this.amountNotPaid = amountNotPaid;
    }

    public BigDecimal getInvoiceReceived() {
        return invoiceReceived;
    }

    public void setInvoiceReceived(BigDecimal invoiceReceived) {
        this.invoiceReceived = invoiceReceived;
    }

    public BigDecimal getInvoiceNotReceived() {
        return invoiceNotReceived;
    }

    public void setInvoiceNotReceived(BigDecimal invoiceNotReceived) {
        this.invoiceNotReceived = invoiceNotReceived;
    }

    public Integer getShippingType() {
        return shippingType;
    }

    public void setShippingType(Integer shippingType) {
        this.shippingType = shippingType;
    }

    public Date getAcceptanceDate() {
        return acceptanceDate;
    }

    public void setAcceptanceDate(Date acceptanceDate) {
        this.acceptanceDate = acceptanceDate;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public List<TransportationdetailEntity> getTransportationdetailList() {
        return transportationdetailList;
    }

    public void setTransportationdetailList(List<TransportationdetailEntity> transportationdetailList) {
        this.transportationdetailList = transportationdetailList;
    }

    public Long getShippersId() {
        return shippersId;
    }

    public void setShippersId(Long shippersId) {
        this.shippersId = shippersId;
    }
    public String getShippersName() {
        return shippersName;
    }

    public void setShippersName(String shippersName) {
        this.shippersName = shippersName;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getPurchasecontractdetailId() {
        return purchasecontractdetailId;
    }

    public void setPurchasecontractdetailId(Long purchasecontractdetailId) {
        this.purchasecontractdetailId = purchasecontractdetailId;
    }

    public String getPurchasecontractMaterialName() {
        return purchasecontractMaterialName;
    }

    public void setPurchasecontractMaterialName(String purchasecontractMaterialName) {
        this.purchasecontractMaterialName = purchasecontractMaterialName;
    }
}
