package com.ejianc.business.purchasingmanagement.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 采购验收汇总
 * 
 * @author generator
 * 
 */
public class AcceptancesummaryVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long supplierinfoId; // 供应商基本档案主键
    private String supplierinfoName; // 供应商基本档案名称
    private Long materialplanId; // 定料计划主键
    private String materialplanName; // 定料计划名称
    private Long yclpzId; // 原材料品种主键
    private String yclpzName; // 原材料品种名称
    private Long yclggId; // 原材料规格主键
    private String yclggName; // 原材料规格名称
    private Long yclmcId; // 原材料名称主键
    private String yclmcName; // 原材料名称名称
    private Long acceptanceQuantity; // 验收数量（发数）
    private BigDecimal amount; // 金额
    private Long goodsTaxRate; // 货物税率
    private Long goodsTax; // 货物税额
    private BigDecimal totalGoods; // 货物合计
    private Long freightRate; // 运费税率
    private Long freightTax; // 运费税额
    private BigDecimal totalFreight; // 运费合计
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private String billCode; // 单据编号

    @ReferSerialTransfer(referCode="SupplierinfoRef")
    public Long getSupplierinfoId() {
        return supplierinfoId;
    }
    @ReferDeserialTransfer
    public void setSupplierinfoId(Long supplierinfoId) {
        this.supplierinfoId = supplierinfoId;
    }
    public String getSupplierinfoName() {
        return supplierinfoName;
    }

    public void setSupplierinfoName(String supplierinfoName) {
        this.supplierinfoName = supplierinfoName;
    }
    public Long getMaterialplanId() {
        return materialplanId;
    }

    public void setMaterialplanId(Long materialplanId) {
        this.materialplanId = materialplanId;
    }
    public String getMaterialplanName() {
        return materialplanName;
    }

    public void setMaterialplanName(String materialplanName) {
        this.materialplanName = materialplanName;
    }
    public Long getYclpzId() {
        return yclpzId;
    }

    public void setYclpzId(Long yclpzId) {
        this.yclpzId = yclpzId;
    }
    public String getYclpzName() {
        return yclpzName;
    }

    public void setYclpzName(String yclpzName) {
        this.yclpzName = yclpzName;
    }
    public Long getYclggId() {
        return yclggId;
    }

    public void setYclggId(Long yclggId) {
        this.yclggId = yclggId;
    }
    public String getYclggName() {
        return yclggName;
    }

    public void setYclggName(String yclggName) {
        this.yclggName = yclggName;
    }
    public Long getYclmcId() {
        return yclmcId;
    }

    public void setYclmcId(Long yclmcId) {
        this.yclmcId = yclmcId;
    }
    public String getYclmcName() {
        return yclmcName;
    }

    public void setYclmcName(String yclmcName) {
        this.yclmcName = yclmcName;
    }
    public Long getAcceptanceQuantity() {
        return acceptanceQuantity;
    }

    public void setAcceptanceQuantity(Long acceptanceQuantity) {
        this.acceptanceQuantity = acceptanceQuantity;
    }
    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }
    public Long getGoodsTaxRate() {
        return goodsTaxRate;
    }

    public void setGoodsTaxRate(Long goodsTaxRate) {
        this.goodsTaxRate = goodsTaxRate;
    }
    public Long getGoodsTax() {
        return goodsTax;
    }

    public void setGoodsTax(Long goodsTax) {
        this.goodsTax = goodsTax;
    }
    public BigDecimal getTotalGoods() {
        return totalGoods;
    }

    public void setTotalGoods(BigDecimal totalGoods) {
        this.totalGoods = totalGoods;
    }
    public Long getFreightRate() {
        return freightRate;
    }

    public void setFreightRate(Long freightRate) {
        this.freightRate = freightRate;
    }
    public Long getFreightTax() {
        return freightTax;
    }

    public void setFreightTax(Long freightTax) {
        this.freightTax = freightTax;
    }
    public BigDecimal getTotalFreight() {
        return totalFreight;
    }

    public void setTotalFreight(BigDecimal totalFreight) {
        this.totalFreight = totalFreight;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    
}
