package com.ejianc.business.purchasingmanagement.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.purchasingmanagement.bean.FreighttransferdetailEntity;
/**
 * 采购运费调账
 * 
 * @author generator
 * 
 */
 @TableName("ejc_purchasingmanagement_freighttransfer")
public class FreighttransferEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="transporter_id")
    private Long transporterId; // 运输商主键
    @TableField(value="transporter_name")
    private String transporterName; // 运输商名称
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="material_id")
    private Long materialId; // 原材料主键（合同子表原材料）
    @TableField(value="material_name")
    private String materialName; // 原材料名称
    @TableField(value="total_amount")
    private BigDecimal totalAmount; // 合同总金额（即该供应商该合同下所有验收单的总金额）
    @TableField(value="uncollected_amount")
    private BigDecimal uncollectedAmount; // 剩余未收金额
    @TableField(value="adjustment_amount")
    private BigDecimal adjustmentAmount; // 调账金额
    @TableField(value="adjustment_balance")
    private BigDecimal adjustmentBalance; // 调账余额
    @TableField(value="amount_after_adjustment")
    private BigDecimal amountAfterAdjustment; // 调账后金额
    @TableField(value="date")
    private Date date; // 业务发生所属日期
    @TableField(value="entry_date")
    private Date entryDate; // 录时间入
    @TableField(value="reason")
    private String reason; // 调账原因
    @TableField(value="status")
    private Integer status; // 调账状态:1确认0未确认2调账中
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="sign_id")
    private Long signId; // 签认单id
    @TableField(value="distribution_moeny")
    private BigDecimal distributionMoeny; // 分配金额
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="freighttransferdetailService")//此处有pid="xxx"，默认值pid="pid"
    private List<FreighttransferdetailEntity> freighttransferdetailList = new ArrayList<>(); // 采购运费调账子表
    

    public Long getTransporterId() {
        return transporterId;
    }

    public void setTransporterId(Long transporterId) {
        this.transporterId = transporterId;
    }
    public String getTransporterName() {
        return transporterName;
    }

    public void setTransporterName(String transporterName) {
        this.transporterName = transporterName;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }
    public BigDecimal getUncollectedAmount() {
        return uncollectedAmount;
    }

    public void setUncollectedAmount(BigDecimal uncollectedAmount) {
        this.uncollectedAmount = uncollectedAmount;
    }
    public BigDecimal getAdjustmentAmount() {
        return adjustmentAmount;
    }

    public void setAdjustmentAmount(BigDecimal adjustmentAmount) {
        this.adjustmentAmount = adjustmentAmount;
    }
    public BigDecimal getAdjustmentBalance() {
        return adjustmentBalance;
    }

    public void setAdjustmentBalance(BigDecimal adjustmentBalance) {
        this.adjustmentBalance = adjustmentBalance;
    }
    public BigDecimal getAmountAfterAdjustment() {
        return amountAfterAdjustment;
    }

    public void setAmountAfterAdjustment(BigDecimal amountAfterAdjustment) {
        this.amountAfterAdjustment = amountAfterAdjustment;
    }
    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }
    public Date getEntryDate() {
        return entryDate;
    }

    public void setEntryDate(Date entryDate) {
        this.entryDate = entryDate;
    }
    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getSignId() {
        return signId;
    }

    public void setSignId(Long signId) {
        this.signId = signId;
    }
    public BigDecimal getDistributionMoeny() {
        return distributionMoeny;
    }

    public void setDistributionMoeny(BigDecimal distributionMoeny) {
        this.distributionMoeny = distributionMoeny;
    }
    
    public List<FreighttransferdetailEntity> getFreighttransferdetailList() {
        return freighttransferdetailList;
    }

    public void setFreighttransferdetailList(List<FreighttransferdetailEntity> freighttransferdetailList) {
        this.freighttransferdetailList = freighttransferdetailList;
    }
}
