package com.ejianc.business.purchasingmanagement.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.ejianc.business.purchasingmanagement.bean.PurchasedetilEntity;
/**
 * 采购运输信息
 * 
 * @author generator
 * 
 */
 @TableName("ejc_purchasingmanagement_purchasetransportation")
public class PurchasetransportationEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="materialplan_id")
    private Long materialplanId; // 定料计划主键
    @TableField(value="materialplan_name")
    private String materialplanName; // 定料计划名称
    @TableField(value="supplierinfo_id")
    private Long supplierinfoId; // 供应商基本档案主键
    @TableField(value="supplierinfo_name")
    private String supplierinfoName; // 供应商基本档案名称
    @TableField(value="material_id")
    private Long materialId; // 原材料名称主键
    @TableField(value="material_name")
    private String materialName; // 原材料名称名称
    @TableField(value="shippers_id")
    private Long shippersId; // 运输商主键
    @TableField(value="shippers_name")
    private String shippersName; // 运输商名称
    @TableField(value="shippers_vehicle_id")
    private Long shippersVehicleId; // 运输车辆主键
    @TableField(value="shippers_vehicle_name")
    private String shippersVehicleName; // 运输车辆名称
    @TableField(value="delivery_quantity")
    private BigDecimal deliveryQuantity; // 发货数量
    @TableField(value="delivery_time")
    private Date deliveryTime; // 发货时间
    @TableField(value="receipt_quantity")
    private BigDecimal receiptQuantity; // 收货数量
    @TableField(value="receipt_time")
    private Date receiptTime; // 收货时间
    @TableField(value="shipping_method")
    private Integer shippingMethod; // 运输方式
    @TableField(value="distance")
    private BigDecimal distance; //距離
    @TableField(value="unit_price")
    private BigDecimal unitPrice; // 运输单价
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="receivingaddress_id")
    private Long receivingaddressId;    //收货地址ID
    @TableField(value="receiving_address")
    private String receivingAddress;    //收货地址
    @TableField(value="required_quantity")
    private BigDecimal requiredQuantity;    //需求数量
    @TableField(value="tare_weight")
    private BigDecimal tareWeight;    //皮重
    @TableField(value="starting_time")
    private Date startingTime ;//开始时间
    @TableField(value="end_time")
    private Date endTime ;//结束时间
    @TableField(value="is_colse")
    private Integer isColse ;//是否关闭  0-是 1-否


    @TableField(exist=false)
    @SubEntity(serviceName="purchasedetilService"  , pidName="purchasetransportationId")//此处有pid="xxx"，默认值pid="pid"
    private List<PurchasedetilEntity> purchasedetilList = new ArrayList<>(); // 采购运输信息明细

    public Date getStartingTime() {
        return startingTime;
    }

    public void setStartingTime(Date startingTime) {
        this.startingTime = startingTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public BigDecimal getTareWeight() {
        return tareWeight;
    }

    public void setTareWeight(BigDecimal tareWeight) {
        this.tareWeight = tareWeight;
    }

    public BigDecimal getDeliveryQuantity() {
        return deliveryQuantity;
    }

    public void setDeliveryQuantity(BigDecimal deliveryQuantity) {
        this.deliveryQuantity = deliveryQuantity;
    }

    public BigDecimal getReceiptQuantity() {
        return receiptQuantity;
    }

    public void setReceiptQuantity(BigDecimal receiptQuantity) {
        this.receiptQuantity = receiptQuantity;
    }

    public BigDecimal getDistance() {
        return distance;
    }

    public void setDistance(BigDecimal distance) {
        this.distance = distance;
    }

    public Long getReceivingaddressId() {
        return receivingaddressId;
    }

    public void setReceivingaddressId(Long receivingaddressId) {
        this.receivingaddressId = receivingaddressId;
    }

    public String getReceivingAddress() {
        return receivingAddress;
    }

    public void setReceivingAddress(String receivingAddress) {
        this.receivingAddress = receivingAddress;
    }

    public BigDecimal getRequiredQuantity() {
        return requiredQuantity;
    }

    public void setRequiredQuantity(BigDecimal requiredQuantity) {
        this.requiredQuantity = requiredQuantity;
    }

    public List<PurchasedetilEntity> getPurchasedetilList() {
        return purchasedetilList;
    }

    public void setPurchasedetilList(List<PurchasedetilEntity> purchasedetilList) {
        this.purchasedetilList = purchasedetilList;
    }
    public Long getMaterialplanId() {
        return materialplanId;
    }

    public void setMaterialplanId(Long materialplanId) {
        this.materialplanId = materialplanId;
    }
    public String getMaterialplanName() {
        return materialplanName;
    }

    public void setMaterialplanName(String materialplanName) {
        this.materialplanName = materialplanName;
    }
    public Long getSupplierinfoId() {
        return supplierinfoId;
    }

    public void setSupplierinfoId(Long supplierinfoId) {
        this.supplierinfoId = supplierinfoId;
    }
    public String getSupplierinfoName() {
        return supplierinfoName;
    }

    public void setSupplierinfoName(String supplierinfoName) {
        this.supplierinfoName = supplierinfoName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public Long getShippersId() {
        return shippersId;
    }

    public void setShippersId(Long shippersId) {
        this.shippersId = shippersId;
    }
    public String getShippersName() {
        return shippersName;
    }

    public void setShippersName(String shippersName) {
        this.shippersName = shippersName;
    }
    public Long getShippersVehicleId() {
        return shippersVehicleId;
    }

    public void setShippersVehicleId(Long shippersVehicleId) {
        this.shippersVehicleId = shippersVehicleId;
    }
    public String getShippersVehicleName() {
        return shippersVehicleName;
    }

    public void setShippersVehicleName(String shippersVehicleName) {
        this.shippersVehicleName = shippersVehicleName;
    }

    public Date getDeliveryTime() {
        return deliveryTime;
    }

    public void setDeliveryTime(Date deliveryTime) {
        this.deliveryTime = deliveryTime;
    }

    public Date getReceiptTime() {
        return receiptTime;
    }

    public void setReceiptTime(Date receiptTime) {
        this.receiptTime = receiptTime;
    }
    public Integer getShippingMethod() {
        return shippingMethod;
    }

    public void setShippingMethod(Integer shippingMethod) {
        this.shippingMethod = shippingMethod;
    }

    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getIsColse() {
        return isColse;
    }

    public void setIsColse(Integer isColse) {
        this.isColse = isColse;
    }
}
