package com.ejianc.business.purchasingmanagement.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 采购调账单子表
 * 
 * @author generator
 * 
 */
public class SalesreconciliationdetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long mid; // 
    private String billCode; // 验收单编号
    private Long supplierId; // 供应商主键
    private String supplierName; // 供应商名称
    private Long materialId; // 原材料主键（即采购合同子表主键）
    private String materialName; // 原材料名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date acceptanceTime; // 验收日期
    private BigDecimal taxMoney; // 含税金额
    private BigDecimal unpaidMoney; // 应付未付金额
    private BigDecimal distributionMoney; // 分配金额
    private BigDecimal adjustedMoney; // 调整后金额
    private Long materialacceptanceId; // 验收单主键
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    

    public Long getMid() {
        return mid;
    }

    public void setMid(Long mid) {
        this.mid = mid;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="SupplierinfoRef")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    @ReferSerialTransfer(referCode="PurchaseContractRef")
    public Long getMaterialId() {
        return materialId;
    }

    @ReferDeserialTransfer
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public Date getAcceptanceTime() {
        return acceptanceTime;
    }

    public void setAcceptanceTime(Date acceptanceTime) {
        this.acceptanceTime = acceptanceTime;
    }
    public BigDecimal getTaxMoney() {
        return taxMoney;
    }

    public void setTaxMoney(BigDecimal taxMoney) {
        this.taxMoney = taxMoney;
    }
    public BigDecimal getUnpaidMoney() {
        return unpaidMoney;
    }

    public void setUnpaidMoney(BigDecimal unpaidMoney) {
        this.unpaidMoney = unpaidMoney;
    }
    public BigDecimal getDistributionMoney() {
        return distributionMoney;
    }

    public void setDistributionMoney(BigDecimal distributionMoney) {
        this.distributionMoney = distributionMoney;
    }
    public BigDecimal getAdjustedMoney() {
        return adjustedMoney;
    }

    public void setAdjustedMoney(BigDecimal adjustedMoney) {
        this.adjustedMoney = adjustedMoney;
    }
    public Long getMaterialacceptanceId() {
        return materialacceptanceId;
    }

    public void setMaterialacceptanceId(Long materialacceptanceId) {
        this.materialacceptanceId = materialacceptanceId;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
}
