package com.ejianc.business.purchasingmanagement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.purchasingmanagement.bean.*;
import com.ejianc.business.purchasingmanagement.vo.*;
import com.ejianc.business.purchasingmanagement.service.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.purchasingmanagement.mapper.WeighingInfoMapper;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 称重信息
 *
 * @author generator
 *
 */
@Service("weighingInfoService")
public class WeighingInfoServiceImpl extends BaseServiceImpl<WeighingInfoMapper, WeighingInfoEntity> implements IWeighingInfoService{
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IWeighingInfoService service;
    @Autowired
    private IPurchasedetilService purchasedetilService;
    @Autowired
    private IMaterialplanService materialplanService;
    @Autowired
    private IPurchasetransportationService purchasetransportationService;
    @Autowired
    private IPurchasereceiptService purchasereceiptService;
    @Autowired
    private IMaterialacceptanceService materialacceptanceService;
    @Autowired
    private IPurchasecontractdetailService purchasecontractdetailService;
    @Autowired
    private IPurchaseContractService purchaseContractService;
    @Autowired
    private IMaterialacceptanceSummaryService materialacceptanceSummaryService;
    @Autowired
    private ITransportationacceptanceService transportationacceptanceService;
    @Autowired
    private ITransportationSummaryService transportationSummaryService;

    @Autowired
    private SessionManager sessionManager;
    @Override
    @Transactional(rollbackFor = Exception.class)
    public CommonResponse<WeighingInfoVO> saveChange(WeighingInfoVO saveOrUpdateVO) {
        Date date = new Date();
        WeighingInfoEntity entity = BeanMapper.map(saveOrUpdateVO, WeighingInfoEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                //   entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        WeighingInfoVO vo = BeanMapper.map(entity, WeighingInfoVO.class);

        if(1==vo.getWeighingMethod()){
            //毛重
            QueryWrapper<PurchasedetilEntity> queryWrapper=new QueryWrapper();
            queryWrapper.eq("number_plate",vo.getNumberPlate());
            queryWrapper.eq("status",0);
            queryWrapper.eq("materialplan_id",vo.getMaterialplanId());
            queryWrapper.eq("id",saveOrUpdateVO.getPurchasedetilId());
            PurchasedetilEntity  purchasedetilEntity = purchasedetilService.getOne(queryWrapper);
            PurchasereceiptEntity purchasereceiptEntity  = new PurchasereceiptEntity();
            purchasereceiptEntity.setOrgId(purchasedetilEntity.getOrgId());
            purchasereceiptEntity.setOrgName(purchasedetilEntity.getOrgName());
            purchasereceiptEntity.setMaterialplanId(purchasedetilEntity.getMaterialplanId());
            purchasereceiptEntity.setSupplierinfoId(purchasedetilEntity.getSupplierinfoId());
            purchasereceiptEntity.setSupplierinfoName(purchasedetilEntity.getSupplierinfoName());
            purchasereceiptEntity.setShippersVehicleId(purchasedetilEntity.getShippersVehicleId());
            purchasereceiptEntity.setShippersVehicleName(purchasedetilEntity.getShippersVehicleName());
            purchasereceiptEntity.setNumberPlate(saveOrUpdateVO.getNumberPlate());
            purchasereceiptEntity.setMaterialId(purchasedetilEntity.getMaterialId());
            purchasereceiptEntity.setMaterialName(purchasedetilEntity.getMaterialName());
            purchasereceiptEntity.setReceiptTime(date);
            purchasereceiptEntity.setCgysId(purchasedetilEntity.getId());
            purchasereceiptEntity.setReceipt(0);
            purchasereceiptEntity.setAudit(0);
            purchasereceiptEntity.setReturnStatus(0);
            purchasereceiptEntity.setReceiptType(1);
            purchasereceiptEntity.setUnloadedStatus(0);
            // purchasereceiptEntity.setTare(purchasedetilEntity.getTareWeight());//皮重
            purchasereceiptEntity.setGrossWeight(vo.getWeight());//毛重
            PurchasereceiptVO purchasereceiptVO  = new PurchasereceiptVO();
            if(purchasereceiptEntity.getId() == null || purchasereceiptEntity.getId() == 0){
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),purchasereceiptVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    purchasereceiptEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            purchasereceiptService.saveOrUpdate(purchasereceiptEntity, false);
            purchasereceiptVO = BeanMapper.map(purchasereceiptEntity, PurchasereceiptVO.class);

            entity.setId(vo.getId());
            entity.setPurchasereceiptId(purchasereceiptVO.getId());
            service.updateById(entity);

        }else if(2==vo.getWeighingMethod()){
            //皮重
            QueryWrapper<PurchasedetilEntity> queryWrapper=new QueryWrapper();
            queryWrapper.eq("number_plate",vo.getNumberPlate());
            queryWrapper.eq("status",0);
            queryWrapper.eq("materialplan_id",vo.getMaterialplanId());
            queryWrapper.eq("id",saveOrUpdateVO.getPurchasedetilId());
            PurchasedetilEntity purchasedetilEntity = purchasedetilService.getOne(queryWrapper);
            QueryWrapper<PurchasereceiptEntity> purchasereceiptEntityQueryWrapper  =new QueryWrapper();
            purchasereceiptEntityQueryWrapper.eq("number_plate",vo.getNumberPlate());
            purchasereceiptEntityQueryWrapper.eq("receipt",0);
            purchasereceiptEntityQueryWrapper.eq("materialplan_id",vo.getMaterialplanId());
            purchasereceiptEntityQueryWrapper.eq("cgys_id",saveOrUpdateVO.getPurchasedetilId());
            PurchasereceiptEntity purchasereceiptEntity = purchasereceiptService.getOne(purchasereceiptEntityQueryWrapper);
            purchasereceiptEntity.setNetWeight(vo.getNetWeight());//净重
            purchasereceiptEntity.setTare(vo.getWeight());//皮重
            purchasereceiptEntity.setReceipt(1);
            purchasereceiptEntity.setPrintGrossWeight(saveOrUpdateVO.getPrintGrossWeight());//打印毛重
            purchasereceiptEntity.setDeductionRate(saveOrUpdateVO.getDeductionRate());//扣率
            purchasereceiptEntity.setDecimalPoint(saveOrUpdateVO.getDecimalPoint());//小数位
            purchasereceiptService.updateById(purchasereceiptEntity);

            QueryWrapper<MaterialplanEntity> materialplanEntityQueryWrapper=new QueryWrapper();
            materialplanEntityQueryWrapper.eq("id",purchasereceiptEntity.getMaterialplanId());
            materialplanEntityQueryWrapper.eq("dr",0);
            MaterialplanEntity materialplanEntity = materialplanService.getOne(materialplanEntityQueryWrapper);
            materialplanEntity.setQuantityReceived(purchasereceiptEntity.getNetWeight());
            materialplanService.update(materialplanEntity,materialplanEntityQueryWrapper);
            //修改运输单子表的状态
            QueryWrapper<PurchasedetilEntity> queryWrapper1 =new QueryWrapper();
            queryWrapper1.eq("id",purchasereceiptEntity.getCgysId());
            queryWrapper1.eq("dr",0);
            //purchasedetilEntity = purchasedetilService.getOne(queryWrapper1); //查询采购运输单主表
            purchasedetilEntity.setStatus(1);
            purchasedetilEntity.setReceiptQuantity(purchasereceiptEntity.getNetWeight());//收货数量
            purchasedetilEntity.setReceiptTime(date);//收货时间
            purchasedetilService.update(purchasedetilEntity,queryWrapper1);
            //回填采购运输单收货数量

            entity.setId(vo.getId());
            entity.setPurchasereceiptId(purchasereceiptEntity.getId());
            QueryWrapper<PurchasedetilEntity> queryWrapper3 =new QueryWrapper();
            PurchasetransportationEntity purchasetransportationEntity = purchasetransportationService.getById(purchasedetilEntity.getPurchasetransportationId());
            queryWrapper3.eq("purchasetransportation_id",purchasedetilEntity.getPurchasetransportationId());
            queryWrapper3.eq("dr",0);
            List<PurchasedetilEntity> purchasedetilEntities =  purchasedetilService.list(queryWrapper3);
            BigDecimal sum = new BigDecimal(0.00);
            for (PurchasedetilEntity temp :    purchasedetilEntities) {
                if(temp.getReceiptQuantity()!=null){
                    sum = sum.add(temp.getReceiptQuantity());
                }
            }
            purchasetransportationEntity.setReceiptQuantity(sum);
            purchasetransportationService.updateById(purchasetransportationEntity);
            materialplanEntity.setQuantityReceived(sum);
            materialplanService.updateById(materialplanEntity);
            service.updateById(entity);
            //-----无人值守回皮之后生成采购材料验收单和采购部运费验收单 start -------
            //合同子表信息
            PurchasecontractdetailEntity detailEntity = purchasecontractdetailService.getById(materialplanEntity.getPurchasecontractdetailId());
            QueryWrapper<MaterialacceptanceEntity> queryWrapper2 = new QueryWrapper<>();
            queryWrapper2.eq("purchasecontract_id",materialplanEntity.getPurchasecontractId());
            queryWrapper2.eq("purchasecontract_material_id",materialplanEntity.getPurchasecontractdetailId());
            //queryWrapper2.eq("manufacturer_id",detailEntity.getManufacturerId());
            queryWrapper2.eq("acceptance_date",new SimpleDateFormat("yyyy-MM-dd").format(purchasereceiptEntity.getReceiptTime()));
            //根据合同主表id和合同子表id、生产厂商、验收日期（即收货时间）查询
            MaterialacceptanceEntity materialacceptanceEntity = materialacceptanceService.getOne(queryWrapper2);
            PurchaseContractEntity purchaseContractEntity = purchaseContractService.getById(materialplanEntity.getPurchasecontractId());
            //如果不存在新增材料采购验收主表和子表，如果存在新增子表信息并且修改主表信息
            List<MaterialacceptanceSummaryVO> list = new ArrayList<>();
            MaterialacceptanceSummaryVO summaryVO = new MaterialacceptanceSummaryVO();
            if(materialacceptanceEntity == null){
                summaryVO.setReceiptDate(purchasereceiptEntity.getReceiptTime());
                summaryVO.setMaterialId(detailEntity.getId());
                summaryVO.setMaterialName(detailEntity.getMaterialName());
                summaryVO.setPurchasereceiptId(purchasereceiptEntity.getId());
                summaryVO.setNumberPlate(purchasereceiptEntity.getNumberPlate());
                summaryVO.setQuantity(purchasereceiptEntity.getNetWeight());
                summaryVO.setPrice(detailEntity.getPrice());
                summaryVO.setNoTaxPrice(detailEntity.getMoney());
                summaryVO.setMaterialTaxRate(detailEntity.getMaterialTax());
                //BigDecimal money = summaryVO.getQuantity().multiply(summaryVO.getMaterialTaxRate().multiply(summaryVO.getPrice()));
                BigDecimal tax = new BigDecimal(1.00).add(summaryVO.getMaterialTaxRate());
                summaryVO.setTotal(summaryVO.getPrice().multiply(summaryVO.getQuantity()));//含税金额
                summaryVO.setMoney(summaryVO.getTotal().divide(tax,2,BigDecimal.ROUND_HALF_UP));//不含税金额
                summaryVO.setMaterialTax(summaryVO.getTotal().subtract(summaryVO.getMoney()));//税额
                list.add(summaryVO);
                MaterialacceptanceVO materialacceptanceVO = new MaterialacceptanceVO();
                materialacceptanceVO.setSupplierinfoId(materialplanEntity.getSupplierinfoId());
                materialacceptanceVO.setSupplierinfoName(materialplanEntity.getSupplierinfoName());
                materialacceptanceVO.setAcceptanceQuantity(summaryVO.getQuantity());
                materialacceptanceVO.setMaterialplanId(materialplanEntity.getId());
                materialacceptanceVO.setMaterialplanName(materialplanEntity.getBillCode());
                materialacceptanceVO.setTax(summaryVO.getMaterialTax());
                materialacceptanceVO.setManufacturerId(detailEntity.getManufacturerId());
                materialacceptanceVO.setManufacturerName(detailEntity.getManufacturerName());
                materialacceptanceVO.setPurchasecontractId(materialplanEntity.getPurchasecontractId());
                materialacceptanceVO.setPurchasecontractBillCode(purchaseContractEntity.getBillCode());
                materialacceptanceVO.setPurchasecontractMaterialId(materialplanEntity.getPurchasecontractdetailId());
                materialacceptanceVO.setPurchasecontractMaterialName(detailEntity.getMaterialName());
                materialacceptanceVO.setAmount(summaryVO.getMoney());
                materialacceptanceVO.setTotalAmount(summaryVO.getTotal());
                materialacceptanceVO.setAcceptanceDate(purchasereceiptEntity.getReceiptTime());
                materialacceptanceVO.setOrgId(purchaseContractEntity.getOrgId());
                materialacceptanceVO.setOrgName(purchaseContractEntity.getOrgName());

                materialacceptanceVO.setAmountPaid(new BigDecimal(0.00));
                materialacceptanceVO.setMeetMoney(materialacceptanceVO.getTotalAmount());
                materialacceptanceVO.setAmountNotPaid(materialacceptanceVO.getMeetMoney().subtract(materialacceptanceVO.getAmountPaid()));
                materialacceptanceVO.setInvoiceReceived(new BigDecimal(0.00));
                materialacceptanceVO.setInvoiceNotReceived(materialacceptanceVO.getTotalAmount());
                materialacceptanceVO.setMaterialacceptanceSummaryList(list);
                MaterialacceptanceEntity materialacceptance = BeanMapper.map(materialacceptanceVO, MaterialacceptanceEntity.class);
                if(materialacceptance.getId() == null || materialacceptance.getId() == 0){
                    BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),materialacceptanceVO);
                    CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                    if(billCode.isSuccess()) {
                        // entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                        materialacceptance.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                    }else{
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                }
                //生成信息
                materialacceptanceService.saveOrUpdate(materialacceptance,false);
            }else{//新增子表并且修改主表数据
                QueryWrapper<MaterialacceptanceSummaryEntity> sumEntity = new QueryWrapper<>();
                sumEntity.eq("purchasereceipt_id",purchasereceiptEntity.getId());
                MaterialacceptanceSummaryEntity materialacceptanceSummaryEntity = materialacceptanceSummaryService.getOne(sumEntity);
                if(materialacceptanceSummaryEntity == null){
                    summaryVO.setMaterialacceptanceId(materialacceptanceEntity.getId());
                    summaryVO.setReceiptDate(purchasereceiptEntity.getReceiptTime());
                    summaryVO.setMaterialId(detailEntity.getId());
                    summaryVO.setMaterialName(detailEntity.getMaterialName());
                    summaryVO.setPurchasereceiptId(purchasereceiptEntity.getId());
                    summaryVO.setNumberPlate(purchasereceiptEntity.getNumberPlate());
                    summaryVO.setQuantity(purchasereceiptEntity.getNetWeight());
                    summaryVO.setPrice(detailEntity.getPrice());
                    summaryVO.setNoTaxPrice(detailEntity.getMoney());
                    summaryVO.setMaterialTaxRate(detailEntity.getMaterialTax());
                    //BigDecimal money = summaryVO.getQuantity().multiply(summaryVO.getMaterialTaxRate().multiply(summaryVO.getPrice()));
                    BigDecimal tax = new BigDecimal(1.00).add(summaryVO.getMaterialTaxRate());
                    summaryVO.setTotal(summaryVO.getPrice().multiply(summaryVO.getQuantity()));//含税金额
                    summaryVO.setMoney(summaryVO.getTotal().divide(tax,2,BigDecimal.ROUND_HALF_UP));//不含税金额
                    summaryVO.setMaterialTax(summaryVO.getTotal().subtract(summaryVO.getMoney()));//税额
                    MaterialacceptanceSummaryEntity summaryEntity = BeanMapper.map(summaryVO, MaterialacceptanceSummaryEntity.class);
                    materialacceptanceSummaryService.save(summaryEntity);
                }else{
                    summaryVO.setMaterialacceptanceId(materialacceptanceEntity.getId());
                    summaryVO.setReceiptDate(purchasereceiptEntity.getReceiptTime());
                    summaryVO.setMaterialId(detailEntity.getId());
                    summaryVO.setMaterialName(detailEntity.getMaterialName());
                    summaryVO.setPurchasereceiptId(purchasereceiptEntity.getId());
                    summaryVO.setNumberPlate(purchasereceiptEntity.getNumberPlate());
                    summaryVO.setQuantity(purchasereceiptEntity.getNetWeight());
                    summaryVO.setPrice(detailEntity.getPrice());
                    summaryVO.setNoTaxPrice(detailEntity.getMoney());
                    summaryVO.setMaterialTaxRate(detailEntity.getMaterialTax());
                    //BigDecimal money = summaryVO.getQuantity().multiply(summaryVO.getMaterialTaxRate().multiply(summaryVO.getPrice()));
                    BigDecimal tax = new BigDecimal(1.00).add(summaryVO.getMaterialTaxRate());
                    summaryVO.setTotal(summaryVO.getPrice().multiply(summaryVO.getQuantity()));//含税金额
                    summaryVO.setMoney(summaryVO.getTotal().divide(tax,2,BigDecimal.ROUND_HALF_UP));//不含税金额
                    summaryVO.setMaterialTax(summaryVO.getTotal().subtract(summaryVO.getMoney()));//税额
                    MaterialacceptanceSummaryEntity summaryEntity = BeanMapper.map(summaryVO, MaterialacceptanceSummaryEntity.class);
                    materialacceptanceSummaryService.updateById(summaryEntity);
                }
                //根据销售单主表id、产品id、运输方式汇总实收数量到销售产品表总的销售数量
                QueryWrapper<MaterialacceptanceSummaryEntity> queryWrapper4 = new QueryWrapper<>();
                queryWrapper4.select("sum(quantity) as quantity,sum(money) as money,sum(material_tax) as tax,sum(total) as total");
                queryWrapper4.eq("materialacceptance_id",materialacceptanceEntity.getId());
                Map<String, Object> map = materialacceptanceSummaryService.getMap(queryWrapper4);
                //修改主表信息
                materialacceptanceEntity.setAcceptanceQuantity(new BigDecimal(Double.valueOf(String.valueOf(map.get("quantity")))));
                materialacceptanceEntity.setAmount(new BigDecimal(Double.valueOf(String.valueOf(map.get("money")))));
                materialacceptanceEntity.setTax(new BigDecimal(Double.valueOf(String.valueOf(map.get("tax")))));
                materialacceptanceEntity.setTotalAmount(new BigDecimal(Double.valueOf(String.valueOf(map.get("total")))));

                materialacceptanceEntity.setMeetMoney(materialacceptanceEntity.getTotalAmount());
                materialacceptanceEntity.setAmountNotPaid(materialacceptanceEntity.getMeetMoney().subtract(materialacceptanceEntity.getAmountPaid()));
                materialacceptanceEntity.setInvoiceNotReceived(materialacceptanceEntity.getTotalAmount());
                materialacceptanceService.updateById(materialacceptanceEntity);
            }
            //判断有误运费，有运费生成运费验收单
            if(detailEntity.getFreight() == 1){//有运费
                //根据验收时间、运输商和合同子表id查询运费验收单
                QueryWrapper<TransportationacceptanceEntity> queryWrapper4 = new QueryWrapper<>();
                queryWrapper4.eq("shippers_id",detailEntity.getShippersId());
                queryWrapper4.eq("purchasecontractdetail_id",detailEntity.getId());
                queryWrapper4.eq("acceptance_date",new SimpleDateFormat("yyyy-MM-dd").format(purchasereceiptEntity.getReceiptTime()));
                TransportationacceptanceEntity tranEntity = transportationacceptanceService.getOne(queryWrapper4);
                List<TransportationSummaryVO> tranList = new ArrayList<>();
                TransportationSummaryVO tranVO = new TransportationSummaryVO();
                if(tranEntity == null){
                    tranVO.setReceivedDate(purchasereceiptEntity.getReceiptTime());
                    tranVO.setNumberPlate(purchasereceiptEntity.getNumberPlate());
                    tranVO.setMaterialId(detailEntity.getId());
                    tranVO.setMaterialName(detailEntity.getMaterialName());
                    tranVO.setPrice(detailEntity.getSjyfPrice());
                    tranVO.setQuantity(purchasereceiptEntity.getNetWeight());
                    tranVO.setFreightRate(detailEntity.getFreightRate());
                    //BigDecimal money = tranVO.getPrice().multiply(tranVO.getFreightRate()).multiply(tranVO.getQuantity());
                    BigDecimal tax = new BigDecimal(1.00).add(tranVO.getFreightRate());
                    tranVO.setTotal(tranVO.getPrice().multiply(tranVO.getQuantity()));//含税金额
                    tranVO.setAmount(tranVO.getTotal().divide(tax,2,BigDecimal.ROUND_HALF_UP));//不含税金额
                    tranVO.setFreightTax(tranVO.getTotal().subtract(tranVO.getAmount()));//税额
                    tranList.add(tranVO);
                    TransportationacceptanceVO transportationacceptanceVO = new TransportationacceptanceVO();
                    transportationacceptanceVO.setShippersId(detailEntity.getShippersId());
                    transportationacceptanceVO.setShippersName(detailEntity.getShippersName());
                    transportationacceptanceVO.setQuantity(tranVO.getQuantity());
                    transportationacceptanceVO.setMoney(tranVO.getAmount());
                    transportationacceptanceVO.setTax(tranVO.getFreightTax());
                    transportationacceptanceVO.setTotalAmount(tranVO.getTotal());
                    transportationacceptanceVO.setPurchasecontractId(materialplanEntity.getPurchasecontractId());
                    transportationacceptanceVO.setPurchasecontractBillCode(purchaseContractEntity.getBillCode());
                    transportationacceptanceVO.setPurchasecontractdetailId(materialplanEntity.getPurchasecontractdetailId());
                    transportationacceptanceVO.setPurchasecontractMaterialName(detailEntity.getMaterialName());
                    transportationacceptanceVO.setAcceptanceDate(purchasereceiptEntity.getReceiptTime());
                    transportationacceptanceVO.setOrgId(purchaseContractEntity.getOrgId());
                    transportationacceptanceVO.setOrgName(purchaseContractEntity.getOrgName());

                    transportationacceptanceVO.setMeetMoney(transportationacceptanceVO.getTotalAmount());
                    transportationacceptanceVO.setAmountPaid(new BigDecimal(0.00));
                    transportationacceptanceVO.setAmountNotPaid(transportationacceptanceVO.getTotalAmount());
                    transportationacceptanceVO.setInvoiceReceived(new BigDecimal(0.00));
                    transportationacceptanceVO.setInvoiceNotReceived(transportationacceptanceVO.getTotalAmount());
                    transportationacceptanceVO.setTransportationSummaryList(tranList);
                    TransportationacceptanceEntity transportationacceptanceEntity = BeanMapper.map(transportationacceptanceVO, TransportationacceptanceEntity.class);
                    if(transportationacceptanceEntity.getId() == null || transportationacceptanceEntity.getId() == 0){
                        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
                        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                        if(billCode.isSuccess()) {
                            // entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                            transportationacceptanceEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                        }else{
                            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                        }
                    }
                    transportationacceptanceService.saveOrUpdate(transportationacceptanceEntity,false);
                }else{
                    QueryWrapper<TransportationSummaryEntity> queryWrapper6 = new QueryWrapper<>();
                    queryWrapper6.eq("purchasereceipt_id",purchasereceiptEntity.getId());
                    TransportationSummaryEntity TransportationSummaryEntity = transportationSummaryService.getOne(queryWrapper6);
                    if(TransportationSummaryEntity == null){
                        tranVO.setTransportationacceptanceId(tranEntity.getId());
                        tranVO.setReceivedDate(purchasereceiptEntity.getReceiptTime());
                        tranVO.setNumberPlate(purchasereceiptEntity.getNumberPlate());
                        tranVO.setMaterialId(detailEntity.getId());
                        tranVO.setMaterialName(detailEntity.getMaterialName());
                        tranVO.setPrice(detailEntity.getSjyfPrice());
                        tranVO.setQuantity(purchasereceiptEntity.getNetWeight());
                        tranVO.setFreightRate(detailEntity.getFreightRate());
                        //BigDecimal money = tranVO.getPrice().multiply(tranVO.getFreightRate()).multiply(tranVO.getQuantity());
                        BigDecimal tax = new BigDecimal(1.00).add(tranVO.getFreightRate());
                        tranVO.setTotal(tranVO.getPrice().multiply(tranVO.getQuantity()));//含税金额
                        tranVO.setAmount(tranVO.getTotal().divide(tax,2,BigDecimal.ROUND_HALF_UP));//不含税金额
                        tranVO.setFreightTax(tranVO.getTotal().subtract(tranVO.getAmount()));//税额
                        TransportationSummaryEntity transportationSummaryEntity = BeanMapper.map(tranVO, TransportationSummaryEntity.class);
                        transportationSummaryService.save(transportationSummaryEntity);
                    }else{
                        tranVO.setTransportationacceptanceId(tranEntity.getId());
                        tranVO.setReceivedDate(purchasereceiptEntity.getReceiptTime());
                        tranVO.setNumberPlate(purchasereceiptEntity.getNumberPlate());
                        tranVO.setMaterialId(detailEntity.getId());
                        tranVO.setMaterialName(detailEntity.getMaterialName());
                        tranVO.setPrice(detailEntity.getSjyfPrice());
                        tranVO.setQuantity(purchasereceiptEntity.getNetWeight());
                        tranVO.setFreightRate(detailEntity.getFreightRate());
                        //BigDecimal money = tranVO.getPrice().multiply(tranVO.getFreightRate()).multiply(tranVO.getQuantity());
                        BigDecimal tax = new BigDecimal(1.00).add(tranVO.getFreightRate());
                        tranVO.setTotal(tranVO.getPrice().multiply(tranVO.getQuantity()));//含税金额
                        tranVO.setAmount(tranVO.getTotal().divide(tax,2,BigDecimal.ROUND_HALF_UP));//不含税金额
                        tranVO.setFreightTax(tranVO.getTotal().subtract(tranVO.getAmount()));//税额
                        TransportationSummaryEntity transportationSummaryEntity = BeanMapper.map(tranVO, TransportationSummaryEntity.class);
                        transportationSummaryService.updateById(transportationSummaryEntity);
                    }
                    //根据销售单主表id、产品id、运输方式汇总实收数量到销售产品表总的销售数量
                    QueryWrapper<TransportationSummaryEntity> queryWrapper5 = new QueryWrapper<>();
                    queryWrapper5.select("sum(quantity) as quantity,sum(amount) as amount,sum(freight_tax) as tax,sum(total) as total");
                    queryWrapper5.eq("transportationacceptance_id",tranEntity.getId());
                    Map<String, Object> map = transportationSummaryService.getMap(queryWrapper5);
                    //修改主表信息
                    tranEntity.setQuantity(new BigDecimal(Double.valueOf(String.valueOf(map.get("quantity")))));
                    tranEntity.setMoney(new BigDecimal(Double.valueOf(String.valueOf(map.get("amount")))));
                    tranEntity.setTax(new BigDecimal(Double.valueOf(String.valueOf(map.get("tax")))));
                    tranEntity.setTotalAmount(new BigDecimal(Double.valueOf(String.valueOf(map.get("total")))));

                    tranEntity.setMeetMoney(tranEntity.getTotalAmount());
                    tranEntity.setAmountNotPaid(tranEntity.getTotalAmount());
                    tranEntity.setInvoiceNotReceived(tranEntity.getTotalAmount());
                    transportationacceptanceService.updateById(tranEntity);
                }
            }
        }
        return CommonResponse.success("保存或修改单据成功！",vo);
    }
}
