package com.ejianc.business.purchasingmanagement.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 采购材料调账
 * 
 * @author generator
 * 
 */
public class SalesreconciliationVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long supplierinfoId; // 供应商基本档案主键
    private String supplierinfoName; // 供应商基本档案名称
    private BigDecimal acceptanceQuantity; // 验收数量
    private BigDecimal price; // 单价
    private BigDecimal amount; // 不含税金额
    private BigDecimal taxrate; // 税率
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private String billCode; // 单据编号
    private Long materialId; // 原材类主键
    private BigDecimal totalAmount; // 含税金额
    private String materialName; // 原材类名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date acceptanceDate; // 验收时间
    private BigDecimal tax; // 税额
    private BigDecimal amountPaid; // 已支付金额
    private BigDecimal amountNotPaid; // 未支付金额
    private BigDecimal invoiceReceived; // 已收发票金额
    private BigDecimal invoiceNotReceived; // 未收发票金额
    private Long purchasecontractId; // 采购合同主键
    private String purchasecontractBillCode; // 
    private String purchasecontractName; // 采购合同名称
    private Long purchasecontractMaterialId; // 合同子表id
    private String purchasecontractMaterialName; // 合同子表原材料名称
    private Integer isSign; // 是否签认 0-已签认 1-未签认
    private Long signId; // 签认单id
    private Integer reconciliationType; // 调整类型 0-调正 1-调负
    private String reason; // 原因


    @ReferSerialTransfer(referCode="SupplierinfoRef")
    public Long getSupplierinfoId() {
        return supplierinfoId;
    }

    @ReferDeserialTransfer
    public void setSupplierinfoId(Long supplierinfoId) {
        this.supplierinfoId = supplierinfoId;
    }
    public String getSupplierinfoName() {
        return supplierinfoName;
    }

    public void setSupplierinfoName(String supplierinfoName) {
        this.supplierinfoName = supplierinfoName;
    }
    public BigDecimal getAcceptanceQuantity() {
        return acceptanceQuantity;
    }

    public void setAcceptanceQuantity(BigDecimal acceptanceQuantity) {
        this.acceptanceQuantity = acceptanceQuantity;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }
    public BigDecimal getTaxrate() {
        return taxrate;
    }

    public void setTaxrate(BigDecimal taxrate) {
        this.taxrate = taxrate;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public Date getAcceptanceDate() {
        return acceptanceDate;
    }

    public void setAcceptanceDate(Date acceptanceDate) {
        this.acceptanceDate = acceptanceDate;
    }
    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    public BigDecimal getAmountPaid() {
        return amountPaid;
    }

    public void setAmountPaid(BigDecimal amountPaid) {
        this.amountPaid = amountPaid;
    }
    public BigDecimal getAmountNotPaid() {
        return amountNotPaid;
    }

    public void setAmountNotPaid(BigDecimal amountNotPaid) {
        this.amountNotPaid = amountNotPaid;
    }
    public BigDecimal getInvoiceReceived() {
        return invoiceReceived;
    }

    public void setInvoiceReceived(BigDecimal invoiceReceived) {
        this.invoiceReceived = invoiceReceived;
    }
    public BigDecimal getInvoiceNotReceived() {
        return invoiceNotReceived;
    }

    public void setInvoiceNotReceived(BigDecimal invoiceNotReceived) {
        this.invoiceNotReceived = invoiceNotReceived;
    }

    @ReferSerialTransfer(referCode="PurchaseContractRef")
    public Long getPurchasecontractId() {
        return purchasecontractId;
    }

    @ReferDeserialTransfer
    public void setPurchasecontractId(Long purchasecontractId) {
        this.purchasecontractId = purchasecontractId;
    }
    public String getPurchasecontractBillCode() {
        return purchasecontractBillCode;
    }

    public void setPurchasecontractBillCode(String purchasecontractBillCode) {
        this.purchasecontractBillCode = purchasecontractBillCode;
    }
    public String getPurchasecontractName() {
        return purchasecontractName;
    }

    public void setPurchasecontractName(String purchasecontractName) {
        this.purchasecontractName = purchasecontractName;
    }
    @ReferSerialTransfer(referCode="PurchasecontractdetailRef")
    public Long getPurchasecontractMaterialId() {
        return purchasecontractMaterialId;
    }
    @ReferDeserialTransfer
    public void setPurchasecontractMaterialId(Long purchasecontractMaterialId) {
        this.purchasecontractMaterialId = purchasecontractMaterialId;
    }
    public String getPurchasecontractMaterialName() {
        return purchasecontractMaterialName;
    }

    public void setPurchasecontractMaterialName(String purchasecontractMaterialName) {
        this.purchasecontractMaterialName = purchasecontractMaterialName;
    }
    public Integer getIsSign() {
        return isSign;
    }

    public void setIsSign(Integer isSign) {
        this.isSign = isSign;
    }
    public Long getSignId() {
        return signId;
    }

    public void setSignId(Long signId) {
        this.signId = signId;
    }
    public Integer getReconciliationType() {
        return reconciliationType;
    }

    public void setReconciliationType(Integer reconciliationType) {
        this.reconciliationType = reconciliationType;
    }
    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }
    
}
