package com.ejianc.business.purchasingmanagement.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 运输商发票管理
 * 
 * @author generator
 * 
 */
public class ShippersinvoiceVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long shippersId; // 运输商基本档案主键
    private String shippersName; // 运输商基本档案名称
    private BigDecimal invoiceMoney; // 发票金额
    private BigDecimal balanceMoney; // 发票余额金额
    private Long receivablesType; // 收款类型id
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date checkoutTime; // 结账年月日
    private Integer invoicesStatus; // 发票状态
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private String abstracts; // 摘要
    private BigDecimal prepaymentAmount; // 预付款金额
    private Integer prepayment; // 0 正常付款 1预付款
    private BigDecimal distributionMoneySum; // 分配金额合计
    private String moneyCapital; //金额大写
    private List<ShippersinvoicedetialVO> shippersinvoicedetialList = new ArrayList<>(); // 运输商发票明细
    private List<ShippersinvoiceInfoVO> shippersinvoiceInfoList = new ArrayList<>(); // 运输商开票信息

    public BigDecimal getPrepaymentAmount() {
        return prepaymentAmount;
    }

    public void setPrepaymentAmount(BigDecimal prepaymentAmount) {
        this.prepaymentAmount = prepaymentAmount;
    }

    public Integer getPrepayment() {
        return prepayment;
    }

    public void setPrepayment(Integer prepayment) {
        this.prepayment = prepayment;
    }

    public BigDecimal getDistributionMoneySum() {
        return distributionMoneySum;
    }

    public void setDistributionMoneySum(BigDecimal distributionMoneySum) {
        this.distributionMoneySum = distributionMoneySum;
    }

    public List<ShippersinvoiceInfoVO> getShippersinvoiceInfoList() {
        return shippersinvoiceInfoList;
    }

    public void setShippersinvoiceInfoList(List<ShippersinvoiceInfoVO> shippersinvoiceInfoList) {
        this.shippersinvoiceInfoList = shippersinvoiceInfoList;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="ShippersRef")
    public Long getShippersId() {
        return shippersId;
    }
    @ReferDeserialTransfer
    public void setShippersId(Long shippersId) {
        this.shippersId = shippersId;
    }
    public String getShippersName() {
        return shippersName;
    }

    public void setShippersName(String shippersName) {
        this.shippersName = shippersName;
    }
    public BigDecimal getInvoiceMoney() {
        return invoiceMoney;
    }

    public void setInvoiceMoney(BigDecimal invoiceMoney) {
        this.invoiceMoney = invoiceMoney;
    }
    public BigDecimal getBalanceMoney() {
        return balanceMoney;
    }

    public void setBalanceMoney(BigDecimal balanceMoney) {
        this.balanceMoney = balanceMoney;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getReceivablesType() {
        return receivablesType;
    }
    @ReferDeserialTransfer
    public void setReceivablesType(Long receivablesType) {
        this.receivablesType = receivablesType;
    }
    public Date getCheckoutTime() {
        return checkoutTime;
    }

    public void setCheckoutTime(Date checkoutTime) {
        this.checkoutTime = checkoutTime;
    }
    public Integer getInvoicesStatus() {
        return invoicesStatus;
    }

    public void setInvoicesStatus(Integer invoicesStatus) {
        this.invoicesStatus = invoicesStatus;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getAbstracts() {
        return abstracts;
    }

    public void setAbstracts(String abstracts) {
        this.abstracts = abstracts;
    }
    
     public List<ShippersinvoicedetialVO> getShippersinvoicedetialList() {
        return shippersinvoicedetialList;
     }

     public void setShippersinvoicedetialList(List<ShippersinvoicedetialVO> shippersinvoicedetialList) {
        this.shippersinvoicedetialList = shippersinvoicedetialList;
     }

    public String getMoneyCapital() {
        return moneyCapital;
    }

    public void setMoneyCapital(String moneyCapital) {
        this.moneyCapital = moneyCapital;
    }
}
