package com.ejianc.business.purchasingmanagement.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 运输商付款单
 * 
 * @author generator
 * 
 */
public class TransporterpaymentVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long shippersId; // 运输商基本档案主键
    private String shippersName; // 运输商基本档案名称
    private Integer refund; // 是否退款
    private Long shippersBankId; // 运输商银行账户ID
    private String shippersBankName; // 运输商银行账户
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date paymentDate; // 日期
    private Long paymentType; // 付款类型
    private BigDecimal paymentAmount; // 付款额
    private String summary; // 摘要
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private String billCode; // 单据编号
    private  String receiptNumber;//收据号
    private String bankCode;//银行账号
    private String paymentTypeName; // 付款类型
    private  BigDecimal notDistributionMoney ;//未分配金额
    private BigDecimal prepaymentAmount; // 预付款金额
    private Integer prepayment; // 0 正常付款 1预付款
    private BigDecimal distributionMoneySum; // 分配金额合计
    private String moneyCapital; //金额大写

    private List<TransporterpaymentdetailVO> transporterpaymentdetailList = new ArrayList<>(); // 运输商付款单明细表

    public BigDecimal getPrepaymentAmount() {
        return prepaymentAmount;
    }

    public void setPrepaymentAmount(BigDecimal prepaymentAmount) {
        this.prepaymentAmount = prepaymentAmount;
    }

    public Integer getPrepayment() {
        return prepayment;
    }

    public void setPrepayment(Integer prepayment) {
        this.prepayment = prepayment;
    }

    public BigDecimal getDistributionMoneySum() {
        return distributionMoneySum;
    }

    public void setDistributionMoneySum(BigDecimal distributionMoneySum) {
        this.distributionMoneySum = distributionMoneySum;
    }

    public BigDecimal getNotDistributionMoney() {
        return notDistributionMoney;
    }

    public void setNotDistributionMoney(BigDecimal notDistributionMoney) {
        this.notDistributionMoney = notDistributionMoney;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getPaymentType() {
        return paymentType;
    }
    @ReferDeserialTransfer
    public void setPaymentType(Long paymentType) {
        this.paymentType = paymentType;
    }

    public String getPaymentTypeName() {
        return paymentTypeName;
    }

    public void setPaymentTypeName(String paymentTypeName) {
        this.paymentTypeName = paymentTypeName;
    }

    public String getBankCode() {
        return bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public String getReceiptNumber() {
        return receiptNumber;
    }

    public void setReceiptNumber(String receiptNumber) {
        this.receiptNumber = receiptNumber;
    }

    @ReferSerialTransfer(referCode="ShippersRef")
    public Long getShippersId() {
        return shippersId;
    }
    @ReferDeserialTransfer
    public void setShippersId(Long shippersId) {
        this.shippersId = shippersId;
    }
    public String getShippersName() {
        return shippersName;
    }

    public void setShippersName(String shippersName) {
        this.shippersName = shippersName;
    }
    public Integer getRefund() {
        return refund;
    }

    public void setRefund(Integer refund) {
        this.refund = refund;
    }
    @ReferSerialTransfer(referCode="ShippersBankRef")
    public Long getShippersBankId() {
        return shippersBankId;
    }
    @ReferDeserialTransfer
    public void setShippersBankId(Long shippersBankId) {
        this.shippersBankId = shippersBankId;
    }
    public String getShippersBankName() {
        return shippersBankName;
    }

    public void setShippersBankName(String shippersBankName) {
        this.shippersBankName = shippersBankName;
    }
    public Date getPaymentDate() {
        return paymentDate;
    }

    public void setPaymentDate(Date paymentDate) {
        this.paymentDate = paymentDate;
    }

    public BigDecimal getPaymentAmount() {
        return paymentAmount;
    }

    public void setPaymentAmount(BigDecimal paymentAmount) {
        this.paymentAmount = paymentAmount;
    }
    public String getSummary() {
        return summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    
     public List<TransporterpaymentdetailVO> getTransporterpaymentdetailList() {
        return transporterpaymentdetailList;
     }

     public void setTransporterpaymentdetailList(List<TransporterpaymentdetailVO> transporterpaymentdetailList) {
        this.transporterpaymentdetailList = transporterpaymentdetailList;
     }

    public String getMoneyCapital() {
        return moneyCapital;
    }

    public void setMoneyCapital(String moneyCapital) {
        this.moneyCapital = moneyCapital;
    }
}
