package com.ejianc.business.purchasingmanagement.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.purchasingmanagement.bean.ShippersinvoicedetialEntity;
/**
 * 运输商发票管理
 * 
 * @author generator
 * 
 */
 @TableName("ejc_purchasingmanagement_shippersinvoice")
public class ShippersinvoiceEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="shippers_id")
    private Long shippersId; // 运输商基本档案主键
    @TableField(value="shippers_name")
    private String shippersName; // 运输商基本档案名称
    @TableField(value="invoice_money")
    private BigDecimal invoiceMoney; // 发票金额
    @TableField(value="balance_money")
    private BigDecimal balanceMoney; // 发票余额金额
    @TableField(value="receivables_type")
    private Long receivablesType; // 收款类型id
    @TableField(value="checkout_time")
    private Date checkoutTime; // 结账年月日
    @TableField(value="invoices_status")
    private Integer invoicesStatus; // 发票状态
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="abstracts")
    private String abstracts; // 摘要
    @TableField(value="prepayment_amount")
    private BigDecimal prepaymentAmount; // 预付款金额
    @TableField(value="distribution_money_sum")
    private BigDecimal distributionMoneySum; // 分配金额合计
    @TableField(value="prepayment")
    private Integer prepayment; // 0 正常付款 1预付款
    @TableField(value="money_capital")
    private String moneyCapital; //金额大写
    
    @TableField(exist=false)
    @SubEntity(serviceName="shippersinvoicedetialService",pidName = "shippersinvoiceId")//此处有pid="xxx"，默认值pid="pid"
    private List<ShippersinvoicedetialEntity> shippersinvoicedetialList = new ArrayList<>(); // 运输商发票明细

    @TableField(exist=false)
    @SubEntity(serviceName="shippersinvoiceInfoService",pidName = "shippersinvoiceId")//此处有pid="xxx"，默认值pid="pid"
    private List<ShippersinvoiceInfoEntity> shippersinvoiceInfoList = new ArrayList<>(); // 运输商开票信息

    public BigDecimal getPrepaymentAmount() {
        return prepaymentAmount;
    }

    public void setPrepaymentAmount(BigDecimal prepaymentAmount) {
        this.prepaymentAmount = prepaymentAmount;
    }

    public BigDecimal getDistributionMoneySum() {
        return distributionMoneySum;
    }

    public void setDistributionMoneySum(BigDecimal distributionMoneySum) {
        this.distributionMoneySum = distributionMoneySum;
    }

    public Integer getPrepayment() {
        return prepayment;
    }

    public void setPrepayment(Integer prepayment) {
        this.prepayment = prepayment;
    }

    public List<ShippersinvoiceInfoEntity> getShippersinvoiceInfoList() {
        return shippersinvoiceInfoList;
    }

    public void setShippersinvoiceInfoList(List<ShippersinvoiceInfoEntity> shippersinvoiceInfoList) {
        this.shippersinvoiceInfoList = shippersinvoiceInfoList;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getShippersId() {
        return shippersId;
    }

    public void setShippersId(Long shippersId) {
        this.shippersId = shippersId;
    }
    public String getShippersName() {
        return shippersName;
    }

    public void setShippersName(String shippersName) {
        this.shippersName = shippersName;
    }
    public BigDecimal getInvoiceMoney() {
        return invoiceMoney;
    }

    public void setInvoiceMoney(BigDecimal invoiceMoney) {
        this.invoiceMoney = invoiceMoney;
    }
    public BigDecimal getBalanceMoney() {
        return balanceMoney;
    }

    public void setBalanceMoney(BigDecimal balanceMoney) {
        this.balanceMoney = balanceMoney;
    }
    public Long getReceivablesType() {
        return receivablesType;
    }

    public void setReceivablesType(Long receivablesType) {
        this.receivablesType = receivablesType;
    }
    public Date getCheckoutTime() {
        return checkoutTime;
    }

    public void setCheckoutTime(Date checkoutTime) {
        this.checkoutTime = checkoutTime;
    }
    public Integer getInvoicesStatus() {
        return invoicesStatus;
    }

    public void setInvoicesStatus(Integer invoicesStatus) {
        this.invoicesStatus = invoicesStatus;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getAbstracts() {
        return abstracts;
    }

    public void setAbstracts(String abstracts) {
        this.abstracts = abstracts;
    }
    
    public List<ShippersinvoicedetialEntity> getShippersinvoicedetialList() {
        return shippersinvoicedetialList;
    }

    public void setShippersinvoicedetialList(List<ShippersinvoicedetialEntity> shippersinvoicedetialList) {
        this.shippersinvoicedetialList = shippersinvoicedetialList;
    }

    public String getMoneyCapital() {
        return moneyCapital;
    }

    public void setMoneyCapital(String moneyCapital) {
        this.moneyCapital = moneyCapital;
    }
}
