package com.ejianc.business.purchasingmanagement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.purchasingmanagement.bean.MaterialacceptanceEntity;
import com.ejianc.business.purchasingmanagement.bean.PurchaseContractEntity;
import com.ejianc.business.purchasingmanagement.bean.TransportationacceptanceEntity;
import com.ejianc.business.purchasingmanagement.service.IMaterialacceptanceService;
import com.ejianc.business.purchasingmanagement.service.IPurchaseContractService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

@Service("materialacceptance") 
public class MaterialacceptanceBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IMaterialacceptanceService service;

	@Autowired
	private IPurchaseContractService purchaseContractService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("---------进来啦--------");

		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		String str = new java.text.SimpleDateFormat("yyyy-mm-").format(new java.util.Date())+"20";

		MaterialacceptanceEntity entity  = service.selectById(billId);
		entity.setBillState(state);
		if(3 ==state){
			entity.setConfirmStatus(1);
		}else if(4==state){
			entity.setConfirmStatus(0);
		}

		entity.setAmountPaid(new BigDecimal(0.00));
		entity.setInvoiceReceived(new BigDecimal(0.00));
		entity.setAmountNotPaid(entity.getTotalAmount());
		entity.setInvoiceNotReceived(entity.getTotalAmount());
		service.updateById(entity);

		if(3 ==state){

			QueryWrapper<MaterialacceptanceEntity> materialacceptanceEntityQueryWrapper =new QueryWrapper();
			materialacceptanceEntityQueryWrapper.eq("purchasecontract_id",entity.getPurchasecontractId());
			materialacceptanceEntityQueryWrapper.eq("dr",0);
			materialacceptanceEntityQueryWrapper.eq("confirm_status",1);
			PurchaseContractEntity purchaseContractEntity  = purchaseContractService.selectById(entity.getPurchasecontractId());
			List<MaterialacceptanceEntity> materialacceptanceEntities = service.list(materialacceptanceEntityQueryWrapper);
			BigDecimal amount = new BigDecimal(0.00);
			BigDecimal quantity = new BigDecimal(0.00);
			for (MaterialacceptanceEntity temp  :materialacceptanceEntities ) {
				amount = amount.add(temp.getTotalAmount());
				quantity = quantity.add(temp.getAcceptanceQuantity());
			}
			purchaseContractEntity.setReceiptQuantity(quantity);
			purchaseContractEntity.setReceiptAmount(amount);
			purchaseContractService.updateById(purchaseContractEntity);
		}


		logger.info("---------结束了--------");
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
