/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.purchasingmanagement.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.purchasingmanagement.bean.MaterialplanEntity;
import com.ejianc.business.purchasingmanagement.bean.PurchaseContractEntity;
import com.ejianc.business.purchasingmanagement.service.IMaterialplanService;
import com.ejianc.business.purchasingmanagement.service.IPurchaseContractService;
import com.ejianc.business.purchasingmanagement.vo.MaterialplanVO;
import com.ejianc.business.purchasingmanagement.vo.PurchaseContractVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"purchaseContract"})
public class PurchaseContractController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IPurchaseContractService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IMaterialplanService materialplanService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PurchaseContractVO> saveOrUpdate(@RequestBody PurchaseContractVO saveOrUpdateVO) {
        SimpleDateFormat ed = new SimpleDateFormat("yyyy-MM-dd");
        String endTime = ed.format(saveOrUpdateVO.getEndDate()) + " 23:59:59";
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date parse = null;
        try {
            parse = sf.parse(endTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        saveOrUpdateVO.setEndDate(parse);
        PurchaseContractEntity entity = (PurchaseContractEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), PurchaseContractEntity.class));
        entity.setTransporterId(entity.getPurchasecontractdetailList().get(0).getShippersId());
        entity.setTransporterName(entity.getPurchasecontractdetailList().get(0).getShippersName());
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"bill_code", (Object)entity.getBillCode());
        query.eq((Object)"dr", (Object)0);
        List list = this.service.list((Wrapper)query);
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                PurchaseContractEntity Entity = (PurchaseContractEntity)((Object)list.get(i));
                if (String.valueOf(Entity.getId()).equals(String.valueOf(entity.getId()))) continue;
                throw new BusinessException("\u5355\u636e\u7f16\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u5355\u636e\u7f16\u53f7\u540e\u4fdd\u5b58");
            }
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setIsTerminate(1);
        }
        this.service.saveOrUpdate((Object)entity, false);
        PurchaseContractVO vo = (PurchaseContractVO)((Object)BeanMapper.map((Object)((Object)entity), PurchaseContractVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PurchaseContractVO> queryDetail(Long id) {
        PurchaseContractEntity entity = (PurchaseContractEntity)((Object)this.service.selectById(id));
        PurchaseContractVO vo = (PurchaseContractVO)((Object)BeanMapper.map((Object)((Object)entity), PurchaseContractVO.class));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"purchasecontract_id", (Object)id);
        queryWrapper.eq((Object)"dr", (Object)0);
        List materialplanEntities = this.materialplanService.list((Wrapper)queryWrapper);
        ArrayList<MaterialplanVO> materialplanList = new ArrayList<MaterialplanVO>();
        for (MaterialplanEntity temp : materialplanEntities) {
            MaterialplanVO materialplanVO = (MaterialplanVO)((Object)BeanMapper.map((Object)((Object)temp), MaterialplanVO.class));
            materialplanVO.setMaterialplanBillCode(materialplanVO.getBillCode());
            materialplanList.add(materialplanVO);
        }
        vo.setMaterialplanList(materialplanList);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchaseContractVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PurchaseContractVO purchaseContractVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PurchaseContractVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("supplierinfoName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PurchaseContractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("start_date");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List vo = BeanMapper.mapList((Iterable)list, PurchaseContractVO.class);
        for (PurchaseContractVO purchaseContractVO : vo) {
            if (purchaseContractVO.getStage() == 1) {
                purchaseContractVO.setStages("\u5df2\u8fc7\u671f");
            } else {
                purchaseContractVO.setStages("\u672a\u8fc7\u671f");
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            purchaseContractVO.setStartDates(sdf.format(purchaseContractVO.getStartDate()));
            purchaseContractVO.setEndDates(sdf.format(purchaseContractVO.getEndDate()));
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", vo);
        ExcelExport.getInstance().export("PurchaseContract-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPurchaseContractData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PurchaseContractVO>> refPurchaseContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("supplierinfoName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            String orgId = _con.getString("orgId");
            String supplierId = _con.getString("supplierId");
            if (orgId != null) {
                param.getParams().put("org_id", new Parameter("eq", (Object)orgId));
                param.getParams().put("stage", new Parameter("eq", (Object)0));
            }
            if (supplierId != null) {
                param.getParams().put("supplierinfo_id", new Parameter("eq", (Object)supplierId));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PurchaseContractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refContractData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PurchaseContractVO>> refContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("transporterName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            String orgId = _con.getString("orgId");
            String transporterId = _con.getString("transporterId");
            if (orgId != null) {
                param.getParams().put("org_id", new Parameter("eq", (Object)orgId));
                param.getParams().put("stage", new Parameter("eq", (Object)0));
                param.getParams().put("is_terminate", new Parameter("eq", (Object)1));
            }
            if (transporterId != null) {
                param.getParams().put("transporter_id", new Parameter("eq", (Object)transporterId));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PurchaseContractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @Transactional
    @RequestMapping(value={"/updateIsTerminate"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PurchaseContractVO> updateIsTerminate(Long id) {
        PurchaseContractEntity entity = (PurchaseContractEntity)((Object)this.service.selectById(id));
        entity.setIsTerminate(0);
        this.service.updateById((Object)entity);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"purchasecontract_id", (Object)id);
        List list = this.materialplanService.list((Wrapper)queryWrapper);
        for (MaterialplanEntity entity1 : list) {
            entity1.setIsColse(0);
            this.materialplanService.updateById((Object)entity1);
        }
        PurchaseContractVO vo = (PurchaseContractVO)((Object)BeanMapper.map((Object)((Object)entity), PurchaseContractVO.class));
        return CommonResponse.success((String)"\u5173\u95ed\u6210\u529f", (Object)((Object)vo));
    }

    @RequestMapping(value={"/contractTime"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> contractTime() {
        this.service.contractTime();
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/updateStage"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PurchaseContractVO> updateStage(@RequestBody PurchaseContractVO saveOrUpdateVO) {
        PurchaseContractEntity entity = (PurchaseContractEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), PurchaseContractEntity.class));
        entity.setStage(0);
        this.service.updateById((Object)entity);
        PurchaseContractVO vo = (PurchaseContractVO)((Object)BeanMapper.map((Object)((Object)entity), PurchaseContractVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }
}

