/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.purchasingmanagement.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.purchasingmanagement.bean.MaterialplanEntity;
import com.ejianc.business.purchasingmanagement.bean.PurchasecontractdetailEntity;
import com.ejianc.business.purchasingmanagement.bean.PurchasetransportationEntity;
import com.ejianc.business.purchasingmanagement.mapper.MaterialplanMapper;
import com.ejianc.business.purchasingmanagement.service.IMaterialplanService;
import com.ejianc.business.purchasingmanagement.service.IPurchasecontractdetailService;
import com.ejianc.business.purchasingmanagement.service.IPurchasetransportationService;
import com.ejianc.business.purchasingmanagement.vo.MaterialplanVO;
import com.ejianc.business.purchasingmanagement.vo.PurchasetransportationVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="materialplanService")
public class MaterialplanServiceImpl
extends BaseServiceImpl<MaterialplanMapper, MaterialplanEntity>
implements IMaterialplanService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IMaterialplanService service;
    @Autowired
    private IPurchasetransportationService purchasetransportationService;
    @Autowired
    private IPurchasecontractdetailService purchasecontractdetailService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CommonResponse<MaterialplanVO> saveChange(MaterialplanVO saveChangeVO) {
        SimpleDateFormat ed = new SimpleDateFormat("yyyy-MM-dd");
        String endTime = ed.format(saveChangeVO.getEndDate()) + " 23:59:59";
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date parse = null;
        try {
            parse = sf.parse(endTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        saveChangeVO.setEndDate(parse);
        MaterialplanEntity entity = (MaterialplanEntity)((Object)BeanMapper.map((Object)((Object)saveChangeVO), MaterialplanEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveChangeVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setIsColse(1);
            entity.setBillCode((String)billCode.getData());
        }
        PurchasecontractdetailEntity purchasecontractdetailEntity = (PurchasecontractdetailEntity)((Object)this.purchasecontractdetailService.selectById(entity.getPurchasecontractdetailId()));
        entity.setPrice(purchasecontractdetailEntity.getPrice());
        entity.setMaterialTax(purchasecontractdetailEntity.getMaterialTax());
        entity.setFreightRate(purchasecontractdetailEntity.getFreightRate());
        this.service.saveOrUpdate((Object)entity, false);
        MaterialplanVO vo = (MaterialplanVO)((Object)BeanMapper.map((Object)((Object)entity), MaterialplanVO.class));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"materialplan_id", (Object)vo.getId());
        queryWrapper.eq((Object)"dr", (Object)"0");
        PurchasetransportationEntity page = (PurchasetransportationEntity)((Object)this.purchasetransportationService.getOne((Wrapper)queryWrapper));
        if (page == null) {
            PurchasetransportationVO purchasetransportationVO = new PurchasetransportationVO();
            purchasetransportationVO.setMaterialplanId(vo.getId());
            purchasetransportationVO.setSupplierinfoId(vo.getSupplierinfoId());
            purchasetransportationVO.setSupplierinfoName(vo.getSupplierinfoName());
            purchasetransportationVO.setMaterialId(vo.getMaterialId());
            purchasetransportationVO.setMaterialName(vo.getMaterialName());
            purchasetransportationVO.setRequiredQuantity(vo.getQuantity());
            purchasetransportationVO.setReceivingaddressId(vo.getMddId());
            purchasetransportationVO.setReceivingAddress(vo.getMddName());
            purchasetransportationVO.setOrgId(vo.getOrgId());
            purchasetransportationVO.setOrgName(vo.getOrgName());
            purchasetransportationVO.setShippersId(purchasecontractdetailEntity.getShippersId());
            purchasetransportationVO.setShippersName(purchasecontractdetailEntity.getShippersName());
            purchasetransportationVO.setUnitPrice(purchasecontractdetailEntity.getSjyfPrice());
            purchasetransportationVO.setDistance(purchasecontractdetailEntity.getDistance());
            purchasetransportationVO.setStartingTime(vo.getStarDate());
            purchasetransportationVO.setEndTime(parse);
            purchasetransportationVO.setIsColse(1);
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)purchasetransportationVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            PurchasetransportationEntity entity1 = (PurchasetransportationEntity)((Object)BeanMapper.map((Object)((Object)purchasetransportationVO), PurchasetransportationEntity.class));
            entity1.setBillCode((String)billCode.getData());
            this.purchasetransportationService.saveOrUpdate((Object)entity1, false);
            return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
        } else {
            page.setRequiredQuantity(vo.getQuantity());
            page.setReceivingaddressId(vo.getMddId());
            page.setReceivingAddress(vo.getMddName());
            page.setStartingTime(vo.getStarDate());
            page.setEndTime(vo.getEndDate());
            page.setMaterialId(vo.getMaterialId());
            page.setMaterialName(vo.getMaterialName());
            page.setSupplierinfoId(vo.getSupplierinfoId());
            page.setSupplierinfoName(vo.getSupplierinfoName());
            this.purchasetransportationService.updateById((Object)page);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @Override
    public CommonResponse<String> orderingSchedulesTime() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.le((Object)"end_date", (Object)date);
        queryWrapper.eq((Object)"is_colse", (Object)1);
        List materialplanEntities = this.service.list((Wrapper)queryWrapper);
        for (MaterialplanEntity temp : materialplanEntities) {
            temp.setIsColse(0);
            this.service.updateById((Object)temp);
            QueryWrapper purchasetransportationEntityQueryWrapper = new QueryWrapper();
            purchasetransportationEntityQueryWrapper.eq((Object)"materialplan_id", (Object)temp.getId());
            PurchasetransportationEntity purchasetransportationEntitie = (PurchasetransportationEntity)((Object)this.purchasetransportationService.getOne((Wrapper)purchasetransportationEntityQueryWrapper));
            purchasetransportationEntitie.setIsColse(0);
            this.purchasetransportationService.updateById((Object)purchasetransportationEntitie);
        }
        return CommonResponse.success((String)"\u8ba2\u6599\u8ba1\u5212\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5b8c\u6210\uff01");
    }
}

