/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.purchasingmanagement.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bases.api.BaseApi;
import com.ejianc.business.purchasingmanagement.bean.MaterialacceptanceEntity;
import com.ejianc.business.purchasingmanagement.bean.MaterialacceptanceSummaryEntity;
import com.ejianc.business.purchasingmanagement.bean.MaterialacceptancedetailEntity;
import com.ejianc.business.purchasingmanagement.bean.MaterialplanEntity;
import com.ejianc.business.purchasingmanagement.bean.PurchaseContractEntity;
import com.ejianc.business.purchasingmanagement.bean.PurchasecontractdetailEntity;
import com.ejianc.business.purchasingmanagement.bean.PurchasedetilEntity;
import com.ejianc.business.purchasingmanagement.bean.PurchasereceiptEntity;
import com.ejianc.business.purchasingmanagement.bean.PurchasetransportationEntity;
import com.ejianc.business.purchasingmanagement.bean.TransportationSummaryEntity;
import com.ejianc.business.purchasingmanagement.bean.TransportationacceptanceEntity;
import com.ejianc.business.purchasingmanagement.bean.TransportationdetailEntity;
import com.ejianc.business.purchasingmanagement.mapper.PurchasereceiptMapper;
import com.ejianc.business.purchasingmanagement.service.IMaterialacceptanceService;
import com.ejianc.business.purchasingmanagement.service.IMaterialacceptanceSummaryService;
import com.ejianc.business.purchasingmanagement.service.IMaterialacceptancedetailService;
import com.ejianc.business.purchasingmanagement.service.IMaterialplanService;
import com.ejianc.business.purchasingmanagement.service.IPurchaseContractService;
import com.ejianc.business.purchasingmanagement.service.IPurchasecontractdetailService;
import com.ejianc.business.purchasingmanagement.service.IPurchasedetilService;
import com.ejianc.business.purchasingmanagement.service.IPurchasereceiptService;
import com.ejianc.business.purchasingmanagement.service.IPurchasetransportationService;
import com.ejianc.business.purchasingmanagement.service.ITransportationSummaryService;
import com.ejianc.business.purchasingmanagement.service.ITransportationacceptanceService;
import com.ejianc.business.purchasingmanagement.service.ITransportationdetailService;
import com.ejianc.business.purchasingmanagement.vo.MaterialacceptanceSummaryVO;
import com.ejianc.business.purchasingmanagement.vo.MaterialacceptanceVO;
import com.ejianc.business.purchasingmanagement.vo.MaterialacceptancedetailVO;
import com.ejianc.business.purchasingmanagement.vo.PurchasereceiptVO;
import com.ejianc.business.purchasingmanagement.vo.TransportationSummaryVO;
import com.ejianc.business.purchasingmanagement.vo.TransportationacceptanceVO;
import com.ejianc.business.purchasingmanagement.vo.TransportationdetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="purchasereceiptService")
public class PurchasereceiptServiceImpl
extends BaseServiceImpl<PurchasereceiptMapper, PurchasereceiptEntity>
implements IPurchasereceiptService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IMaterialplanService materialplanService;
    @Autowired
    private IPurchasereceiptService service;
    @Autowired
    private IPurchasedetilService purchasedetilService;
    @Autowired
    private IPurchasetransportationService purchasetransportationService;
    @Autowired
    private IMaterialacceptanceService materialacceptanceService;
    @Autowired
    private IMaterialacceptancedetailService materialacceptancedetailService;
    @Autowired
    private IPurchasecontractdetailService purchasecontractdetailService;
    @Autowired
    private ITransportationacceptanceService transportationacceptanceService;
    @Autowired
    private ITransportationdetailService transportationdetailService;
    @Autowired
    private IPurchaseContractService purchaseContractService;
    @Qualifier(value="com.ejianc.business.base.bases.api.BaseApi")
    @Autowired
    private BaseApi baseApi;
    @Autowired
    private ITransportationSummaryService transportationSummaryService;
    @Autowired
    private IMaterialacceptanceSummaryService materialacceptanceSummaryService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<PurchasereceiptVO> saveChange(PurchasereceiptVO saveChangeVO) {
        saveChangeVO.setReceipt(1);
        saveChangeVO.setAudit(0);
        saveChangeVO.setUnloadedStatus(1);
        saveChangeVO.setPeelBackTime(new Date());
        saveChangeVO.setReceiptsTime(new Date());
        PurchasereceiptEntity entity = (PurchasereceiptEntity)((Object)BeanMapper.map((Object)((Object)saveChangeVO), PurchasereceiptEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveChangeVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
        } else {
            PurchasereceiptEntity entity1 = (PurchasereceiptEntity)((Object)this.service.getById(entity.getId()));
            if (!entity.getCgysId().equals(entity1.getCgysId())) {
                PurchasedetilEntity purchasedetilEntity = (PurchasedetilEntity)((Object)this.purchasedetilService.getById(entity1.getCgysId()));
                purchasedetilEntity.setStatus(0);
                purchasedetilEntity.setReceiptQuantity(new BigDecimal(0.0));
                purchasedetilEntity.setReceiptTime(null);
                this.purchasedetilService.updateById((Object)purchasedetilEntity);
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        PurchasereceiptVO vo = (PurchasereceiptVO)((Object)BeanMapper.map((Object)((Object)entity), PurchasereceiptVO.class));
        QueryWrapper queryWrapper1 = new QueryWrapper();
        QueryWrapper queryWrapper3 = new QueryWrapper();
        queryWrapper1.eq((Object)"id", (Object)entity.getCgysId());
        queryWrapper1.eq((Object)"dr", (Object)0);
        PurchasedetilEntity purchasedetilEntity = (PurchasedetilEntity)((Object)this.purchasedetilService.getOne((Wrapper)queryWrapper1));
        purchasedetilEntity.setStatus(1);
        purchasedetilEntity.setReceiptQuantity(entity.getNetWeight());
        purchasedetilEntity.setReceiptTime(saveChangeVO.getReceiptTime());
        this.purchasedetilService.updateById((Object)purchasedetilEntity);
        PurchasetransportationEntity purchasetransportationEntity = (PurchasetransportationEntity)((Object)this.purchasetransportationService.getById(purchasedetilEntity.getPurchasetransportationId()));
        queryWrapper3.eq((Object)"purchasetransportation_id", (Object)purchasedetilEntity.getPurchasetransportationId());
        List purchasedetilEntities = this.purchasedetilService.list((Wrapper)queryWrapper3);
        BigDecimal sum = new BigDecimal(0.0);
        for (PurchasedetilEntity temp : purchasedetilEntities) {
            if (temp.getReceiptQuantity() == null) continue;
            sum = sum.add(temp.getReceiptQuantity());
        }
        purchasetransportationEntity.setReceiptQuantity(sum);
        purchasetransportationEntity.setReceiptTime(entity.getReceiptTime());
        this.purchasetransportationService.updateById((Object)purchasetransportationEntity);
        QueryWrapper materialplanEntityQueryWrapper = new QueryWrapper();
        materialplanEntityQueryWrapper.eq((Object)"id", (Object)entity.getMaterialplanId());
        materialplanEntityQueryWrapper.eq((Object)"dr", (Object)0);
        MaterialplanEntity materialplanEntity = (MaterialplanEntity)((Object)this.materialplanService.getOne((Wrapper)materialplanEntityQueryWrapper));
        materialplanEntity.setQuantityReceived(sum);
        this.materialplanService.updateById((Object)materialplanEntity);
        PurchasecontractdetailEntity detailEntity = (PurchasecontractdetailEntity)((Object)this.purchasecontractdetailService.getById(materialplanEntity.getPurchasecontractdetailId()));
        QueryWrapper queryWrapper2 = new QueryWrapper();
        queryWrapper2.eq((Object)"purchasecontract_id", (Object)materialplanEntity.getPurchasecontractId());
        queryWrapper2.eq((Object)"purchasecontract_material_id", (Object)materialplanEntity.getPurchasecontractdetailId());
        queryWrapper2.eq((Object)"acceptance_date", (Object)new SimpleDateFormat("yyyy-MM-dd").format(saveChangeVO.getReceiptTime()));
        MaterialacceptanceEntity materialacceptanceEntity = (MaterialacceptanceEntity)((Object)this.materialacceptanceService.getOne((Wrapper)queryWrapper2));
        PurchaseContractEntity purchaseContractEntity = (PurchaseContractEntity)((Object)this.purchaseContractService.getById(materialplanEntity.getPurchasecontractId()));
        ArrayList<MaterialacceptanceSummaryVO> list = new ArrayList<MaterialacceptanceSummaryVO>();
        MaterialacceptanceSummaryVO summaryVO = new MaterialacceptanceSummaryVO();
        if (materialacceptanceEntity == null) {
            summaryVO.setReceiptDate(saveChangeVO.getReceiptTime());
            summaryVO.setMaterialId(detailEntity.getId());
            summaryVO.setMaterialName(detailEntity.getMaterialName());
            summaryVO.setPurchasereceiptId(saveChangeVO.getId());
            summaryVO.setNumberPlate(saveChangeVO.getNumberPlate());
            summaryVO.setQuantity(saveChangeVO.getNetWeight());
            summaryVO.setPrice(detailEntity.getPrice());
            summaryVO.setNoTaxPrice(detailEntity.getMoney());
            summaryVO.setMaterialTaxRate(detailEntity.getMaterialTax());
            BigDecimal money = summaryVO.getQuantity().multiply(summaryVO.getMaterialTaxRate().multiply(summaryVO.getPrice()));
            BigDecimal tax = new BigDecimal(1.0).add(summaryVO.getMaterialTaxRate());
            summaryVO.setMaterialTax(money.divide(tax, 2, 4));
            summaryVO.setTotal(summaryVO.getPrice().multiply(summaryVO.getQuantity()));
            summaryVO.setMoney(summaryVO.getTotal().subtract(summaryVO.getMaterialTax()));
            list.add(summaryVO);
            MaterialacceptanceVO materialacceptanceVO = new MaterialacceptanceVO();
            materialacceptanceVO.setSupplierinfoId(materialplanEntity.getSupplierinfoId());
            materialacceptanceVO.setSupplierinfoName(materialplanEntity.getSupplierinfoName());
            materialacceptanceVO.setAcceptanceQuantity(summaryVO.getQuantity());
            materialacceptanceVO.setMaterialplanId(materialplanEntity.getId());
            materialacceptanceVO.setMaterialplanName(materialplanEntity.getBillCode());
            materialacceptanceVO.setTax(summaryVO.getMaterialTax());
            materialacceptanceVO.setManufacturerId(detailEntity.getManufacturerId());
            materialacceptanceVO.setManufacturerName(detailEntity.getManufacturerName());
            materialacceptanceVO.setPurchasecontractId(materialplanEntity.getPurchasecontractId());
            materialacceptanceVO.setPurchasecontractBillCode(purchaseContractEntity.getBillCode());
            materialacceptanceVO.setPurchasecontractMaterialId(materialplanEntity.getPurchasecontractdetailId());
            materialacceptanceVO.setPurchasecontractMaterialName(detailEntity.getMaterialName());
            materialacceptanceVO.setAmount(summaryVO.getMoney());
            materialacceptanceVO.setTotalAmount(summaryVO.getTotal());
            materialacceptanceVO.setAcceptanceDate(saveChangeVO.getReceiptTime());
            materialacceptanceVO.setOrgId(purchaseContractEntity.getOrgId());
            materialacceptanceVO.setOrgName(purchaseContractEntity.getOrgName());
            materialacceptanceVO.setAcceptanceType(0);
            materialacceptanceVO.setAmountPaid(new BigDecimal(0.0));
            materialacceptanceVO.setMeetMoney(materialacceptanceVO.getTotalAmount());
            materialacceptanceVO.setAmountNotPaid(materialacceptanceVO.getMeetMoney().subtract(materialacceptanceVO.getAmountPaid()));
            materialacceptanceVO.setInvoiceReceived(new BigDecimal(0.0));
            materialacceptanceVO.setInvoiceNotReceived(materialacceptanceVO.getTotalAmount());
            materialacceptanceVO.setIsSign(1);
            materialacceptanceVO.setMaterialacceptanceSummaryList(list);
            MaterialacceptanceEntity materialacceptance = (MaterialacceptanceEntity)((Object)BeanMapper.map((Object)((Object)materialacceptanceVO), MaterialacceptanceEntity.class));
            if (materialacceptance.getId() == null || materialacceptance.getId() == 0L) {
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)materialacceptanceVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                materialacceptance.setBillCode((String)billCode.getData());
            }
            this.materialacceptanceService.saveOrUpdate((Object)materialacceptance, false);
        } else {
            MaterialacceptanceSummaryEntity summaryEntity;
            BigDecimal tax;
            BigDecimal money;
            QueryWrapper sumEntity = new QueryWrapper();
            sumEntity.eq((Object)"purchasereceipt_id", (Object)saveChangeVO.getId());
            MaterialacceptanceSummaryEntity materialacceptanceSummaryEntity = (MaterialacceptanceSummaryEntity)((Object)this.materialacceptanceSummaryService.getOne((Wrapper)sumEntity));
            if (materialacceptanceSummaryEntity == null) {
                summaryVO.setMaterialacceptanceId(materialacceptanceEntity.getId());
                summaryVO.setReceiptDate(saveChangeVO.getReceiptTime());
                summaryVO.setMaterialId(detailEntity.getId());
                summaryVO.setMaterialName(detailEntity.getMaterialName());
                summaryVO.setPurchasereceiptId(saveChangeVO.getId());
                summaryVO.setNumberPlate(saveChangeVO.getNumberPlate());
                summaryVO.setQuantity(saveChangeVO.getNetWeight());
                summaryVO.setPrice(detailEntity.getPrice());
                summaryVO.setNoTaxPrice(detailEntity.getMoney());
                summaryVO.setMaterialTaxRate(detailEntity.getMaterialTax());
                money = summaryVO.getQuantity().multiply(summaryVO.getMaterialTaxRate().multiply(summaryVO.getPrice()));
                tax = new BigDecimal(1.0).add(summaryVO.getMaterialTaxRate());
                summaryVO.setMaterialTax(money.divide(tax, 2, 4));
                summaryVO.setTotal(summaryVO.getPrice().multiply(summaryVO.getQuantity()));
                summaryVO.setMoney(summaryVO.getTotal().subtract(summaryVO.getMaterialTax()));
                summaryEntity = (MaterialacceptanceSummaryEntity)((Object)BeanMapper.map((Object)((Object)summaryVO), MaterialacceptanceSummaryEntity.class));
                this.materialacceptanceSummaryService.save((Object)summaryEntity);
            } else {
                summaryVO.setMaterialacceptanceId(materialacceptanceEntity.getId());
                summaryVO.setReceiptDate(saveChangeVO.getReceiptTime());
                summaryVO.setMaterialId(detailEntity.getId());
                summaryVO.setMaterialName(detailEntity.getMaterialName());
                summaryVO.setPurchasereceiptId(saveChangeVO.getId());
                summaryVO.setNumberPlate(saveChangeVO.getNumberPlate());
                summaryVO.setQuantity(saveChangeVO.getNetWeight());
                summaryVO.setPrice(detailEntity.getPrice());
                summaryVO.setNoTaxPrice(detailEntity.getMoney());
                summaryVO.setMaterialTaxRate(detailEntity.getMaterialTax());
                money = summaryVO.getQuantity().multiply(summaryVO.getMaterialTaxRate().multiply(summaryVO.getPrice()));
                tax = new BigDecimal(1.0).add(summaryVO.getMaterialTaxRate());
                summaryVO.setMaterialTax(money.divide(tax, 2, 4));
                summaryVO.setTotal(summaryVO.getPrice().multiply(summaryVO.getQuantity()));
                summaryVO.setMoney(summaryVO.getTotal().subtract(summaryVO.getMaterialTax()));
                summaryEntity = (MaterialacceptanceSummaryEntity)((Object)BeanMapper.map((Object)((Object)summaryVO), MaterialacceptanceSummaryEntity.class));
                this.materialacceptanceSummaryService.updateById((Object)summaryEntity);
            }
            QueryWrapper queryWrapper4 = new QueryWrapper();
            queryWrapper4.select(new String[]{"sum(quantity) as quantity,sum(money) as money,sum(material_tax) as tax,sum(total) as total"});
            queryWrapper4.eq((Object)"materialacceptance_id", (Object)materialacceptanceEntity.getId());
            Map map = this.materialacceptanceSummaryService.getMap((Wrapper)queryWrapper4);
            materialacceptanceEntity.setAcceptanceQuantity(new BigDecimal(Double.valueOf(String.valueOf(map.get("quantity")))));
            materialacceptanceEntity.setAmount(new BigDecimal(Double.valueOf(String.valueOf(map.get("money")))));
            materialacceptanceEntity.setTax(new BigDecimal(Double.valueOf(String.valueOf(map.get("tax")))));
            materialacceptanceEntity.setTotalAmount(new BigDecimal(Double.valueOf(String.valueOf(map.get("total")))));
            materialacceptanceEntity.setMeetMoney(materialacceptanceEntity.getTotalAmount());
            materialacceptanceEntity.setAmountNotPaid(materialacceptanceEntity.getMeetMoney().subtract(materialacceptanceEntity.getAmountPaid()));
            materialacceptanceEntity.setInvoiceNotReceived(materialacceptanceEntity.getTotalAmount());
            this.materialacceptanceService.updateById((Object)materialacceptanceEntity);
        }
        if (detailEntity.getFreight() != 1) return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
        QueryWrapper queryWrapper4 = new QueryWrapper();
        queryWrapper4.eq((Object)"shippers_id", (Object)detailEntity.getShippersId());
        queryWrapper4.eq((Object)"purchasecontractdetail_id", (Object)detailEntity.getId());
        queryWrapper4.eq((Object)"acceptance_date", (Object)new SimpleDateFormat("yyyy-MM-dd").format(saveChangeVO.getReceiptTime()));
        TransportationacceptanceEntity tranEntity = (TransportationacceptanceEntity)((Object)this.transportationacceptanceService.getOne((Wrapper)queryWrapper4));
        ArrayList<TransportationSummaryVO> tranList = new ArrayList<TransportationSummaryVO>();
        TransportationSummaryVO tranVO = new TransportationSummaryVO();
        if (tranEntity == null) {
            tranVO.setReceivedDate(saveChangeVO.getReceiptTime());
            tranVO.setNumberPlate(saveChangeVO.getNumberPlate());
            tranVO.setMaterialId(detailEntity.getId());
            tranVO.setMaterialName(detailEntity.getMaterialName());
            tranVO.setPrice(detailEntity.getSjyfPrice());
            tranVO.setQuantity(saveChangeVO.getNetWeight());
            tranVO.setFreightRate(detailEntity.getFreightRate());
            BigDecimal money = tranVO.getPrice().multiply(tranVO.getFreightRate()).multiply(tranVO.getQuantity());
            BigDecimal tax = new BigDecimal(1.0).add(tranVO.getFreightRate());
            tranVO.setFreightTax(money.divide(tax, 2, 4));
            tranVO.setTotal(tranVO.getPrice().multiply(tranVO.getQuantity()));
            tranVO.setAmount(tranVO.getTotal().subtract(tranVO.getFreightTax()));
            tranVO.setNotTaxMoney(tranVO.getPrice().divide(tax, 2, 4));
            tranList.add(tranVO);
            TransportationacceptanceVO transportationacceptanceVO = new TransportationacceptanceVO();
            transportationacceptanceVO.setShippersId(detailEntity.getShippersId());
            transportationacceptanceVO.setShippersName(detailEntity.getShippersName());
            transportationacceptanceVO.setQuantity(tranVO.getQuantity());
            transportationacceptanceVO.setMoney(tranVO.getAmount());
            transportationacceptanceVO.setTax(tranVO.getFreightTax());
            transportationacceptanceVO.setTotalAmount(tranVO.getTotal());
            transportationacceptanceVO.setPurchasecontractId(materialplanEntity.getPurchasecontractId());
            transportationacceptanceVO.setPurchasecontractBillCode(purchaseContractEntity.getBillCode());
            transportationacceptanceVO.setPurchasecontractdetailId(materialplanEntity.getPurchasecontractdetailId());
            transportationacceptanceVO.setPurchasecontractMaterialName(detailEntity.getMaterialName());
            transportationacceptanceVO.setAcceptanceDate(saveChangeVO.getReceiptTime());
            transportationacceptanceVO.setOrgId(purchaseContractEntity.getOrgId());
            transportationacceptanceVO.setOrgName(purchaseContractEntity.getOrgName());
            transportationacceptanceVO.setMeetMoney(transportationacceptanceVO.getTotalAmount());
            transportationacceptanceVO.setAmountPaid(new BigDecimal(0.0));
            transportationacceptanceVO.setAmountNotPaid(transportationacceptanceVO.getTotalAmount());
            transportationacceptanceVO.setInvoiceReceived(new BigDecimal(0.0));
            transportationacceptanceVO.setInvoiceNotReceived(transportationacceptanceVO.getTotalAmount());
            transportationacceptanceVO.setIsSign(1);
            transportationacceptanceVO.setAcceptanceType(0);
            transportationacceptanceVO.setTransportationSummaryList(tranList);
            TransportationacceptanceEntity transportationacceptanceEntity = (TransportationacceptanceEntity)((Object)BeanMapper.map((Object)((Object)transportationacceptanceVO), TransportationacceptanceEntity.class));
            if (transportationacceptanceEntity.getId() == null || transportationacceptanceEntity.getId() == 0L) {
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)transportationacceptanceVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                transportationacceptanceEntity.setBillCode((String)billCode.getData());
            }
            this.transportationacceptanceService.saveOrUpdate((Object)transportationacceptanceEntity, false);
            return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
        } else {
            BigDecimal tax;
            BigDecimal money;
            QueryWrapper queryWrapper6 = new QueryWrapper();
            queryWrapper6.eq((Object)"purchasereceipt_id", (Object)saveChangeVO.getId());
            TransportationSummaryEntity TransportationSummaryEntity2 = (TransportationSummaryEntity)((Object)this.transportationSummaryService.getOne((Wrapper)queryWrapper6));
            if (TransportationSummaryEntity2 == null) {
                tranVO.setTransportationacceptanceId(tranEntity.getId());
                tranVO.setReceivedDate(saveChangeVO.getReceiptTime());
                tranVO.setNumberPlate(saveChangeVO.getNumberPlate());
                tranVO.setMaterialId(detailEntity.getId());
                tranVO.setMaterialName(detailEntity.getMaterialName());
                tranVO.setPrice(detailEntity.getSjyfPrice());
                tranVO.setQuantity(saveChangeVO.getNetWeight());
                tranVO.setFreightRate(detailEntity.getFreightRate());
                money = tranVO.getPrice().multiply(tranVO.getFreightRate()).multiply(tranVO.getQuantity());
                tax = new BigDecimal(1.0).add(tranVO.getFreightRate());
                tranVO.setFreightTax(money.divide(tax, 2, 4));
                tranVO.setTotal(tranVO.getPrice().multiply(tranVO.getQuantity()));
                tranVO.setAmount(tranVO.getTotal().subtract(tranVO.getFreightTax()));
                tranVO.setNotTaxMoney(tranVO.getPrice().divide(tax, 2, 4));
                TransportationSummaryEntity transportationSummaryEntity = (TransportationSummaryEntity)((Object)BeanMapper.map((Object)((Object)tranVO), TransportationSummaryEntity.class));
                this.transportationSummaryService.save((Object)transportationSummaryEntity);
            } else {
                tranVO.setTransportationacceptanceId(tranEntity.getId());
                tranVO.setReceivedDate(saveChangeVO.getReceiptTime());
                tranVO.setNumberPlate(saveChangeVO.getNumberPlate());
                tranVO.setMaterialId(detailEntity.getId());
                tranVO.setMaterialName(detailEntity.getMaterialName());
                tranVO.setPrice(detailEntity.getSjyfPrice());
                tranVO.setQuantity(saveChangeVO.getNetWeight());
                tranVO.setFreightRate(detailEntity.getFreightRate());
                money = tranVO.getPrice().multiply(tranVO.getFreightRate()).multiply(tranVO.getQuantity());
                tax = new BigDecimal(1.0).add(tranVO.getFreightRate());
                tranVO.setFreightTax(money.divide(tax, 2, 4));
                tranVO.setTotal(tranVO.getPrice().multiply(tranVO.getQuantity()));
                tranVO.setAmount(tranVO.getTotal().subtract(tranVO.getFreightTax()));
                tranVO.setNotTaxMoney(tranVO.getPrice().divide(tax, 2, 4));
                TransportationSummaryEntity transportationSummaryEntity = (TransportationSummaryEntity)((Object)BeanMapper.map((Object)((Object)tranVO), TransportationSummaryEntity.class));
                this.transportationSummaryService.updateById((Object)transportationSummaryEntity);
            }
            QueryWrapper queryWrapper5 = new QueryWrapper();
            queryWrapper5.select(new String[]{"sum(quantity) as quantity,sum(amount) as amount,sum(freight_tax) as tax,sum(total) as total"});
            queryWrapper5.eq((Object)"transportationacceptance_id", (Object)tranEntity.getId());
            Map map = this.transportationSummaryService.getMap((Wrapper)queryWrapper5);
            tranEntity.setQuantity(new BigDecimal(Double.valueOf(String.valueOf(map.get("quantity")))));
            tranEntity.setMoney(new BigDecimal(Double.valueOf(String.valueOf(map.get("amount")))));
            tranEntity.setTax(new BigDecimal(Double.valueOf(String.valueOf(map.get("tax")))));
            tranEntity.setTotalAmount(new BigDecimal(Double.valueOf(String.valueOf(map.get("total")))));
            tranEntity.setMeetMoney(tranEntity.getTotalAmount());
            tranEntity.setAmountNotPaid(tranEntity.getTotalAmount());
            tranEntity.setInvoiceNotReceived(tranEntity.getTotalAmount());
            this.transportationacceptanceService.updateById((Object)tranEntity);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @Override
    public CommonResponse<String> deleteByID(List<PurchasereceiptVO> vos) {
        for (int i = 0; i < vos.size(); ++i) {
            PurchasereceiptEntity purchasereceiptEntity = (PurchasereceiptEntity)((Object)this.service.getById(vos.get(i).getId()));
            this.service.removeById(vos.get(i).getId(), true);
            PurchasedetilEntity entity = (PurchasedetilEntity)((Object)this.purchasedetilService.getById(purchasereceiptEntity.getCgysId()));
            entity.setStatus(0);
            entity.setReceiptQuantity(new BigDecimal(0.0));
            entity.setReceiptTime(null);
            this.purchasedetilService.updateById((Object)entity);
            PurchasetransportationEntity purchasetransportationEntity = (PurchasetransportationEntity)((Object)this.purchasetransportationService.getById(entity.getPurchasetransportationId()));
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"purchasetransportation_id", (Object)entity.getPurchasetransportationId());
            List purchasedetilEntities = this.purchasedetilService.list((Wrapper)queryWrapper);
            BigDecimal sum = new BigDecimal(0.0);
            for (PurchasedetilEntity temp : purchasedetilEntities) {
                if (temp.getReceiptQuantity() == null) continue;
                sum = sum.add(temp.getReceiptQuantity());
            }
            purchasetransportationEntity.setReceiptQuantity(sum);
            this.purchasetransportationService.updateById((Object)purchasetransportationEntity);
            QueryWrapper materialplanEntityQueryWrapper = new QueryWrapper();
            materialplanEntityQueryWrapper.eq((Object)"id", (Object)entity.getMaterialplanId());
            materialplanEntityQueryWrapper.eq((Object)"dr", (Object)0);
            MaterialplanEntity materialplanEntity = (MaterialplanEntity)((Object)this.materialplanService.getOne((Wrapper)materialplanEntityQueryWrapper));
            materialplanEntity.setQuantityReceived(sum);
            this.materialplanService.updateById((Object)materialplanEntity);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<PurchasereceiptVO> audit(List<PurchasereceiptVO> vos) throws ParseException {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        String str = sdf.format(cal.getTime());
        str = str + "-20";
        cal.add(2, 1);
        String preMonth = sdf.format(cal.getTime());
        preMonth = preMonth + "-20";
        for (int i = 0; i < vos.size(); ++i) {
            BaseVO saveOrUpdateVO;
            CommonResponse billCode;
            BillCodeParam billCodeParam;
            CommonResponse common = this.baseApi.settlement(sdf1.format(vos.get(i).getReceiptTime()), vos.get(i).getOrgId().toString());
            if (common.getCode() != 0) {
                throw new BusinessException("\u672a\u67e5\u5230\u7ed3\u7b97\u65e5\u671f!");
            }
            PurchasereceiptEntity entity = (PurchasereceiptEntity)((Object)this.service.selectById(vos.get(i).getId()));
            entity.setAudit(1);
            entity.setNetWeight(vos.get(i).getNetWeight());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"id", (Object)entity.getMaterialplanId());
            queryWrapper.eq((Object)"dr", (Object)0);
            MaterialplanEntity materialplanEntity = (MaterialplanEntity)((Object)this.materialplanService.getOne((Wrapper)queryWrapper));
            PurchasecontractdetailEntity purchasecontractdetailEntity = (PurchasecontractdetailEntity)((Object)this.purchasecontractdetailService.selectById(materialplanEntity.getPurchasecontractdetailId()));
            PurchaseContractEntity purchaseContractEntity = (PurchaseContractEntity)((Object)this.purchaseContractService.selectById(purchasecontractdetailEntity.getPurchasecontractId()));
            if (purchasecontractdetailEntity != null && purchasecontractdetailEntity.getFreight() == 1) {
                QueryWrapper transportationacceptanceQueryWrapper = new QueryWrapper();
                transportationacceptanceQueryWrapper.eq((Object)"shippers_id", (Object)purchasecontractdetailEntity.getShippersId());
                transportationacceptanceQueryWrapper.eq((Object)"dr", (Object)0);
                transportationacceptanceQueryWrapper.eq((Object)"status", (Object)0);
                transportationacceptanceQueryWrapper.eq((Object)"org_id", (Object)entity.getOrgId());
                transportationacceptanceQueryWrapper.eq((Object)"org_name", (Object)entity.getOrgName());
                transportationacceptanceQueryWrapper.eq((Object)"purchasecontract_id", (Object)purchasecontractdetailEntity.getPurchasecontractId());
                transportationacceptanceQueryWrapper.eq((Object)"acceptance_date", common.getData());
                TransportationacceptanceEntity transportationacceptanceEntity = (TransportationacceptanceEntity)((Object)this.transportationacceptanceService.getOne((Wrapper)transportationacceptanceQueryWrapper));
                if (transportationacceptanceEntity != null) {
                    TransportationdetailVO transportationdetailVO = new TransportationdetailVO();
                    transportationdetailVO.setMaterialId(entity.getMaterialId());
                    transportationdetailVO.setMaterialName(entity.getMaterialName());
                    transportationdetailVO.setTransportationacceptanceId(transportationacceptanceEntity.getId());
                    transportationdetailVO.setPurchasereceiptId(vos.get(i).getId());
                    transportationdetailVO.setPrice(purchasecontractdetailEntity.getSjyfPrice());
                    transportationdetailVO.setQuantity(entity.getNetWeight());
                    transportationdetailVO.setAmount(entity.getNetWeight().multiply(purchasecontractdetailEntity.getSjyfPrice()).subtract(purchasecontractdetailEntity.getFreightRate().multiply(entity.getNetWeight().multiply(purchasecontractdetailEntity.getSjyfPrice()))));
                    transportationdetailVO.setFreightRate(purchasecontractdetailEntity.getFreightRate());
                    transportationdetailVO.setNumberPlate(entity.getNumberPlate());
                    transportationdetailVO.setTotal(entity.getNetWeight().multiply(purchasecontractdetailEntity.getSjyfPrice()));
                    transportationdetailVO.setFreightTax(purchasecontractdetailEntity.getFreightRate().multiply(entity.getNetWeight().multiply(purchasecontractdetailEntity.getSjyfPrice())));
                    TransportationdetailEntity transportationdetailEntity = (TransportationdetailEntity)((Object)BeanMapper.map((Object)((Object)transportationdetailVO), TransportationdetailEntity.class));
                    this.transportationdetailService.saveOrUpdate((Object)transportationdetailEntity, false);
                    TransportationSummaryEntity transportationSummaryEntity = new TransportationSummaryEntity();
                    QueryWrapper transportationSummaryEntityQueryWrapper = new QueryWrapper();
                    transportationSummaryEntityQueryWrapper.eq((Object)"material_id", (Object)entity.getMaterialId());
                    transportationSummaryEntityQueryWrapper.eq((Object)"price", (Object)transportationdetailVO.getPrice());
                    transportationSummaryEntityQueryWrapper.eq((Object)"transportationacceptance_id", (Object)transportationacceptanceEntity.getId());
                    transportationSummaryEntity = (TransportationSummaryEntity)((Object)this.transportationSummaryService.getOne((Wrapper)transportationSummaryEntityQueryWrapper));
                    TransportationSummaryEntity transportationSummaryEntity2 = new TransportationSummaryEntity();
                    if (transportationSummaryEntity != null) {
                        transportationSummaryEntity.setAmount(transportationSummaryEntity.getAmount().add(transportationdetailVO.getAmount()));
                        transportationSummaryEntity.setQuantity(transportationSummaryEntity.getQuantity().add(entity.getNetWeight()));
                        transportationSummaryEntity.setFreightTax(transportationSummaryEntity.getFreightTax().add(transportationdetailVO.getFreightTax()));
                        transportationSummaryEntity.setTotal(transportationSummaryEntity.getTotal().add(transportationdetailVO.getTotal()));
                        this.transportationSummaryService.updateById((Object)transportationSummaryEntity);
                    } else {
                        transportationSummaryEntity2.setTransportationacceptanceId(transportationacceptanceEntity.getId());
                        transportationSummaryEntity2.setMaterialId(entity.getMaterialId());
                        transportationSummaryEntity2.setMaterialName(entity.getMaterialName());
                        transportationSummaryEntity2.setPrice(transportationdetailVO.getPrice());
                        transportationSummaryEntity2.setQuantity(transportationdetailVO.getQuantity());
                        transportationSummaryEntity2.setAmount(transportationdetailVO.getAmount());
                        transportationSummaryEntity2.setFreightTax(transportationdetailVO.getFreightTax());
                        transportationSummaryEntity2.setTotal(transportationdetailVO.getTotal());
                        transportationSummaryEntity2.setFreightRate(purchasecontractdetailEntity.getFreightRate());
                        this.transportationSummaryService.saveOrUpdate((Object)transportationSummaryEntity2, false);
                    }
                    transportationacceptanceEntity = (TransportationacceptanceEntity)((Object)this.transportationacceptanceService.selectById(transportationacceptanceEntity.getId()));
                    BigDecimal quantity = new BigDecimal(0);
                    BigDecimal freightTax = new BigDecimal(0);
                    BigDecimal amount = new BigDecimal(0);
                    BigDecimal total = new BigDecimal(0);
                    for (TransportationdetailEntity temp : transportationacceptanceEntity.getTransportationdetailList()) {
                        quantity = quantity.add(temp.getQuantity());
                        freightTax = freightTax.add(temp.getFreightTax());
                        amount = amount.add(temp.getAmount());
                        total = total.add(temp.getTotal());
                    }
                    transportationacceptanceEntity.setQuantity(quantity);
                    transportationacceptanceEntity.setTax(freightTax);
                    transportationacceptanceEntity.setMoney(amount);
                    transportationacceptanceEntity.setTotalAmount(total);
                    this.transportationacceptanceService.updateById((Object)transportationacceptanceEntity);
                } else {
                    TransportationacceptanceVO transportationacceptanceVO = new TransportationacceptanceVO();
                    transportationacceptanceVO.setShippersId(purchasecontractdetailEntity.getShippersId());
                    transportationacceptanceVO.setShippersName(purchasecontractdetailEntity.getShippersName());
                    transportationacceptanceVO.setStatus(0);
                    transportationacceptanceVO.setOrgId(entity.getOrgId());
                    transportationacceptanceVO.setOrgName(entity.getOrgName());
                    transportationacceptanceVO.setShippingType(0);
                    transportationacceptanceVO.setAcceptanceDate(sdf1.parse((String)common.getData()));
                    transportationacceptanceVO.setPurchasecontractBillCode(purchaseContractEntity.getBillCode());
                    transportationacceptanceVO.setPurchasecontractId(purchasecontractdetailEntity.getPurchasecontractId());
                    transportationacceptanceEntity = (TransportationacceptanceEntity)((Object)BeanMapper.map((Object)((Object)transportationacceptanceVO), TransportationacceptanceEntity.class));
                    if (transportationacceptanceEntity.getId() == null || transportationacceptanceEntity.getId() == 0L) {
                        billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)transportationacceptanceVO);
                        billCode = this.billCodeApi.generateBillCode(billCodeParam);
                        if (billCode.isSuccess()) {
                            transportationacceptanceEntity.setBillCode((String)billCode.getData());
                        } else {
                            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                        }
                    }
                    this.transportationacceptanceService.saveOrUpdate((Object)transportationacceptanceEntity, false);
                    transportationacceptanceVO = (TransportationacceptanceVO)((Object)BeanMapper.map((Object)((Object)transportationacceptanceEntity), TransportationacceptanceVO.class));
                    TransportationdetailVO transportationdetailVO = new TransportationdetailVO();
                    transportationdetailVO.setTransportationacceptanceId(transportationacceptanceVO.getId());
                    transportationdetailVO.setPurchasereceiptId(vos.get(i).getId());
                    transportationdetailVO.setPrice(purchasecontractdetailEntity.getSjyfPrice());
                    transportationdetailVO.setQuantity(entity.getNetWeight());
                    transportationdetailVO.setMaterialId(entity.getMaterialId());
                    transportationdetailVO.setMaterialName(entity.getMaterialName());
                    transportationdetailVO.setAmount(entity.getNetWeight().multiply(purchasecontractdetailEntity.getSjyfPrice()).subtract(purchasecontractdetailEntity.getFreightRate().multiply(entity.getNetWeight().multiply(purchasecontractdetailEntity.getSjyfPrice()))));
                    transportationdetailVO.setFreightRate(purchasecontractdetailEntity.getFreightRate());
                    transportationdetailVO.setFreightTax(purchasecontractdetailEntity.getFreightRate().multiply(entity.getNetWeight().multiply(purchasecontractdetailEntity.getSjyfPrice())));
                    transportationdetailVO.setNumberPlate(entity.getNumberPlate());
                    transportationdetailVO.setTotal(entity.getNetWeight().multiply(purchasecontractdetailEntity.getSjyfPrice()));
                    TransportationdetailEntity transportationdetailEntity = (TransportationdetailEntity)((Object)BeanMapper.map((Object)((Object)transportationdetailVO), TransportationdetailEntity.class));
                    this.transportationdetailService.saveOrUpdate((Object)transportationdetailEntity, false);
                    TransportationSummaryEntity transportationSummaryEntity = new TransportationSummaryEntity();
                    transportationSummaryEntity.setTransportationacceptanceId(transportationacceptanceVO.getId());
                    transportationSummaryEntity.setMaterialId(entity.getMaterialId());
                    transportationSummaryEntity.setMaterialName(entity.getMaterialName());
                    transportationSummaryEntity.setPrice(transportationdetailVO.getPrice());
                    transportationSummaryEntity.setQuantity(transportationdetailVO.getQuantity());
                    transportationSummaryEntity.setAmount(transportationdetailVO.getAmount());
                    transportationSummaryEntity.setFreightTax(transportationdetailVO.getFreightTax());
                    transportationSummaryEntity.setTotal(transportationdetailVO.getTotal());
                    transportationSummaryEntity.setFreightRate(purchasecontractdetailEntity.getFreightRate());
                    this.transportationSummaryService.saveOrUpdate((Object)transportationSummaryEntity, false);
                    transportationacceptanceEntity.setId(transportationacceptanceVO.getId());
                    transportationacceptanceEntity.setQuantity(entity.getNetWeight());
                    transportationacceptanceEntity.setTax(purchasecontractdetailEntity.getFreightRate().multiply(entity.getNetWeight().multiply(purchasecontractdetailEntity.getSjyfPrice())));
                    transportationacceptanceEntity.setMoney(entity.getNetWeight().multiply(purchasecontractdetailEntity.getSjyfPrice()).subtract(purchasecontractdetailEntity.getFreightRate().multiply(entity.getNetWeight().multiply(purchasecontractdetailEntity.getSjyfPrice()))));
                    transportationacceptanceEntity.setTotalAmount(entity.getNetWeight().multiply(purchasecontractdetailEntity.getSjyfPrice()));
                    transportationacceptanceEntity.setPrice(purchasecontractdetailEntity.getSjyfPrice());
                    transportationacceptanceEntity.setTaxRate(purchasecontractdetailEntity.getFreightRate());
                    this.transportationacceptanceService.updateById((Object)transportationacceptanceEntity);
                }
            }
            QueryWrapper materialacceptanceEntityQueryWrapper = new QueryWrapper();
            materialacceptanceEntityQueryWrapper.eq((Object)"supplierinfo_id", (Object)materialplanEntity.getSupplierinfoId());
            materialacceptanceEntityQueryWrapper.eq((Object)"confirm_status", (Object)0);
            materialacceptanceEntityQueryWrapper.eq((Object)"dr", (Object)0);
            materialacceptanceEntityQueryWrapper.eq((Object)"purchasecontract_id", (Object)purchasecontractdetailEntity.getPurchasecontractId());
            materialacceptanceEntityQueryWrapper.eq((Object)"acceptance_date", common.getData());
            MaterialacceptanceEntity materialacceptanceEntity = (MaterialacceptanceEntity)((Object)this.materialacceptanceService.getOne((Wrapper)materialacceptanceEntityQueryWrapper));
            if (materialacceptanceEntity != null) {
                saveOrUpdateVO = new MaterialacceptancedetailVO();
                saveOrUpdateVO.setMaterialacceptanceId(materialacceptanceEntity.getId());
                saveOrUpdateVO.setMaterialId(entity.getMaterialId());
                saveOrUpdateVO.setMaterialName(entity.getMaterialName());
                saveOrUpdateVO.setMaterialplanId(entity.getMaterialplanId());
                saveOrUpdateVO.setPrice(materialplanEntity.getPrice());
                saveOrUpdateVO.setMaterialTaxRate(materialplanEntity.getMaterialTax());
                saveOrUpdateVO.setQuantity(entity.getNetWeight());
                saveOrUpdateVO.setNumberPlate(entity.getNumberPlate());
                saveOrUpdateVO.setPurchasereceiptId(vos.get(i).getId());
                BigDecimal quantityReceived = entity.getNetWeight();
                BigDecimal amount = quantityReceived.multiply(materialplanEntity.getPrice());
                saveOrUpdateVO.setReceiptDate(entity.getReceiptTime());
                saveOrUpdateVO.setMoney(amount.subtract(materialplanEntity.getMaterialTax().multiply(materialplanEntity.getPrice().multiply(entity.getNetWeight()))));
                saveOrUpdateVO.setMaterialTax(materialplanEntity.getMaterialTax().multiply(materialplanEntity.getPrice().multiply(entity.getNetWeight())));
                saveOrUpdateVO.setTotal(amount);
                MaterialacceptancedetailEntity materialacceptancedetailEntity = (MaterialacceptancedetailEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MaterialacceptancedetailEntity.class));
                this.materialacceptancedetailService.saveOrUpdate((Object)materialacceptancedetailEntity, false);
                MaterialacceptanceSummaryEntity materialacceptanceSummaryEntity = new MaterialacceptanceSummaryEntity();
                QueryWrapper materialacceptanceSummaryEntityQueryWrapper = new QueryWrapper();
                materialacceptanceSummaryEntityQueryWrapper.eq((Object)"material_id", (Object)entity.getMaterialId());
                materialacceptanceSummaryEntityQueryWrapper.eq((Object)"price", (Object)saveOrUpdateVO.getPrice());
                materialacceptanceSummaryEntityQueryWrapper.eq((Object)"materialacceptance_id", (Object)materialacceptanceEntity.getId());
                materialacceptanceSummaryEntity = (MaterialacceptanceSummaryEntity)((Object)this.materialacceptanceSummaryService.getOne((Wrapper)materialacceptanceSummaryEntityQueryWrapper));
                MaterialacceptanceSummaryEntity materialacceptanceSummaryEntity2 = new MaterialacceptanceSummaryEntity();
                if (materialacceptanceSummaryEntity != null) {
                    materialacceptanceSummaryEntity.setMoney(materialacceptanceSummaryEntity.getMoney().add(saveOrUpdateVO.getMoney()));
                    materialacceptanceSummaryEntity.setQuantity(materialacceptanceSummaryEntity.getQuantity().add(entity.getNetWeight()));
                    materialacceptanceSummaryEntity.setMaterialTax(materialacceptanceSummaryEntity.getMaterialTax().add(saveOrUpdateVO.getMaterialTax()));
                    materialacceptanceSummaryEntity.setTotal(materialacceptanceSummaryEntity.getTotal().add(saveOrUpdateVO.getTotal()));
                    this.materialacceptanceSummaryService.updateById((Object)materialacceptanceSummaryEntity);
                } else {
                    materialacceptanceSummaryEntity2.setMaterialacceptanceId(materialacceptanceEntity.getId());
                    materialacceptanceSummaryEntity2.setMaterialId(entity.getMaterialId());
                    materialacceptanceSummaryEntity2.setMaterialName(entity.getMaterialName());
                    materialacceptanceSummaryEntity2.setPrice(saveOrUpdateVO.getPrice());
                    materialacceptanceSummaryEntity2.setQuantity(saveOrUpdateVO.getQuantity());
                    materialacceptanceSummaryEntity2.setMoney(saveOrUpdateVO.getMoney());
                    materialacceptanceSummaryEntity2.setMaterialTax(saveOrUpdateVO.getMaterialTax());
                    materialacceptanceSummaryEntity2.setTotal(saveOrUpdateVO.getTotal());
                    materialacceptanceSummaryEntity2.setMaterialTaxRate(materialplanEntity.getMaterialTax());
                    this.materialacceptanceSummaryService.saveOrUpdate((Object)materialacceptanceSummaryEntity2, false);
                }
                materialacceptanceEntity = (MaterialacceptanceEntity)((Object)this.materialacceptanceService.selectById(materialacceptanceEntity.getId()));
                BigDecimal quantity = new BigDecimal(0);
                BigDecimal amountAll = new BigDecimal(0);
                BigDecimal materialTax = new BigDecimal(0);
                BigDecimal total = new BigDecimal(0);
                for (MaterialacceptancedetailEntity temp : materialacceptanceEntity.getMaterialacceptancedetailList()) {
                    quantity = quantity.add(temp.getQuantity());
                    amountAll = amountAll.add(temp.getMoney());
                    materialTax = materialTax.add(temp.getMaterialTax());
                    total = total.add(temp.getTotal());
                }
                materialacceptanceEntity.setAcceptanceQuantity(quantity);
                materialacceptanceEntity.setAmount(amountAll);
                materialacceptanceEntity.setTotalAmount(total);
                materialacceptanceEntity.setTax(materialTax);
                this.materialacceptanceService.updateById((Object)materialacceptanceEntity);
            } else {
                saveOrUpdateVO = new MaterialacceptanceVO();
                saveOrUpdateVO.setMaterialplanId(materialplanEntity.getId());
                saveOrUpdateVO.setSupplierinfoId(materialplanEntity.getSupplierinfoId());
                saveOrUpdateVO.setSupplierinfoName(materialplanEntity.getSupplierinfoName());
                saveOrUpdateVO.setOrgId(materialplanEntity.getOrgId());
                saveOrUpdateVO.setOrgName(materialplanEntity.getOrgName());
                saveOrUpdateVO.setPurchasecontractBillCode(purchaseContractEntity.getBillCode());
                saveOrUpdateVO.setConfirmStatus(0);
                saveOrUpdateVO.setPurchasecontractId(purchasecontractdetailEntity.getPurchasecontractId());
                saveOrUpdateVO.setAcceptanceDate(sdf1.parse((String)common.getData()));
                materialacceptanceEntity = (MaterialacceptanceEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MaterialacceptanceEntity.class));
                if (materialacceptanceEntity.getId() == null || materialacceptanceEntity.getId() == 0L) {
                    billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
                    billCode = this.billCodeApi.generateBillCode(billCodeParam);
                    if (billCode.isSuccess()) {
                        materialacceptanceEntity.setBillCode((String)billCode.getData());
                    } else {
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                }
                this.materialacceptanceService.saveOrUpdate((Object)materialacceptanceEntity, false);
                MaterialacceptanceVO materialacceptanceVO = (MaterialacceptanceVO)((Object)BeanMapper.map((Object)((Object)materialacceptanceEntity), MaterialacceptanceVO.class));
                QueryWrapper materialplanEntityQueryWrapper = new QueryWrapper();
                materialplanEntityQueryWrapper.eq((Object)"id", (Object)entity.getMaterialplanId());
                materialplanEntityQueryWrapper.eq((Object)"dr", (Object)0);
                MaterialacceptancedetailVO materialacceptancedetailVO = new MaterialacceptancedetailVO();
                materialacceptancedetailVO.setMaterialacceptanceId(materialacceptanceVO.getId());
                materialacceptancedetailVO.setMaterialId(entity.getMaterialId());
                materialacceptancedetailVO.setMaterialName(entity.getMaterialName());
                materialacceptancedetailVO.setMaterialplanId(entity.getMaterialplanId());
                materialacceptancedetailVO.setPrice(materialplanEntity.getPrice());
                materialacceptancedetailVO.setMaterialTaxRate(materialplanEntity.getMaterialTax());
                materialacceptancedetailVO.setQuantity(entity.getNetWeight());
                materialacceptancedetailVO.setNumberPlate(entity.getNumberPlate());
                materialacceptancedetailVO.setReceiptDate(entity.getReceiptTime());
                materialacceptancedetailVO.setPurchasereceiptId(vos.get(i).getId());
                materialacceptancedetailVO.setMaterialTax(materialplanEntity.getMaterialTax().multiply(materialplanEntity.getPrice().multiply(entity.getNetWeight())));
                BigDecimal quantityReceived = entity.getNetWeight();
                BigDecimal amount = quantityReceived.multiply(materialplanEntity.getPrice());
                materialacceptancedetailVO.setMoney(amount.subtract(materialplanEntity.getMaterialTax().multiply(materialplanEntity.getPrice().multiply(entity.getNetWeight()))));
                materialacceptancedetailVO.setTotal(amount);
                MaterialacceptancedetailEntity materialacceptancedetailEntity = (MaterialacceptancedetailEntity)((Object)BeanMapper.map((Object)((Object)materialacceptancedetailVO), MaterialacceptancedetailEntity.class));
                this.materialacceptancedetailService.saveOrUpdate((Object)materialacceptancedetailEntity, false);
                MaterialacceptanceSummaryEntity materialacceptanceSummaryEntity = new MaterialacceptanceSummaryEntity();
                materialacceptanceSummaryEntity.setMaterialacceptanceId(materialacceptanceVO.getId());
                materialacceptanceSummaryEntity.setMaterialId(entity.getMaterialId());
                materialacceptanceSummaryEntity.setMaterialName(entity.getMaterialName());
                materialacceptanceSummaryEntity.setPrice(materialacceptancedetailVO.getPrice());
                materialacceptanceSummaryEntity.setQuantity(materialacceptancedetailVO.getQuantity());
                materialacceptanceSummaryEntity.setMoney(materialacceptancedetailVO.getMoney());
                materialacceptanceSummaryEntity.setMaterialTax(materialacceptancedetailVO.getMaterialTax());
                materialacceptanceSummaryEntity.setTotal(materialacceptancedetailVO.getTotal());
                materialacceptanceSummaryEntity.setMaterialTaxRate(materialplanEntity.getMaterialTax());
                this.materialacceptanceSummaryService.saveOrUpdate((Object)materialacceptanceSummaryEntity, false);
                materialacceptanceEntity.setTotalAmount(amount);
                materialacceptanceEntity.setAmount(amount.subtract(materialplanEntity.getMaterialTax().multiply(materialplanEntity.getPrice().multiply(entity.getNetWeight()))));
                materialacceptanceEntity.setAcceptanceQuantity(entity.getNetWeight());
                materialacceptanceEntity.setTax(materialplanEntity.getMaterialTax().multiply(materialplanEntity.getPrice().multiply(entity.getNetWeight())));
                this.materialacceptanceService.updateById((Object)materialacceptanceEntity);
            }
            entity.setBillState(3);
            this.service.updateById((Object)entity);
            QueryWrapper materialplanEntityQueryWrapper = new QueryWrapper();
            materialplanEntityQueryWrapper.eq((Object)"id", (Object)entity.getMaterialplanId());
            materialplanEntityQueryWrapper.eq((Object)"dr", (Object)0);
            materialplanEntity = (MaterialplanEntity)((Object)this.materialplanService.getOne((Wrapper)materialplanEntityQueryWrapper));
            QueryWrapper queryWrapper1 = new QueryWrapper();
            queryWrapper1.eq((Object)"id", (Object)entity.getCgysId());
            queryWrapper1.eq((Object)"dr", (Object)0);
            PurchasedetilEntity purchasedetilEntity = (PurchasedetilEntity)((Object)this.purchasedetilService.getOne((Wrapper)queryWrapper1));
            purchasedetilEntity.setStatus(1);
            purchasedetilEntity.setReceiptQuantity(entity.getNetWeight());
            this.purchasedetilService.updateById((Object)purchasedetilEntity);
            QueryWrapper queryWrapper3 = new QueryWrapper();
            PurchasetransportationEntity purchasetransportationEntity = (PurchasetransportationEntity)((Object)this.purchasetransportationService.getById(purchasedetilEntity.getPurchasetransportationId()));
            queryWrapper3.eq((Object)"purchasetransportation_id", (Object)purchasedetilEntity.getPurchasetransportationId());
            queryWrapper3.eq((Object)"dr", (Object)0);
            List purchasedetilEntities = this.purchasedetilService.list((Wrapper)queryWrapper3);
            BigDecimal sum = new BigDecimal(0.0);
            for (PurchasedetilEntity temp : purchasedetilEntities) {
                if (temp.getReceiptQuantity() == null) continue;
                sum = sum.add(temp.getReceiptQuantity());
            }
            purchasetransportationEntity.setReceiptQuantity(sum);
            purchasetransportationEntity.setReceiptTime(entity.getReceiptTime());
            this.purchasetransportationService.updateById((Object)purchasetransportationEntity);
            materialplanEntity.setQuantityReceived(sum);
            this.materialplanService.updateById((Object)materialplanEntity);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01");
    }

    public static boolean afterDate(String date) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date startDate = new Date();
        Date endDate = sdf.parse(date);
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        start.setTime(startDate);
        end.setTime(endDate);
        boolean result = false;
        if (start.before(end)) {
            System.err.println("\u5f00\u59cb\u65f6\u95f4\u5c0f\u4e8e\u7ed3\u675f\u65f6\u95f4");
            result = false;
        } else if (start.after(end)) {
            System.err.println("\u5f00\u59cb\u65f6\u95f4\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4");
            result = true;
        } else if (start.equals(end)) {
            System.err.println("\u5f00\u59cb\u65f6\u95f4\u7b49\u4e8e\u7ed3\u675f\u65f6\u95f4");
            result = true;
        }
        return result;
    }
}

