/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.purchasingmanagement.service.impl;

import com.ejianc.business.purchasingmanagement.bean.MaterialacceptanceEntity;
import com.ejianc.business.purchasingmanagement.bean.PurchaseContractEntity;
import com.ejianc.business.purchasingmanagement.bean.PurchasecontractdetailEntity;
import com.ejianc.business.purchasingmanagement.bean.SalesreconciliationEntity;
import com.ejianc.business.purchasingmanagement.bean.SalesreconciliationdetailEntity;
import com.ejianc.business.purchasingmanagement.service.IMaterialacceptanceService;
import com.ejianc.business.purchasingmanagement.service.IPurchaseContractService;
import com.ejianc.business.purchasingmanagement.service.IPurchasecontractdetailService;
import com.ejianc.business.purchasingmanagement.service.ISalesreconciliationService;
import com.ejianc.business.purchasingmanagement.vo.MaterialacceptanceVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="salesreconciliation")
public class SalesreconciliationBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ISalesreconciliationService service;
    @Autowired
    private IMaterialacceptanceService materialacceptanceService;
    @Autowired
    private IPurchaseContractService purchaseContractService;
    @Autowired
    private IPurchasecontractdetailService purchasecontractdetailService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("---------\u8fdb\u6765\u5566--------");
        SalesreconciliationEntity entity = (SalesreconciliationEntity)((Object)this.service.selectById(billId));
        if (entity.getSalesreconciliationdetailList().size() > 0) {
            this.logger.info("---------\u4e0d\u4e3a\u7a7a--------");
            for (SalesreconciliationdetailEntity detailEntity : entity.getSalesreconciliationdetailList()) {
                MaterialacceptanceEntity materialacceptanceEntity = (MaterialacceptanceEntity)((Object)this.materialacceptanceService.getById(detailEntity.getMaterialacceptanceId()));
                materialacceptanceEntity.setMeetMoney(detailEntity.getAdjustedMoney());
                this.logger.info("---------\u5df2\u4fee\u6539--------");
                this.materialacceptanceService.updateById((Object)materialacceptanceEntity);
            }
        } else {
            PurchasecontractdetailEntity purchasecontractdetailEntity = (PurchasecontractdetailEntity)((Object)this.purchasecontractdetailService.getById(entity.getMaterialId()));
            PurchaseContractEntity purchaseContractEntity = (PurchaseContractEntity)((Object)this.purchaseContractService.getById(entity.getContractId()));
            MaterialacceptanceVO materialacceptanceVO = new MaterialacceptanceVO();
            materialacceptanceVO.setSupplierinfoId(entity.getSupplierId());
            materialacceptanceVO.setSupplierinfoName(entity.getSupplierName());
            materialacceptanceVO.setAcceptanceQuantity(new BigDecimal(0.0));
            materialacceptanceVO.setTaxrate(purchasecontractdetailEntity.getMaterialTax());
            materialacceptanceVO.setPurchasecontractId(entity.getContractId());
            materialacceptanceVO.setPurchasecontractBillCode(purchaseContractEntity.getBillCode());
            materialacceptanceVO.setPurchasecontractMaterialId(entity.getMaterialId());
            materialacceptanceVO.setPurchasecontractMaterialName(entity.getMaterialName());
            materialacceptanceVO.setTotalAmount(entity.getAdjustmentAmount());
            BigDecimal tax = new BigDecimal(1.0).add(purchasecontractdetailEntity.getMaterialTax());
            materialacceptanceVO.setTax(entity.getAdjustmentAmount().divide(tax, 2, 4));
            materialacceptanceVO.setAmount(entity.getAdjustmentAmount().subtract(materialacceptanceVO.getTax()));
            materialacceptanceVO.setAcceptanceDate(entity.getDate());
            materialacceptanceVO.setOrgId(purchaseContractEntity.getOrgId());
            materialacceptanceVO.setOrgName(purchaseContractEntity.getOrgName());
            materialacceptanceVO.setAmountPaid(new BigDecimal(0.0));
            materialacceptanceVO.setMeetMoney(materialacceptanceVO.getTotalAmount());
            materialacceptanceVO.setAmountNotPaid(materialacceptanceVO.getMeetMoney().subtract(materialacceptanceVO.getAmountPaid()));
            materialacceptanceVO.setInvoiceReceived(new BigDecimal(0.0));
            materialacceptanceVO.setInvoiceNotReceived(materialacceptanceVO.getTotalAmount());
            materialacceptanceVO.setIsSign(1);
            materialacceptanceVO.setAcceptanceType(1);
            materialacceptanceVO.setSalesreconciliationId(entity.getId());
            MaterialacceptanceEntity entitys = (MaterialacceptanceEntity)((Object)BeanMapper.map((Object)((Object)materialacceptanceVO), MaterialacceptanceEntity.class));
            if (entitys.getId() == null || entitys.getId() == 0L) {
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)materialacceptanceVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    entitys.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            this.materialacceptanceService.saveOrUpdate((Object)entitys, false);
            this.logger.info("---------\u65b0\u589e\u9a8c\u6536\u5355\u6210\u529f--------");
        }
        this.logger.info("---------\u7ed3\u675f--------");
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

