/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.purchasingmanagement.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.purchasingmanagement.bean.MaterialacceptanceEntity;
import com.ejianc.business.purchasingmanagement.bean.MaterialsignEntity;
import com.ejianc.business.purchasingmanagement.bean.MaterialsigndetailEntity;
import com.ejianc.business.purchasingmanagement.service.IMaterialacceptanceService;
import com.ejianc.business.purchasingmanagement.service.IMaterialsignService;
import com.ejianc.business.purchasingmanagement.service.IMaterialsigndetailService;
import com.ejianc.business.purchasingmanagement.vo.MaterialsignVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"materialsign"})
public class MaterialsignController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IMaterialsignService service;
    @Autowired
    private IMaterialacceptanceService materialacceptanceService;
    @Autowired
    private IMaterialsigndetailService materialsigndetailService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MaterialsignVO> saveOrUpdate(@RequestBody MaterialsignVO saveOrUpdateVO) {
        MaterialsignEntity entity = (MaterialsignEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), MaterialsignEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setSignStatus(1);
            entity.setBillCode((String)billCode.getData());
            for (MaterialsigndetailEntity detail : entity.getMaterialsigndetailList()) {
                detail.setId(null);
            }
        } else if (saveOrUpdateVO.getMaterialsigndetailList().size() != 0 && saveOrUpdateVO.getBillState() == 0) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"mid", (Object)saveOrUpdateVO.getId());
            List list = this.materialsigndetailService.list((Wrapper)queryWrapper);
            List resultList = list.stream().filter(item -> !saveOrUpdateVO.getMaterialsigndetailList().stream().map(e -> e.getId()).collect(Collectors.toList()).contains(item.getId())).collect(Collectors.toList());
            for (MaterialsigndetailEntity materialsigndetailEntity : resultList) {
                materialsigndetailEntity.setRowState("del");
                entity.getMaterialsigndetailList().add(materialsigndetailEntity);
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        MaterialsignVO vo = (MaterialsignVO)((Object)BeanMapper.map((Object)((Object)entity), MaterialsignVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialsignVO> queryDetail(Long id) {
        MaterialsignEntity entity = (MaterialsignEntity)((Object)this.service.selectById(id));
        MaterialsignVO vo = (MaterialsignVO)((Object)BeanMapper.map((Object)((Object)entity), MaterialsignVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialsignVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MaterialsignVO vo : vos) {
                MaterialsignEntity materialsignEntity = (MaterialsignEntity)((Object)this.service.getById(vo.getId()));
                if (materialsignEntity.getSignStatus() != 0) continue;
                throw new BusinessException("\u8be5\u5355\u5b50\u5df2\u7b7e\u8ba4\u4e0d\u5141\u8bb8\u5220\u9664!");
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaterialsignVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("contractName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialsignVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Materialsign-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMaterialsignData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialsignVO>> refMaterialsignData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialsignVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/updatesignStatus"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialsignVO> updateIsColse(Long id) {
        MaterialsignEntity entity = (MaterialsignEntity)((Object)this.service.selectById(id));
        entity.setSignStatus(0);
        entity.setSignTime(new Date());
        entity.setSignMoney(entity.getBookTotalMoney());
        entity.setSignBalance(entity.getBookBalance());
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(1, 2);
        entity.setFailureTime(cal.getTime());
        this.service.updateById((Object)entity);
        for (MaterialsigndetailEntity detail : entity.getMaterialsigndetailList()) {
            MaterialacceptanceEntity materialacceptanceEntity = (MaterialacceptanceEntity)((Object)this.materialacceptanceService.getById(detail.getMaterialacceptanceId()));
            materialacceptanceEntity.setIsSign(0);
            this.materialacceptanceService.updateById((Object)materialacceptanceEntity);
        }
        MaterialsignVO vo = (MaterialsignVO)((Object)BeanMapper.map((Object)((Object)entity), MaterialsignVO.class));
        return CommonResponse.success((String)"\u5173\u95ed\u6210\u529f", (Object)((Object)vo));
    }
}

