/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.purchasingmanagement.service.impl;

import com.ejianc.business.purchasingmanagement.bean.FreighttransferEntity;
import com.ejianc.business.purchasingmanagement.bean.FreighttransferdetailEntity;
import com.ejianc.business.purchasingmanagement.bean.PurchaseContractEntity;
import com.ejianc.business.purchasingmanagement.bean.PurchasecontractdetailEntity;
import com.ejianc.business.purchasingmanagement.bean.TransportationacceptanceEntity;
import com.ejianc.business.purchasingmanagement.service.IFreighttransferService;
import com.ejianc.business.purchasingmanagement.service.IPurchaseContractService;
import com.ejianc.business.purchasingmanagement.service.IPurchasecontractdetailService;
import com.ejianc.business.purchasingmanagement.service.ITransportationacceptanceService;
import com.ejianc.business.purchasingmanagement.vo.TransportationacceptanceVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="freighttransfer")
public class FreighttransferBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IFreighttransferService service;
    @Autowired
    private ITransportationacceptanceService transportationacceptanceService;
    @Autowired
    private IPurchaseContractService purchaseContractService;
    @Autowired
    private IPurchasecontractdetailService purchasecontractdetailService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("---------\u8fdb\u6765\u5566--------");
        FreighttransferEntity entity = (FreighttransferEntity)((Object)this.service.selectById(billId));
        if (entity.getFreighttransferdetailList().size() > 0) {
            this.logger.info("---------\u4e0d\u4e3a\u7a7a--------");
            for (FreighttransferdetailEntity detailEntity : entity.getFreighttransferdetailList()) {
                TransportationacceptanceEntity transportationacceptanceEntity = (TransportationacceptanceEntity)((Object)this.transportationacceptanceService.getById(detailEntity.getMaterialacceptanceId()));
                transportationacceptanceEntity.setMeetMoney(detailEntity.getAdjustedMoney());
                this.logger.info("---------\u5df2\u4fee\u6539--------");
                this.transportationacceptanceService.updateById((Object)transportationacceptanceEntity);
            }
        } else {
            PurchasecontractdetailEntity purchasecontractdetailEntity = (PurchasecontractdetailEntity)((Object)this.purchasecontractdetailService.getById(entity.getMaterialId()));
            PurchaseContractEntity purchaseContractEntity = (PurchaseContractEntity)((Object)this.purchaseContractService.getById(entity.getContractId()));
            TransportationacceptanceVO transportationacceptanceVO = new TransportationacceptanceVO();
            transportationacceptanceVO.setShippersId(entity.getTransporterId());
            transportationacceptanceVO.setShippersName(entity.getTransporterName());
            transportationacceptanceVO.setQuantity(new BigDecimal(0.0));
            transportationacceptanceVO.setTotalAmount(entity.getAdjustmentAmount());
            BigDecimal tax = new BigDecimal(1.0).add(purchasecontractdetailEntity.getFreightRate());
            transportationacceptanceVO.setTax(entity.getAdjustmentAmount().divide(tax, 2, 4));
            transportationacceptanceVO.setMoney(entity.getAdjustmentAmount().subtract(transportationacceptanceVO.getTax()));
            transportationacceptanceVO.setPurchasecontractId(entity.getContractId());
            transportationacceptanceVO.setPurchasecontractBillCode(purchaseContractEntity.getBillCode());
            transportationacceptanceVO.setPurchasecontractdetailId(purchasecontractdetailEntity.getId());
            transportationacceptanceVO.setPurchasecontractMaterialName(purchasecontractdetailEntity.getMaterialName());
            transportationacceptanceVO.setAcceptanceDate(entity.getDate());
            transportationacceptanceVO.setOrgId(entity.getOrgId());
            transportationacceptanceVO.setOrgName(entity.getOrgName());
            transportationacceptanceVO.setMeetMoney(transportationacceptanceVO.getTotalAmount());
            transportationacceptanceVO.setAmountPaid(new BigDecimal(0.0));
            transportationacceptanceVO.setAmountNotPaid(transportationacceptanceVO.getTotalAmount());
            transportationacceptanceVO.setInvoiceReceived(new BigDecimal(0.0));
            transportationacceptanceVO.setInvoiceNotReceived(transportationacceptanceVO.getTotalAmount());
            transportationacceptanceVO.setIsSign(1);
            transportationacceptanceVO.setAcceptanceType(1);
            transportationacceptanceVO.setSalesreconciliationId(entity.getId());
            TransportationacceptanceEntity transportationacceptanceEntity = (TransportationacceptanceEntity)((Object)BeanMapper.map((Object)((Object)transportationacceptanceVO), TransportationacceptanceEntity.class));
            if (transportationacceptanceEntity.getId() == null || transportationacceptanceEntity.getId() == 0L) {
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)transportationacceptanceVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    transportationacceptanceEntity.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            this.transportationacceptanceService.saveOrUpdate((Object)transportationacceptanceEntity, false);
            this.logger.info("---------\u65b0\u589e\u9a8c\u6536\u5355\u6210\u529f--------");
        }
        this.logger.info("---------\u7ed3\u675f--------");
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

