/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.purchasingmanagement.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.purchasingmanagement.bean.MaterialplanEntity;
import com.ejianc.business.purchasingmanagement.bean.PurchasetransportationEntity;
import com.ejianc.business.purchasingmanagement.service.IMaterialplanService;
import com.ejianc.business.purchasingmanagement.service.IPurchasedetilService;
import com.ejianc.business.purchasingmanagement.service.IPurchasetransportationService;
import com.ejianc.business.purchasingmanagement.vo.MaterialPlanStatisticsVO;
import com.ejianc.business.purchasingmanagement.vo.MaterialplanVO;
import com.ejianc.business.purchasingmanagement.vo.PurchasedetilVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"materialplan"})
public class MaterialplanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IMaterialplanService service;
    @Autowired
    private IPurchasedetilService purchasedetilService;
    @Autowired
    private IPurchasetransportationService purchasetransportationService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MaterialplanVO> saveOrUpdate(@RequestBody MaterialplanVO saveOrUpdateVO) {
        return this.service.saveChange(saveOrUpdateVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialplanVO> queryDetail(Long id) throws ParseException {
        MaterialplanEntity entity = (MaterialplanEntity)((Object)this.service.selectById(id));
        MaterialplanVO vo = (MaterialplanVO)((Object)BeanMapper.map((Object)((Object)entity), MaterialplanVO.class));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"materialplan_id", (Object)id);
        queryWrapper.eq((Object)"dr", (Object)0);
        List purchasedetilEntities = this.purchasedetilService.list((Wrapper)queryWrapper);
        vo.setPurchasedetilList(BeanMapper.mapList((Iterable)purchasedetilEntities, PurchasedetilVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialplanVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MaterialplanVO vo : vos) {
                MaterialplanEntity entity = (MaterialplanEntity)((Object)this.service.selectById(vo.getId()));
                if (null != entity.getQuantityReceived()) {
                    throw new BusinessException("\u5220\u9664\u6570\u636e\u8fd8\u6709\u672a\u5b8c\u6210\u63a5\u6536\u6570\u91cf\uff0c\u5220\u9664\u5931\u8d25");
                }
                QueryWrapper purchasetransportationEntityQueryWrapper = new QueryWrapper();
                purchasetransportationEntityQueryWrapper.eq((Object)"materialplan_id", (Object)entity.getId());
                PurchasetransportationEntity purchasetransportationEntity = (PurchasetransportationEntity)((Object)this.purchasetransportationService.getOne((Wrapper)purchasetransportationEntityQueryWrapper));
                this.purchasetransportationService.removeById(purchasetransportationEntity.getId());
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaterialplanVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("supplierinfoName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("materialName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialplanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("start_date");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List vo = BeanMapper.mapList((Iterable)list, MaterialplanVO.class);
        for (MaterialplanVO materialplanVO : vo) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            materialplanVO.setStartDates(sdf.format(materialplanVO.getStarDate()));
            materialplanVO.setEndDates(sdf1.format(materialplanVO.getEndDate()));
            if (materialplanVO.getIsColse() == 1) {
                materialplanVO.setIsColses("\u672a\u5173\u95ed");
                continue;
            }
            materialplanVO.setIsColses("\u5df2\u5173\u95ed");
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", vo);
        ExcelExport.getInstance().export("Materialplan-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMaterialplanData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialplanVO>> refMaterialplanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialplanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/updateIsColse"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialplanVO> updateIsColse(Long id) {
        MaterialplanEntity entity = (MaterialplanEntity)((Object)this.service.selectById(id));
        entity.setIsColse(0);
        this.service.updateById((Object)entity);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"materialplan_id", (Object)id);
        List list = this.purchasetransportationService.list((Wrapper)queryWrapper);
        for (PurchasetransportationEntity entity1 : list) {
            entity1.setIsColse(0);
            this.purchasetransportationService.updateById((Object)entity1);
        }
        MaterialplanVO vo = (MaterialplanVO)((Object)BeanMapper.map((Object)((Object)entity), MaterialplanVO.class));
        return CommonResponse.success((String)"\u5173\u95ed\u6210\u529f", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryPlanPercent"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<MaterialPlanStatisticsVO>> queryPlanPercent(Long orgId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"org_id", (Object)orgId);
        queryWrapper.eq((Object)"is_colse", (Object)1);
        List list = this.service.list((Wrapper)queryWrapper);
        List VOS = BeanMapper.mapList((Iterable)list, MaterialPlanStatisticsVO.class);
        for (MaterialPlanStatisticsVO vo : VOS) {
            if (vo.getQuantityReceived() == null) {
                vo.setPercent("0%");
                vo.setQuantityReceived(new BigDecimal("0"));
                continue;
            }
            vo.setPercent(vo.getQuantityReceived().divide(vo.getQuantity(), 2).toPlainString() + "%");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5b9a\u6599\u8ba1\u5212\u6210\u529f", (Object)VOS);
    }

    @RequestMapping(value={"/orderingSchedulesTime"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> orderingSchedulesTime() {
        this.service.orderingSchedulesTime();
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/updateStage"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MaterialplanVO> updateStage(@RequestBody MaterialplanVO saveOrUpdateVO) {
        MaterialplanEntity entity = (MaterialplanEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), MaterialplanEntity.class));
        entity.setStage(0);
        this.service.updateById((Object)entity);
        MaterialplanVO vo = (MaterialplanVO)((Object)BeanMapper.map((Object)((Object)entity), MaterialplanVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }
}

