package com.ejianc.business.purchasingmanagement.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 定料计划
 * 
 * @author generator
 * 
 */
 @TableName("ejc_purchasingmanagement_materialplan")
public class MaterialplanEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="org_id")
    private Long orgId; // id主键
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="task_id")
    private Long taskId; // 生产任务单主键
    @TableField(value="task_name")
    private String taskName; // 生产任务单名称
    @TableField(value="supplierinfo_id")
    private Long supplierinfoId; // 供应商基本档案主键
    @TableField(value="supplierinfo_name")
    private String supplierinfoName; // 供应商基本档案名称
    @TableField(value="material_id")
    private Long materialId; // 原材类主键
    @TableField(value="material_name")
    private String materialName; // 原材类名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="star_date")
    private Date starDate; // 开始日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="end_date")
    private Date endDate; // 结束日期
    @TableField(value="quantity")
    private BigDecimal quantity; // 数量
    @TableField(value="mdd_id")
    private Long mddId; // 目的地主键
    @TableField(value="mdd_name")
    private String mddName; // 目的地
    @TableField(value="issued_quantity")
    private BigDecimal issuedQuantity; // 已发数量
    @TableField(value="quantity_received")
    private BigDecimal quantityReceived; // 已收数量
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="purchasecontract_id")
    private Long purchasecontractId; // 采购合同主键
    @TableField(value="purchasecontractdetail_id")
    private Long purchasecontractdetailId; // 采购合同明细主键
    @TableField(value="price")
    private BigDecimal price; // 单价
    @TableField(value="material_tax")
    private BigDecimal materialTax; // 材料税率
    @TableField(value="freight_rate")
    private BigDecimal freightRate; // 运费税率
    @TableField(value="is_colse")
    private Integer isColse ;//是否关闭订料计划  0-是 1-否
    @TableField(value ="is_terminate")
    private Integer isTerminate;//是否关闭采购合同
    @TableField(value ="stage")
    private Integer stage;//是否过期  0-是  1-否
    @TableField(value ="is_consignment")
    private Integer isConsignment;//是否发货 0-已发货 1-未发货




    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getIssuedQuantity() {
        return issuedQuantity;
    }

    public void setIssuedQuantity(BigDecimal issuedQuantity) {
        this.issuedQuantity = issuedQuantity;
    }

    public BigDecimal getQuantityReceived() {
        return quantityReceived;
    }

    public void setQuantityReceived(BigDecimal quantityReceived) {
        this.quantityReceived = quantityReceived;
    }

    public BigDecimal getMaterialTax() {
        return materialTax;
    }

    public void setMaterialTax(BigDecimal materialTax) {
        this.materialTax = materialTax;
    }

    public BigDecimal getFreightRate() {
        return freightRate;
    }

    public void setFreightRate(BigDecimal freightRate) {
        this.freightRate = freightRate;
    }

    public Long getPurchasecontractId() {
        return purchasecontractId;
    }

    public void setPurchasecontractId(Long purchasecontractId) {
        this.purchasecontractId = purchasecontractId;
    }

    public Long getPurchasecontractdetailId() {
        return purchasecontractdetailId;
    }

    public void setPurchasecontractdetailId(Long purchasecontractdetailId) {
        this.purchasecontractdetailId = purchasecontractdetailId;
    }

    public String getMddName() {
        return mddName;
    }

    public void setMddName(String mddName) {
        this.mddName = mddName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getTaskId() {
        return taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }
    public String getTaskName() {
        return taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public Long getSupplierinfoId() {
        return supplierinfoId;
    }
    @ReferDeserialTransfer
    public void setSupplierinfoId(Long supplierinfoId) {
        this.supplierinfoId = supplierinfoId;
    }
    public String getSupplierinfoName() {
        return supplierinfoName;
    }

    public void setSupplierinfoName(String supplierinfoName) {
        this.supplierinfoName = supplierinfoName;
    }

    public Date getStarDate() {
        return starDate;
    }

    public void setStarDate(Date starDate) {
        this.starDate = starDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Long getMddId() {
        return mddId;
    }

    public void setMddId(Long mddId) {
        this.mddId = mddId;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getIsColse() {
        return isColse;
    }

    public void setIsColse(Integer isColse) {
        this.isColse = isColse;
    }
    public Integer getIsTerminate() {
        return isTerminate;
    }

    public void setIsTerminate(Integer isTerminate) {
        this.isTerminate = isTerminate;
    }
    public Integer getStage() {
        return stage;
    }

    public void setStage(Integer stage) {
        this.stage = stage;
    }

    public Integer getIsConsignment() {
        return isConsignment;
    }

    public void setIsConsignment(Integer isConsignment) {
        this.isConsignment = isConsignment;
    }
}
