package com.ejianc.business.purchasingmanagement.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 采购收货信息
 * 
 * @author generator
 * 
 */
 @TableName("ejc_purchasingmanagement_purchasereceipt")
public class PurchasereceiptEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="cgys_id")
    private Long cgysId; // 采购运输主键
    @TableField(value="supplierinfo_id")
    private Long supplierinfoId; // 供应商基本档案主键
    @TableField(value="supplierinfo_name")
    private String supplierinfoName; // 供应商基本档案名称
    @TableField(value="shippers_vehicle_id")
    private Long shippersVehicleId; // 运输车辆主键
    @TableField(value="shippers_vehicle_name")
    private String shippersVehicleName; // 运输车辆名称
    @TableField(value="number_plate")
    private String numberPlate; // 车号
    @TableField(value="tare")
    private BigDecimal tare; // 皮重
    @TableField(value="gross_weight")
    private BigDecimal grossWeight; // 毛重
    @TableField(value="net_weight")
    private BigDecimal netWeight; // 净重
    @TableField(value="receipt_time")
    private Date receiptTime; // 收货时间
    @TableField(value="material_id")
    private Long materialId; // 原材料名称主键
    @TableField(value="material_name")
    private String materialName; // 原材料名称名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="materialplan_id")
    private Long materialplanId; // 定料计划主键
    @TableField(value="unloaded_status")
    private Integer unloadedStatus; // 卸车状态 0 未卸车 1已卸车
    @TableField(value="audit")
    private Integer audit; //验收审核状态  0未审核  1已审核
    @TableField(value="receipt")
    private Integer receipt; //收货状态  0未收货完成  1已收货完成
    @TableField(value="unloaded_user")
    private String unloadedUser;   // 卸料人
    @TableField(value="unloaded_time")
    private Date unloadedTime;   // 卸料时间
    @TableField(value="print_gross_weight")
    private BigDecimal printGrossWeight; // 打印净重
    @TableField(value="deduction_rate")
    private BigDecimal deductionRate;  //扣率
    @TableField(value="decimal_point")
    private BigDecimal decimalPoint;  //小数点
    @TableField(value="return_status")
    private Integer returnStatus; //退货状态  0未退货  1已退货
    @TableField(value="receipt_type")
    private Integer receiptType; //收货类型，0-手动收货，1-自动收货
    @TableField(value="peel_back_time")
    private Date peelBackTime;//车辆回皮时间
    @TableField(value="receipts_time")
    private Date receiptsTime; // 回皮年月日
    @TableField(value="is_peel_back")
    private Integer isPeelBack; // 是否回皮 0-回皮 1-未回皮


    public Integer getReturnStatus() {
        return returnStatus;
    }

    public void setReturnStatus(Integer returnStatus) {
        this.returnStatus = returnStatus;
    }

    public BigDecimal getDeductionRate() {
        return deductionRate;
    }

    public void setDeductionRate(BigDecimal deductionRate) {
        this.deductionRate = deductionRate;
    }

    public BigDecimal getDecimalPoint() {
        return decimalPoint;
    }

    public void setDecimalPoint(BigDecimal decimalPoint) {
        this.decimalPoint = decimalPoint;
    }

    public BigDecimal getPrintGrossWeight() {
        return printGrossWeight;
    }

    public void setPrintGrossWeight(BigDecimal printGrossWeight) {
        this.printGrossWeight = printGrossWeight;
    }

    public String getUnloadedUser() {
        return unloadedUser;
    }

    public void setUnloadedUser(String unloadedUser) {
        this.unloadedUser = unloadedUser;
    }

    public Date getUnloadedTime() {
        return unloadedTime;
    }

    public void setUnloadedTime(Date unloadedTime) {
        this.unloadedTime = unloadedTime;
    }

    public Integer getUnloadedStatus() {
        return unloadedStatus;
    }

    public void setUnloadedStatus(Integer unloadedStatus) {
        this.unloadedStatus = unloadedStatus;
    }

    public Integer getReceipt() {
        return receipt;
    }

    public void setReceipt(Integer receipt) {
        this.receipt = receipt;
    }

    public Integer getAudit() {
        return audit;
    }

    public void setAudit(Integer audit) {
        this.audit = audit;
    }

    public Long getMaterialplanId() {
        return materialplanId;
    }

    public void setMaterialplanId(Long materialplanId) {
        this.materialplanId = materialplanId;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }



    public Long getCgysId() {
        return cgysId;
    }

    public void setCgysId(Long cgysId) {
        this.cgysId = cgysId;
    }
    public Long getSupplierinfoId() {
        return supplierinfoId;
    }

    public void setSupplierinfoId(Long supplierinfoId) {
        this.supplierinfoId = supplierinfoId;
    }
    public String getSupplierinfoName() {
        return supplierinfoName;
    }

    public void setSupplierinfoName(String supplierinfoName) {
        this.supplierinfoName = supplierinfoName;
    }
    public Long getShippersVehicleId() {
        return shippersVehicleId;
    }

    public void setShippersVehicleId(Long shippersVehicleId) {
        this.shippersVehicleId = shippersVehicleId;
    }
    public String getShippersVehicleName() {
        return shippersVehicleName;
    }

    public void setShippersVehicleName(String shippersVehicleName) {
        this.shippersVehicleName = shippersVehicleName;
    }
    public String getNumberPlate() {
        return numberPlate;
    }

    public void setNumberPlate(String numberPlate) {
        this.numberPlate = numberPlate;
    }

    public Date getReceiptTime() {
        return receiptTime;
    }

    public void setReceiptTime(Date receiptTime) {
        this.receiptTime = receiptTime;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public BigDecimal getTare() {
        return tare;
    }

    public void setTare(BigDecimal tare) {
        this.tare = tare;
    }

    public BigDecimal getGrossWeight() {
        return grossWeight;
    }

    public void setGrossWeight(BigDecimal grossWeight) {
        this.grossWeight = grossWeight;
    }

    public BigDecimal getNetWeight() {
        return netWeight;
    }

    public void setNetWeight(BigDecimal netWeight) {
        this.netWeight = netWeight;
    }

    public Integer getReceiptType() {
        return receiptType;
    }

    public void setReceiptType(Integer receiptType) {
        this.receiptType = receiptType;
    }
    public Date getPeelBackTime() {
        return peelBackTime;
    }

    public void setPeelBackTime(Date peelBackTime) {
        this.peelBackTime = peelBackTime;
    }

    public Date getReceiptsTime() {
        return receiptsTime;
    }

    public void setReceiptsTime(Date receiptsTime) {
        this.receiptsTime = receiptsTime;
    }

    public Integer getIsPeelBack() {
        return isPeelBack;
    }

    public void setIsPeelBack(Integer isPeelBack) {
        this.isPeelBack = isPeelBack;
    }
}
