package com.ejianc.business.purchasingmanagement.change.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.purchasingmanagement.change.bean.ChangeContractdetailEntity;
import com.ejianc.business.purchasingmanagement.record.bean.RecordPurchasecontractEntity;
/**
 * 采购合同变更表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_change_purchasingmanagement_purchasecontract")
public class ChangePurchasecontractEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="supplierinfo_id")
    private Long supplierinfoId; // 供应商基本档案主键
    @TableField(value="supplierinfo_name")
    private String supplierinfoName; // 供应商基本档案名称
    @TableField(value="org_id")
    private Long orgId; // 组织主键
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="contact_id")
    private Long contactId; // 联系人主键
    @TableField(value="contact_phone")
    private String contactPhone; // 联系人电话
    @TableField(value="start_date")
    private Date startDate; // 开始日期
    @TableField(value="end_date")
    private Date endDate; // 结束日期
    @TableField(value="counting_method")
    private Integer countingMethod; // 计数方式：1:收货数计 0:发货数计
    @TableField(value="contract")
    private Integer contract; // 合同方式：1:采购合同 0:销售合同
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="name")
    private String name; // 合同名称
    @TableField(value="contact_name")
    private String contactName; // 联系人姓名
    @TableField(value="contract_types")
    private Long contractTypes; // 合同类型
    @TableField(value="stage")
    private Integer stage; // 是否过期 0 未过期 /  1 已过期
    @TableField(value="contract_quantity")
    private BigDecimal contractQuantity; // 合同数量
    @TableField(value="contract_amount")
    private BigDecimal contractAmount; // 合同金额
    @TableField(value="receipt_quantity")
    private BigDecimal receiptQuantity; // 收货数量
    @TableField(value="receipt_amount")
    private BigDecimal receiptAmount; // 收货金额
    @TableField(value="shipping_amount")
    private BigDecimal shippingAmount; // 运费金额
    @TableField(value="contract_types_name")
    private String contractTypesName; // 合同类型名称
    @TableField(value="is_major_contracts")
    private Long isMajorContracts; // 是否属于重大合同
    @TableField(value="transporter_id")
    private Long transporterId; // 运输商主键
    @TableField(value="transporter_name")
    private String transporterName; // 运输商名称
    @TableField(value="is_terminate")
    private Integer isTerminate; // 是否终止  1未终止  0未终止
    @TableField(value="change_id")
    private Long changeId; // 变更单据id
    @TableField(value="change_state")
    private String changeState; // 变更状态，1:未变更;2:变更中;3:已变更
    @TableField(value="effect_date")
    private Date effectDate; // 生效时间
    @TableField(value="change_reason")
    private String changeReason; // 变更原因
    @TableField(value="original_id")
    private Long originalId; // 原始单据id
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="changeContractdetailService",pidName = "mid")//此处有pid="xxx"，默认值pid="pid"
    private List<ChangeContractdetailEntity> changeContractdetailList = new ArrayList<>(); // 采购合同变更子表
    

    public Long getSupplierinfoId() {
        return supplierinfoId;
    }

    public void setSupplierinfoId(Long supplierinfoId) {
        this.supplierinfoId = supplierinfoId;
    }
    public String getSupplierinfoName() {
        return supplierinfoName;
    }

    public void setSupplierinfoName(String supplierinfoName) {
        this.supplierinfoName = supplierinfoName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getContactId() {
        return contactId;
    }

    public void setContactId(Long contactId) {
        this.contactId = contactId;
    }
    public String getContactPhone() {
        return contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public Integer getCountingMethod() {
        return countingMethod;
    }

    public void setCountingMethod(Integer countingMethod) {
        this.countingMethod = countingMethod;
    }
    public Integer getContract() {
        return contract;
    }

    public void setContract(Integer contract) {
        this.contract = contract;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getContactName() {
        return contactName;
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }
    public Long getContractTypes() {
        return contractTypes;
    }

    public void setContractTypes(Long contractTypes) {
        this.contractTypes = contractTypes;
    }
    public Integer getStage() {
        return stage;
    }

    public void setStage(Integer stage) {
        this.stage = stage;
    }
    public BigDecimal getContractQuantity() {
        return contractQuantity;
    }

    public void setContractQuantity(BigDecimal contractQuantity) {
        this.contractQuantity = contractQuantity;
    }
    public BigDecimal getContractAmount() {
        return contractAmount;
    }

    public void setContractAmount(BigDecimal contractAmount) {
        this.contractAmount = contractAmount;
    }
    public BigDecimal getReceiptQuantity() {
        return receiptQuantity;
    }

    public void setReceiptQuantity(BigDecimal receiptQuantity) {
        this.receiptQuantity = receiptQuantity;
    }
    public BigDecimal getReceiptAmount() {
        return receiptAmount;
    }

    public void setReceiptAmount(BigDecimal receiptAmount) {
        this.receiptAmount = receiptAmount;
    }
    public BigDecimal getShippingAmount() {
        return shippingAmount;
    }

    public void setShippingAmount(BigDecimal shippingAmount) {
        this.shippingAmount = shippingAmount;
    }
    public String getContractTypesName() {
        return contractTypesName;
    }

    public void setContractTypesName(String contractTypesName) {
        this.contractTypesName = contractTypesName;
    }
    public Long getIsMajorContracts() {
        return isMajorContracts;
    }

    public void setIsMajorContracts(Long isMajorContracts) {
        this.isMajorContracts = isMajorContracts;
    }
    public Long getTransporterId() {
        return transporterId;
    }

    public void setTransporterId(Long transporterId) {
        this.transporterId = transporterId;
    }
    public String getTransporterName() {
        return transporterName;
    }

    public void setTransporterName(String transporterName) {
        this.transporterName = transporterName;
    }
    public Integer getIsTerminate() {
        return isTerminate;
    }

    public void setIsTerminate(Integer isTerminate) {
        this.isTerminate = isTerminate;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getChangeState() {
        return changeState;
    }

    public void setChangeState(String changeState) {
        this.changeState = changeState;
    }
    public Date getEffectDate() {
        return effectDate;
    }

    public void setEffectDate(Date effectDate) {
        this.effectDate = effectDate;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    
    public List<ChangeContractdetailEntity> getChangeContractdetailList() {
        return changeContractdetailList;
    }

    public void setChangeContractdetailList(List<ChangeContractdetailEntity> changeContractdetailList) {
        this.changeContractdetailList = changeContractdetailList;
    }

    public Long getOriginalId() {
        return originalId;
    }

    public void setOriginalId(Long originalId) {
        this.originalId = originalId;
    }
}
