package com.ejianc.business.purchasingmanagement.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.purchasingmanagement.bean.*;
import com.ejianc.business.purchasingmanagement.service.*;
import com.ejianc.business.purchasingmanagement.vo.*;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/api/purchasingmanagement/purchaseListApi/")
public class PurchaseListApi {
    @Autowired
    private IPurchaseContractService PurchaseContractService;//采购合同
    @Autowired
    private IMaterialplanService MaterialplanService;//订料计划
    @Autowired
    private IMaterialpaymentService materialpaymentService;//

    @Autowired
    private ITransporterpaymentService transporterpaymentService;//运输商付款单

    @Autowired
    private IPurchasetransportationService purchasetransportationService;//采购运输单

    @Autowired
    private IShippersinvoiceService shippersinvoiceService;//运输商发票


    @Autowired
    private ISupplierinvoiceService supplierinvoiceService;//供应商发票
    @Autowired
    private IPurchasecontractdetailService purchasecontractdetailService; //采购合同明细

    @Autowired
    private IPurchasedetilService purchasedetilService;
    /**
     * @Description  采购合同查询列表
     */
    @RequestMapping(value = "/contractList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PurchaseContractVO>> contractList(@RequestBody RequestVO requestVO) {
        QueryParam param = new QueryParam();
        param.setPageIndex(requestVO.getPageIndex());
        param.setPageSize(requestVO.getPageSize());
        param.getParams().put("supplierinfo_id", new Parameter(QueryParam.EQ,requestVO.getId()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ,0));
        param.getOrderMap().put("create_time",QueryParam.DESC);
        IPage<PurchaseContractEntity> page = PurchaseContractService.queryPage(param,false);
        IPage<PurchaseContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchaseContractVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description  供应商付款单查询列表
     */
    @RequestMapping(value = "/receiptList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialpaymentVO>> receiptList(@RequestBody RequestVO requestVO) {
        QueryParam param = new QueryParam();
        param.setPageIndex(requestVO.getPageIndex());
        param.setPageSize(requestVO.getPageSize());
        param.getParams().put("supplierinfo_id", new Parameter(QueryParam.EQ,requestVO.getId()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ,0));
        param.getOrderMap().put("create_time",QueryParam.DESC);
        IPage<MaterialpaymentEntity> page = materialpaymentService.queryPage(param,false);
        IPage<MaterialpaymentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialpaymentVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description  运输商付款单查询列表
     */
    @RequestMapping(value = "/transportersReceiptList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TransporterpaymentVO>> transportersReceiptList(@RequestBody RequestVO requestVO) {
        QueryParam param = new QueryParam();
        param.setPageIndex(requestVO.getPageIndex());
        param.setPageSize(requestVO.getPageSize());
        param.getParams().put("shippers_id", new Parameter(QueryParam.EQ,requestVO.getId()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ,0));
        param.getOrderMap().put("create_time",QueryParam.DESC);
        IPage<TransporterpaymentEntity> page = transporterpaymentService.queryPage(param,false);
        IPage<TransporterpaymentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), TransporterpaymentVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description  采购运输单查询列表
     */
    @RequestMapping(value = "/shippingList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PurchasetransportationVO>> shippingList(@RequestBody RequestVO requestVO) {
        QueryParam param = new QueryParam();
        param.setPageIndex(requestVO.getPageIndex());
        param.setPageSize(requestVO.getPageSize());
        param.getParams().put("shippers_id", new Parameter(QueryParam.EQ,requestVO.getId()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ,0));
        param.getOrderMap().put("create_time",QueryParam.DESC);
        IPage<PurchasetransportationEntity> page = purchasetransportationService.queryPage(param,false);
        IPage<PurchasetransportationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchasetransportationVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description  运输商发票列表
     */
    @RequestMapping(value = "/shippersinvoiceList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ShippersinvoiceVO>> shippersinvoiceList(@RequestBody RequestVO requestVO) {
        QueryParam param = new QueryParam();
        param.setPageIndex(requestVO.getPageIndex());
        param.setPageSize(requestVO.getPageSize());
        param.getParams().put("shippers_id", new Parameter(QueryParam.EQ,requestVO.getId()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ,0));
        param.getOrderMap().put("create_time",QueryParam.DESC);
        IPage<ShippersinvoiceEntity> page = shippersinvoiceService.queryPage(param,false);
        IPage<ShippersinvoiceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ShippersinvoiceVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description  供应商发票列表
     */
    @RequestMapping(value = "/supplierinvoiceList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SupplierinvoiceVO>> supplierinvoiceList(@RequestBody RequestVO requestVO) {
        QueryParam param = new QueryParam();
        param.setPageIndex(requestVO.getPageIndex());
        param.setPageSize(requestVO.getPageSize());
        param.getParams().put("supplierinfo_id", new Parameter(QueryParam.EQ,requestVO.getId()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ,0));
        param.getOrderMap().put("create_time",QueryParam.DESC);
        IPage<SupplierinvoiceEntity> page = supplierinvoiceService.queryPage(param,false);
        IPage<SupplierinvoiceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SupplierinvoiceVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description  运输单详情
     */
    @RequestMapping(value = "/shipping", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<PurchasetransportationVO> shipping(@RequestBody  PurchasetransportationVO purchasetransportationVO){
        PurchasetransportationEntity entity = purchasetransportationService.selectById(purchasetransportationVO.getId());
        PurchasetransportationVO vo = BeanMapper.map(entity, PurchasetransportationVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description  保存运输单明细
     */
    @RequestMapping(value = "/saveShipping", method = RequestMethod.POST)
    @ResponseBody
     CommonResponse<PurchasedetilVO>saveShipping(@RequestBody  PurchasedetilVO PurchasedetilVO){
        PurchasedetilEntity entity = BeanMapper.map(PurchasedetilVO, PurchasedetilEntity.class);
        purchasedetilService.saveOrChange(PurchasedetilVO);
        PurchasedetilVO vo = BeanMapper.map(entity, PurchasedetilVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }



    /**
     * @Description  采购运输单查询列表
     */
    @RequestMapping(value = "/supplierShippingList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PurchasetransportationVO>> supplierShippingList(@RequestBody Request2VO requestVO) {
        QueryParam param = new QueryParam();
        param.setPageIndex(requestVO.getPageIndex());
        param.setPageSize(requestVO.getPageSize());
        param.getParams().put("supplierinfo_id", new Parameter(QueryParam.EQ,requestVO.getId()));
        param.getParams().put("org_id", new Parameter(QueryParam.EQ,requestVO.getOrgId()));
//        if(requestVO.getEndTime()!=null){
//            param.getParams().put("end_time", new Parameter(QueryParam.LIKE_RIGHT,requestVO.getEndTime()));
//        }
        if(requestVO.getStartingTime()!=null && requestVO.getEndTime() != null && requestVO.getIsLatest().equals("0")){
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

            String tiem = sdf.format(requestVO.getStartingTime()) + " 00:00:00" + "," +  sdf.format(requestVO.getEndTime()) + " 23:59:59";
            param.getParams().put("starting_time", new Parameter(QueryParam.BETWEEN,tiem));
            param.getParams().put("end_time",new Parameter(QueryParam.GT,sdf.format(new Date()) + " 23:59:59"));
        }else{
            if(requestVO.getStartingTime()!=null && requestVO.getEndTime() != null){
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                String tiem = sdf.format(requestVO.getStartingTime()) + " 00:00:00" + "," +  sdf.format(requestVO.getEndTime()) + " 23:59:59";
                param.getParams().put("end_time", new Parameter(QueryParam.BETWEEN,tiem));
            }
        }
        if(requestVO.getMaterialName()!=null){
            param.getParams().put("material_name", new Parameter(QueryParam.LIKE,requestVO.getMaterialName()));
        }
        if(requestVO.getIsLatest().equals("0")){
            param.getParams().put("is_colse", new Parameter(QueryParam.EQ,"1"));
        }
        param.getOrderMap().put("create_time",QueryParam.DESC);
        IPage<PurchasetransportationEntity> page = purchasetransportationService.queryPage(param,false);
        IPage<PurchasetransportationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchasetransportationVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description  采购合同查询列表
     */
    @RequestMapping(value = "/contractListByID", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PurchaseContractVO>> contractListByID(@RequestBody RequestVO requestVO) {
        QueryParam param = new QueryParam();

        param.getParams().put("dr", new Parameter(QueryParam.EQ,0));
        param.getOrderMap().put("create_time",QueryParam.DESC);

        QueryWrapper<PurchasecontractdetailEntity> queryWrapper=new QueryWrapper();
        queryWrapper.eq("material_id",requestVO.getId());
        queryWrapper.eq("dr",0);

        List<PurchasecontractdetailEntity> purchasecontractdetailEntities = purchasecontractdetailService.list(queryWrapper);
        String id = "";
        for ( PurchasecontractdetailEntity temp : purchasecontractdetailEntities) {
            id  = id + temp.getPurchasecontractId()+",";
        }
        param.setPageIndex(requestVO.getPageIndex());
        param.setPageSize(requestVO.getPageSize());
        param.getParams().put("id", new Parameter(QueryParam.IN,id));
        IPage<PurchaseContractEntity> page = PurchaseContractService.queryPage(param,false);
        IPage<PurchaseContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchaseContractVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    @RequestMapping(value = "/deleteShipping", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> deleteShipping(@RequestBody RequestVO RequestVO) {
        purchasedetilService.removeById(RequestVO.getId(),true);
        return CommonResponse.success("删除成功！");
    }

    @RequestMapping(value = "/detailShipping", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PurchasedetilVO> detailShipping( RequestVO RequestVO) {
        PurchasedetilEntity entity = purchasedetilService.selectById(RequestVO.getId());
        PurchasedetilVO vo = BeanMapper.map(entity, PurchasedetilVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    //采购合同的定时任务
    @RequestMapping(value = "/contractTime", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> contractTime() {
        PurchaseContractService.contractTime();
        return CommonResponse.success("保存或修改单据成功！");
    }
    //订料计划的定时任务
    @RequestMapping(value = "/orderingSchedulesTime", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> orderingSchedulesTime() {
        MaterialplanService.orderingSchedulesTime();
        return CommonResponse.success("保存或修改单据成功！");
    }

    @Autowired
    private IPurchasereceiptService purchasereceiptService;


    @RequestMapping(value = "/purchasereceiptDetil", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PurchasereceiptVO> purchasereceiptDetil(@RequestBody PurchasereceiptVO purchasereceiptVO) {

        QueryWrapper<PurchasereceiptEntity> queryWrapper=new QueryWrapper();
        queryWrapper.eq("materialplan_id",purchasereceiptVO.getMaterialplanId());
        queryWrapper.eq("number_plate",purchasereceiptVO.getNumberPlate());
        queryWrapper.eq("cgys_id",purchasereceiptVO.getPurchasedetilId());
        PurchasereceiptEntity purchasereceiptEntity = purchasereceiptService.getOne(queryWrapper);
        PurchasereceiptVO vo = new  PurchasereceiptVO();
        if(purchasereceiptEntity!=null){
            vo = BeanMapper.map(purchasereceiptEntity, PurchasereceiptVO.class);
        }
        if(purchasereceiptEntity!=null) {
            return CommonResponse.success("查询详情数据成功！", vo);
        }else {
            return CommonResponse.error("查询详情数据成功！",vo);
        }
    }







}
