package com.ejianc.business.purchasingmanagement.service.impl;

import com.ejianc.business.purchasingmanagement.bean.MaterialacceptanceEntity;
import com.ejianc.business.purchasingmanagement.bean.MaterialpaymentEntity;
import com.ejianc.business.purchasingmanagement.bean.MaterialpaymentdetailEntity;
import com.ejianc.business.purchasingmanagement.service.IMaterialacceptanceService;
import com.ejianc.business.purchasingmanagement.service.IMaterialpaymentService;
import com.ejianc.business.purchasingmanagement.service.IMaterialpaymentdetailService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

@Service("materialpayment") 
public class MaterialpaymentBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}


	@Autowired
	private IMaterialpaymentService service;
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IMaterialacceptanceService materialacceptanceService;

	@Autowired
	private IMaterialpaymentdetailService materialpaymentdetailService;
	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("---------进来啦--------");
		MaterialpaymentEntity entity  =  service.selectById(billId);
		if(entity.getMaterialpaymentdetailList()!=null){
			logger.info("---------不为空--------");
			for(MaterialpaymentdetailEntity temp : entity.getMaterialpaymentdetailList()){
				MaterialacceptanceEntity materialacceptanceEntity =materialacceptanceService.selectById(temp.getMaterialacceptanceId());
				materialacceptanceEntity.setAmountPaid(temp.getDistributionMoney().add(materialacceptanceEntity.getAmountPaid()));//已付金额 = 已付金额 + 分配金额
				materialacceptanceEntity.setAmountNotPaid(materialacceptanceEntity.getTotalAmount().subtract(materialacceptanceEntity.getAmountPaid()));//未收金额 = 应收-已付
				materialacceptanceService.updateById(materialacceptanceEntity);
				//未付金额
				temp.setUncollectedMoney(materialacceptanceEntity.getTotalAmount().subtract(materialacceptanceEntity.getAmountPaid()));
				temp.setReceivedMoney(temp.getDistributionMoney());//本单已付金额
				logger.info("---------已修改--------");
				materialpaymentdetailService.updateById(temp);
			}
		}
		entity.setBillState(state);
		service.updateById(entity);
		logger.info("---------结束--------");

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
